/*
 * Decompiled with CFR 0.152.
 */
package testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.BlockClosed;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.BlockOpened;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.CompilationFinished;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.CompilationStarted;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.InternalErrorMessage;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.Message;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestFailed;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestFinished;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestNavigationInfo;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestStarted;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMessage {
    private static final int FORMAT_WITHOUT_TZ_LEN = "yyyy-MM-dd'T'HH:mm:ss.SSS".replace("'", "").length();
    private static final Map<String, Class<? extends ServiceMessage>> SERVICE_MESSAGE_CLASSES = new HashMap<String, Class<? extends ServiceMessage>>();
    private String myMessageName;
    private final Map<String, String> myAttributes;
    private String myArgument;
    private Timestamp myCreationTimestamp;
    private String myFlowId;
    private List<String> myTags;

    ServiceMessage() {
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
    }

    protected ServiceMessage(String messageName, Map<String, String> attributes) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            ServiceMessage.$$$reportNull$$$0(3);
        }
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
        this.myMessageName = messageName;
        try {
            this.populateAttributes(attributes);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getFlowId() {
        return this.myFlowId;
    }

    public Map<String, String> getAttributes() {
        Map<String, String> map = Collections.unmodifiableMap(this.myAttributes);
        if (map == null) {
            ServiceMessage.$$$reportNull$$$0(12);
        }
        return map;
    }

    public void visit(ServiceMessageVisitor visitor) {
        if (visitor == null) {
            ServiceMessage.$$$reportNull$$$0(13);
        }
        visitor.visitServiceMessage(this);
    }

    public void setTimestamp(Date timestamp) {
        if (timestamp == null) {
            ServiceMessage.$$$reportNull$$$0(14);
        }
        this.myAttributes.put("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(timestamp));
        this.myCreationTimestamp = new Timestamp(timestamp, true);
    }

    public void setFlowId(String flowId) {
        if (flowId == null) {
            ServiceMessage.$$$reportNull$$$0(15);
        }
        this.myAttributes.put("flowId", flowId);
        this.myFlowId = flowId;
    }

    public void addTag(String tag) {
        if (tag == null) {
            ServiceMessage.$$$reportNull$$$0(16);
        }
        this.myTags = new ArrayList<String>(this.myTags);
        if (!this.myTags.contains(tag)) {
            this.myTags.add(tag);
        }
    }

    protected String getAttributeValue(String attrName) {
        if (attrName == null) {
            ServiceMessage.$$$reportNull$$$0(17);
        }
        return this.getAttributes().get(attrName);
    }

    private void populateAttributes(Map<String, String> attributes) throws ParseException {
        this.myAttributes.putAll(attributes);
        if (this.myAttributes.containsKey("tc:arg")) {
            this.myArgument = this.myAttributes.get("tc:arg");
            this.myAttributes.remove("tc:arg");
        }
        if (this.myAttributes.containsKey("tc:tags")) {
            String tagsStr = this.myAttributes.get("tc:tags");
            this.myTags = ServiceMessage.splitTags(tagsStr);
            this.myAttributes.remove("tc:tags");
        }
        this.parseCreationTimestamp();
        this.parseFlowId();
    }

    private static List<String> splitTags(String tagsStr) {
        StringTokenizer tok = new StringTokenizer(tagsStr, ",");
        ArrayList<String> result = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            result.add(tok.nextToken().trim());
        }
        return Collections.unmodifiableList(result);
    }

    private void parseFlowId() {
        this.myFlowId = this.getAttributeValue("flowId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCreationTimestamp() throws ParseException {
        String creationTimestampStr = this.getAttributeValue("timestamp");
        if (creationTimestampStr == null) {
            this.myCreationTimestamp = null;
            return;
        }
        creationTimestampStr = creationTimestampStr.replace("'T'", "T");
        ServiceMessage serviceMessage = this;
        synchronized (serviceMessage) {
            this.myCreationTimestamp = creationTimestampStr.length() == FORMAT_WITHOUT_TZ_LEN ? new Timestamp(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(creationTimestampStr), false) : new Timestamp(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(creationTimestampStr), true);
        }
    }

    public String asString() {
        if (this.myArgument != null && this.myTags.isEmpty()) {
            String string = ServiceMessage.asString(this.myMessageName, this.myArgument);
            if (string == null) {
                ServiceMessage.$$$reportNull$$$0(34);
            }
            return string;
        }
        LinkedHashMap<String, String> fullAttrMap = new LinkedHashMap<String, String>();
        if (this.myArgument != null) {
            fullAttrMap.put("tc:arg", this.myArgument);
        }
        if (!this.myTags.isEmpty()) {
            StringBuilder tagsStr = new StringBuilder();
            for (String tag : this.myTags) {
                if (tagsStr.length() > 0) {
                    tagsStr.append(",");
                }
                tagsStr.append(tag);
            }
            fullAttrMap.put("tc:tags", tagsStr.toString());
        }
        fullAttrMap.putAll(this.myAttributes);
        String string = ServiceMessage.asString(this.myMessageName, fullAttrMap);
        if (string == null) {
            ServiceMessage.$$$reportNull$$$0(35);
        }
        return string;
    }

    public static String asString(String messageName, Map<String, String> attributes) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(36);
        }
        if (attributes == null) {
            ServiceMessage.$$$reportNull$$$0(37);
        }
        StringBuilder text = new StringBuilder();
        ServiceMessage.appendMessageName(text, messageName);
        if (!attributes.isEmpty()) {
            text.append(' ');
            text.append(MapSerializerUtil.propertiesToString(attributes, MapSerializerUtil.STD_ESCAPER2));
        }
        text.append("]");
        String string = text.toString();
        if (string == null) {
            ServiceMessage.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static String asString(String messageName, String argument) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(39);
        }
        if (argument == null) {
            ServiceMessage.$$$reportNull$$$0(40);
        }
        StringBuilder text = new StringBuilder();
        ServiceMessage.appendMessageName(text, messageName);
        text.append(" '");
        text.append(MapSerializerUtil.escapeStr(argument, MapSerializerUtil.STD_ESCAPER2));
        text.append("'");
        text.append("]");
        String string = text.toString();
        if (string == null) {
            ServiceMessage.$$$reportNull$$$0(41);
        }
        return string;
    }

    private static void appendMessageName(StringBuilder target, String messageName) {
        target.append("##teamcity[");
        target.append(messageName);
    }

    public String toString() {
        return this.asString();
    }

    static {
        SERVICE_MESSAGE_CLASSES.put("progressMessage", ProgressMessage.class);
        SERVICE_MESSAGE_CLASSES.put("progressStart", ProgressStart.class);
        SERVICE_MESSAGE_CLASSES.put("progressFinish", ProgressFinish.class);
        SERVICE_MESSAGE_CLASSES.put("publishArtifacts", PublishArtifacts.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteStarted", TestSuiteStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteFinished", TestSuiteFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testStarted", TestStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testFailed", TestFailed.class);
        SERVICE_MESSAGE_CLASSES.put("testFinished", TestFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testIgnored", TestIgnored.class);
        SERVICE_MESSAGE_CLASSES.put("testStdOut", TestStdOut.class);
        SERVICE_MESSAGE_CLASSES.put("testStdErr", TestStdErr.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatus", BuildStatus.class);
        SERVICE_MESSAGE_CLASSES.put("buildNumber", BuildNumber.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatisticValue", BuildStatisticValue.class);
        SERVICE_MESSAGE_CLASSES.put("testNavigationInfo", TestNavigationInfo.class);
        SERVICE_MESSAGE_CLASSES.put("blockOpened", BlockOpened.class);
        SERVICE_MESSAGE_CLASSES.put("blockClosed", BlockClosed.class);
        SERVICE_MESSAGE_CLASSES.put("compilationStarted", CompilationStarted.class);
        SERVICE_MESSAGE_CLASSES.put("compilationFinished", CompilationFinished.class);
        SERVICE_MESSAGE_CLASSES.put("message", Message.class);
        SERVICE_MESSAGE_CLASSES.put("internalError", InternalErrorMessage.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageName";
                break;
            }
            case 3: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: 
            case 7: 
            case 18: 
            case 22: 
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mixedText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserCallback";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testng_listener_teamcity_service_messages/jetbrains/buildServer/messages/serviceMessages/ServiceMessage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairs";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "testng_listener_teamcity_service_messages/jetbrains/buildServer/messages/serviceMessages/ServiceMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitTextToPotentialMessages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "splitTextToServiceMessagesAndRegularText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSimple";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToText";
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "splitTextToPotentialMessages";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 41: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReservedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setFlowId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTag";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "splitTextToServiceMessagesAndRegularText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAnyWhitespace";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseSimple";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addMessageToListIfNotEmpty";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findMessageEnd";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "stringToText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "asString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Timestamp {
        private final Date myTimestamp;
        private final boolean myTimeZoneWasSpecified;

        public Timestamp(Date timestamp, boolean timeZoneWasSpecified) {
            this.myTimestamp = timestamp;
            this.myTimeZoneWasSpecified = timeZoneWasSpecified;
        }
    }
}

