/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.cli.DockerCliParserBase;
import com.intellij.docker.agent.fix.FixedBindParser;
import com.intellij.docker.agent.fix.FixedCreateContainerCmdExecWithAutoRemove;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class DockerCliParser
extends DockerCliParserBase<CreateContainerCmd> {
    public void parse(CreateContainerCmd cmd, String[] optionsLine) throws ApiTaskException {
        try {
            super.doParse((Object)cmd, optionsLine);
        }
        catch (DockerCliParserBase.IllegalOptionException | ParseException e) {
            throw new ApiTaskException((Exception)e);
        }
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> hostname(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withHostName);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> user(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withUser);
    }

    protected DockerCliParserBase.MemoryOptionHandler<CreateContainerCmd> memory(Option option) {
        return new DockerCliParserBase.MemoryOptionHandler(option, CreateContainerCmd::withMemory);
    }

    protected DockerCliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwap(Option option) {
        return new DockerCliParserBase.MemoryOptionHandler(option, CreateContainerCmd::withMemorySwap);
    }

    protected DockerCliParserBase.IntegerOptionHandler<CreateContainerCmd> memorySwappiness(Option option) {
        return new DockerCliParserBase.IntegerOptionHandler(option, (cmd, intValue) -> DockerCliParser.findOrCreateHostConfig(cmd).withMemorySwappiness(intValue));
    }

    protected DockerCliParserBase.MemoryOptionHandler<CreateContainerCmd> shmSize(Option option) {
        return new DockerCliParserBase.MemoryOptionHandler(option, (cmd, size) -> DockerCliParser.findOrCreateHostConfig(cmd).withShmSize(size));
    }

    protected DockerCliParserBase.MemoryOptionHandler<CreateContainerCmd> kernelMemory(Option option) {
        return new DockerCliParserBase.MemoryOptionHandler(option, (cmd, size) -> DockerCliParser.findOrCreateHostConfig(cmd).withKernelMemory(size));
    }

    protected DockerCliParserBase.MemoryOptionHandler<CreateContainerCmd> memoryReservation(Option option) {
        return new DockerCliParserBase.MemoryOptionHandler(option, (cmd, size) -> DockerCliParser.findOrCreateHostConfig(cmd).withMemoryReservation(size));
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> cpusetCpus(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withCpusetCpus);
    }

    protected DockerCliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuShares(Option option) {
        return new DockerCliParserBase.IntegerOptionHandler(option, CreateContainerCmd::withCpuShares);
    }

    protected DockerCliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuPeriod(Option option) {
        return new DockerCliParserBase.IntegerOptionHandler(option, CreateContainerCmd::withCpuPeriod);
    }

    protected DockerCliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuQuota(Option option) {
        return new DockerCliParserBase.IntegerOptionHandler(option, (cmd, quota) -> DockerCliParser.findOrCreateHostConfig(cmd).withCpuQuota(quota));
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> cpusetMems(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withCpusetMems);
    }

    protected DockerCliParserBase.DoubleOptionHandler<CreateContainerCmd> cpus(Option option) {
        return new DockerCliParserBase.DoubleOptionHandler(option, (cmd, ratio) -> {
            if (ratio > 1.0 || ratio < 0.0) {
                throw new DockerCliParserBase.IllegalOptionException("'--cpus' value should be between 0 and 1");
            }
            int DEFAULT_PERIOD = 100000;
            DockerCliParser.findOrCreateHostConfig(cmd).withCpuPeriod(Integer.valueOf(100000)).withCpuQuota(Integer.valueOf((int)(ratio * 100000.0)));
        });
    }

    protected DockerCliParserBase.IntegerOptionHandler<CreateContainerCmd> blkioWeight(Option option) {
        return new DockerCliParserBase.IntegerOptionHandler(option, CreateContainerCmd::withBlkioWeight);
    }

    protected DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd> oomKillDisable(Option option) {
        return new DockerCliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withOomKillDisable);
    }

    protected DockerCliParserBase.AttachOptionHandler<CreateContainerCmd> attach(Option option) {
        return new DockerCliParserBase.AttachOptionHandler(option, CreateContainerCmd::withAttachStdin, CreateContainerCmd::withAttachStdout, CreateContainerCmd::withAttachStderr);
    }

    protected DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd> detach(Option option) {
        return new DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                if (value) {
                    ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.valueOf(false)).withAttachStdout(Boolean.valueOf(false)).withAttachStderr(Boolean.valueOf(false));
                }
            }
        };
    }

    protected DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd> tty(Option option) {
        return new DockerCliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withTty);
    }

    protected DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd> interactive(Option option) {
        return new DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                ((CreateContainerCmd)this.getCmd()).withStdinOpen(Boolean.valueOf(value));
                ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.valueOf(value));
            }
        };
    }

    protected DockerCliParserBase.ListHandler<CreateContainerCmd> env(Option option) {
        return new DockerCliParserBase.MappedListHandler(option, String.class, DockerCliParser::appendSystemValueIfFound, DockerCliParser::appendToCmdEnvironment);
    }

    protected DockerCliParserBase.EnvFileListHandler envFile(Option option) {
        return new DockerCliParserBase.EnvFileListHandler(option){

            protected void handleEnvFile(String optionValue, File file) {
                String[] envVars;
                try {
                    envVars = (String[])Files.lines(file.toPath()).map(String::trim).filter(text -> !text.isEmpty() && !text.startsWith("#")).map(x$0 -> DockerCliParser.appendSystemValueIfFound(x$0)).toArray(String[]::new);
                }
                catch (IOException e) {
                    throw new DockerCliParserBase.IllegalOptionException("Error reading env-file " + optionValue);
                }
                DockerCliParser.appendToCmdEnvironment((CreateContainerCmd)this.getCmd(), envVars);
            }
        };
    }

    private static String appendSystemValueIfFound(String varDeclaration) {
        String localSystemValue;
        if (!varDeclaration.contains("=") && (localSystemValue = System.getProperty(varDeclaration)) != null && !localSystemValue.isEmpty()) {
            varDeclaration = varDeclaration + "=" + localSystemValue;
        }
        return varDeclaration;
    }

    private static void appendToCmdEnvironment(CreateContainerCmd cmd, String ... env) {
        new ValueTransfer.CombiningArrayTransfer(String.class, Function.identity(), CreateContainerCmd::getEnv, CreateContainerCmd::withEnv).transferFromTo(env, cmd);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> entrypoint(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, (rec$, xva$0) -> ((CreateContainerCmd)rec$).withEntrypoint(new String[]{xva$0}));
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> workingDir(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withWorkingDir);
    }

    protected DockerCliParserBase.ListHandler<CreateContainerCmd> expose(Option option) {
        return new DockerCliParserBase.MappedListHandler(option, ExposedPort.class, ExposedPort::parse, CreateContainerCmd::withExposedPorts);
    }

    protected DockerCliParserBase.StringListHandler<CreateContainerCmd> addHost(Option option) {
        return new DockerCliParserBase.StringListHandler(option, CreateContainerCmd::withExtraHosts);
    }

    protected DockerCliParserBase.LabelListHandler<CreateContainerCmd> label(Option option) {
        return new DockerCliParserBase.LabelListHandler<CreateContainerCmd>(option){

            protected void handleLabelsMap(Map<String, String> parsedMap) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                Optional.ofNullable(((CreateContainerCmd)this.getCmd()).getLabels()).ifPresent(resultMap::putAll);
                resultMap.putAll(parsedMap);
                ((CreateContainerCmd)this.getCmd()).withLabels(resultMap);
            }
        };
    }

    protected DockerCliParserBase.ListHandler<CreateContainerCmd> securityOpt(Option option) {
        return new DockerCliParserBase.StringListHandler(option, (cmd, values) -> DockerCliParser.findOrCreateHostConfig(cmd).withSecurityOpts(new ArrayList<String>(Arrays.asList(values))));
    }

    protected DockerCliParserBase.ListHandler<CreateContainerCmd> volume(Option option) {
        return new DockerCliParserBase.ListHandler<CreateContainerCmd>(option){

            protected void handleValueList(String[] values) {
                ArrayList<Volume> volumes = new ArrayList<Volume>();
                ArrayList<Bind> binds = new ArrayList<Bind>();
                for (String value : values) {
                    if (!value.contains(":")) {
                        volumes.add(new Volume(value));
                        continue;
                    }
                    binds.add(FixedBindParser.parse(value));
                }
                if (!volumes.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withVolumes(volumes);
                }
                if (!binds.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withBinds(binds);
                }
            }
        };
    }

    protected DockerCliParserBase.LinkOptionHandler<CreateContainerCmd, ?> link(Option option) {
        return new DockerCliParserBase.LinkOptionHandler<CreateContainerCmd, Link>(option, CreateContainerCmd::withLinks){

            protected Link createLink(String name, String alias) {
                return new Link(name, alias);
            }
        };
    }

    protected DockerCliParserBase.ListHandler<CreateContainerCmd> lxcConf(Option option) {
        return new DockerCliParserBase.MappedListHandler(option, LxcConf.class, source -> {
            String[] parts = source.split("=", 2);
            if (parts.length == 2) {
                return new LxcConf(parts[0].trim(), parts[1].trim());
            }
            throw new DockerCliParserBase.IllegalOptionException(option, source);
        }, CreateContainerCmd::withLxcConf);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> logDriver(Option option) {
        return new DockerCliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                for (LogConfig.LoggingType loggingType : LogConfig.LoggingType.values()) {
                    if (!loggingType.getType().equals(value)) continue;
                    DockerCliParser.getOrCreateLogConfig((CreateContainerCmd)this.getCmd()).setType(loggingType);
                    return;
                }
                throw new DockerCliParserBase.IllegalOptionException(this.getOption(), value);
            }
        };
    }

    protected DockerCliParserBase.ListHandler<CreateContainerCmd> logOpt(Option option) {
        return new DockerCliParserBase.ListHandler<CreateContainerCmd>(option){

            protected void handleValueList(String[] values) {
                for (String value : values) {
                    String[] parts;
                    LogConfig logConfig = DockerCliParser.getOrCreateLogConfig((CreateContainerCmd)this.getCmd());
                    HashMap<String, String> logOptions = logConfig.getConfig();
                    if (logOptions == null) {
                        logOptions = new HashMap<String, String>();
                        logConfig.setConfig(logOptions);
                    }
                    if ((parts = value.split("=", 2)).length != 2) {
                        throw new DockerCliParserBase.IllegalOptionException(this.getOption(), value);
                    }
                    logOptions.put(parts[0].trim(), parts[1].trim());
                }
            }
        };
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> macAddress(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withMacAddress);
    }

    protected DockerCliParserBase.PortBindingOptionHandler<CreateContainerCmd, ?> publish(Option option) {
        return new DockerCliParserBase.PortBindingOptionHandler(option, PortBinding.class, PortBinding::parse, CreateContainerCmd::withPortBindings);
    }

    protected DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd> publishAll(Option option) {
        return new DockerCliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withPublishAllPorts);
    }

    protected DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd> privileged(Option option) {
        return new DockerCliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withPrivileged);
    }

    protected DockerCliParserBase.StringListHandler<CreateContainerCmd> dns(Option option) {
        return new DockerCliParserBase.StringListHandler(option, CreateContainerCmd::withDns);
    }

    protected DockerCliParserBase.StringListHandler<CreateContainerCmd> dnsSearch(Option option) {
        return new DockerCliParserBase.StringListHandler(option, CreateContainerCmd::withDnsSearch);
    }

    protected DockerCliParserBase.MappedListHandler<CreateContainerCmd, ?> volumesFrom(Option option) {
        return new DockerCliParserBase.MappedListHandler(option, VolumesFrom.class, VolumesFrom::parse, CreateContainerCmd::withVolumesFrom);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> cidfile(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withContainerIDFile);
    }

    protected DockerCliParserBase.MappedListHandler<CreateContainerCmd, Capability> capAdd(Option option) {
        return new DockerCliParserBase.MappedListHandler(option, Capability.class, Capability::valueOf, CreateContainerCmd::withCapAdd);
    }

    protected DockerCliParserBase.MappedListHandler<CreateContainerCmd, ?> capDrop(Option option) {
        return new DockerCliParserBase.MappedListHandler(option, Capability.class, Capability::valueOf, CreateContainerCmd::withCapDrop);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> restart(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, (cmd, restart) -> cmd.withRestartPolicy(RestartPolicy.parse((String)restart)));
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> network(Option option) {
        return new DockerCliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                if ("none".equalsIgnoreCase(value)) {
                    ((CreateContainerCmd)this.getCmd()).withNetworkDisabled(Boolean.valueOf(true));
                } else {
                    ((CreateContainerCmd)this.getCmd()).withNetworkMode(value);
                }
            }
        };
    }

    protected DockerCliParserBase.ListHandler<CreateContainerCmd> networkAlias(Option option) {
        return new DockerCliParserBase.StringListHandler(option, CreateContainerCmd::withAliases);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> ip(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withIpv4Address);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> ip6(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, CreateContainerCmd::withIpv6Address);
    }

    protected DockerCliParserBase.MappedListHandler<CreateContainerCmd, Device> device(Option option) {
        return new DockerCliParserBase.MappedListHandler(option, Device.class, Device::parse, CreateContainerCmd::withDevices);
    }

    protected DockerCliParserBase.SingleValueHandler<CreateContainerCmd> runtime(Option option) {
        return new DockerCliParserBase.EachValueHandler(option, (cmd, value) -> DockerCliParser.findOrCreateHostConfig(cmd).withRuntime(value));
    }

    protected DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd> rm(Option option) {
        return new DockerCliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                if (value) {
                    FixedCreateContainerCmdExecWithAutoRemove.markNeedsAutoRemove((CreateContainerCmd)this.getCmd());
                }
            }
        };
    }

    private static LogConfig getOrCreateLogConfig(CreateContainerCmd cmd) {
        LogConfig result = cmd.getLogConfig();
        cmd.withLogConfig(result);
        return result;
    }

    @NotNull
    private static HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
        HostConfig result = cmd.getHostConfig();
        if (result == null) {
            result = new HostConfig();
            cmd.withHostConfig(result);
        }
        HostConfig hostConfig = result;
        if (hostConfig == null) {
            DockerCliParser.$$$reportNull$$$0(0);
        }
        return hostConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerCliParser", "findOrCreateHostConfig"));
    }
}

