/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.CreateContainerCmdExec;
import com.intellij.docker.agent.fix.FixedHostConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedCreateContainerCmdExecWithAutoRemove
extends CreateContainerCmdExec {
    private static final String LABEL_NEEDS_AUTO_REMOVE = FixedCreateContainerCmdExecWithAutoRemove.class.getName();
    private static final String ANY_VALUE = "";
    private final WebTarget myUpgradedResource;

    public static void markNeedsAutoRemove(@NotNull CreateContainerCmd command) {
        HashMap<String, String> labels;
        if (command == null) {
            FixedCreateContainerCmdExecWithAutoRemove.$$$reportNull$$$0(0);
        }
        if ((labels = command.getLabels()) == null) {
            labels = new HashMap<String, String>();
            command.withLabels(labels);
        }
        labels.put(LABEL_NEEDS_AUTO_REMOVE, ANY_VALUE);
    }

    public static void unmarkNeedsAutoRemove(@NotNull CreateContainerCmd command) {
        Map labels;
        if (command == null) {
            FixedCreateContainerCmdExecWithAutoRemove.$$$reportNull$$$0(1);
        }
        if ((labels = command.getLabels()) != null) {
            labels.remove(LABEL_NEEDS_AUTO_REMOVE);
        }
    }

    public FixedCreateContainerCmdExecWithAutoRemove(WebTarget rootResource, WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
        this.myUpgradedResource = FixedCreateContainerCmdExecWithAutoRemove.upgradeBaseResource(rootResource, dockerClientConfig.getApiVersion());
    }

    private static WebTarget upgradeBaseResource(WebTarget rootResource, RemoteApiVersion version) {
        if (version != null && !version.equals((Object)RemoteApiVersion.UNKNOWN_VERSION) && version.isGreaterOrEqual(RemoteApiVersion.VERSION_1_25)) {
            return null;
        }
        return rootResource.path(new String[]{RemoteApiVersion.VERSION_1_25.asWebPathPart()});
    }

    protected WebTarget getBaseResource() {
        return this.myUpgradedResource != null ? this.myUpgradedResource : super.getBaseResource();
    }

    protected CreateContainerResponse execute(CreateContainerCmd command) {
        if (FixedCreateContainerCmdExecWithAutoRemove.needsAutoRemove(command)) {
            FixedCreateContainerCmdExecWithAutoRemove.unmarkNeedsAutoRemove(command);
            HostConfigWithAutoRemove fixedHostConfig = FixedCreateContainerCmdExecWithAutoRemove.cloneWithFixedType(command.getHostConfig());
            fixedHostConfig.withAutoRemove(Boolean.TRUE);
            command.withHostConfig((HostConfig)fixedHostConfig);
        }
        return super.execute(command);
    }

    private static HostConfigWithAutoRemove cloneWithFixedType(@Nullable HostConfig hostConfig) {
        if (hostConfig instanceof HostConfigWithAutoRemove) {
            return (HostConfigWithAutoRemove)hostConfig;
        }
        HostConfigWithAutoRemove result = new HostConfigWithAutoRemove();
        if (hostConfig != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                byte[] bytes = mapper.writeValueAsBytes((Object)hostConfig);
                mapper.readerForUpdating((Object)result).readValue(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static boolean needsAutoRemove(CreateContainerCmd command) {
        Map labels = command.getLabels();
        return labels != null && labels.containsKey(LABEL_NEEDS_AUTO_REMOVE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "command";
        objectArray2[1] = "com/intellij/docker/agent/fix/FixedCreateContainerCmdExecWithAutoRemove";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markNeedsAutoRemove";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unmarkNeedsAutoRemove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class HostConfigWithAutoRemove
    extends FixedHostConfig {
        @JsonProperty(value="AutoRemove")
        private Boolean myAutoRemove;

        private HostConfigWithAutoRemove() {
        }

        public HostConfigWithAutoRemove withAutoRemove(Boolean autoRemove) {
            this.myAutoRemove = autoRemove;
            return this;
        }
    }
}

