/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.StartContainerCmdExec;
import com.github.dockerjava.core.util.CertificateUtils;
import com.google.common.base.Preconditions;
import com.intellij.docker.agent.fix.FixedCreateContainerCmdExecWithAutoRemove;
import com.intellij.docker.agent.netty.NettyDockerCmdExecFactoryCopy;
import com.intellij.docker.agent.netty.NettyWebTargetFixed;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDockerCmdExecNettyFactoryCopyImpl
extends NettyDockerCmdExecFactoryCopy {
    @Override
    protected NettyDockerCmdExecFactoryCopy.NettyInitializer createUnixDomainSocketInitializer() {
        if (Epoll.isAvailable()) {
            return new NettyDockerCmdExecFactoryCopy.UnixDomainSocketInitializer(this);
        }
        if (KQueue.isAvailable()) {
            return new KQueueDomainSocketInitializer();
        }
        throw new IllegalStateException("Neither Epoll nor KQueue support available for Unix domain socket connection", KQueue.unavailabilityCause());
    }

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        LocalDirectorySSLConfig sslConfigImpl;
        String certificatesPath;
        URI targetUri = (URI)Preconditions.checkNotNull((Object)dockerClientConfig.getDockerHost(), (Object)"Docker host is not specified");
        if ("tcp".equals(targetUri.getScheme()) && dockerClientConfig.getSSLConfig() instanceof LocalDirectorySSLConfig && !CertificateUtils.verifyCertificatesExist((String)(certificatesPath = (String)Preconditions.checkNotNull((Object)(sslConfigImpl = (LocalDirectorySSLConfig)dockerClientConfig.getSSLConfig()).getDockerCertPath(), (Object)"Certificates path is not specified")))) {
            throw new IllegalArgumentException("Can't locate certificate files under " + certificatesPath);
        }
        super.init(dockerClientConfig);
    }

    @Override
    protected WebTarget createBaseResource() {
        return new NettyWebTargetFixed(this.channelProvider);
    }

    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return new FixedStartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new FixedCreateContainerCmdExecWithAutoRemove(this.createBaseResource(), this.getBaseResource(), this.getDockerClientConfig());
    }

    private static class FixedStartContainerCmdExec
    extends StartContainerCmdExec {
        private static final Logger LOGGER = LoggerFactory.getLogger(StartContainerCmdExec.class);

        public FixedStartContainerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
            super(baseResource, dockerClientConfig);
        }

        protected Void execute(StartContainerCmd command) {
            WebTarget webResource = this.getBaseResource().path(new String[]{"/containers/{id}/start"}).resolveTemplate("id", (Object)command.getContainerId());
            LOGGER.trace("POST: {}", (Object)webResource);
            webResource.request().accept(MediaType.APPLICATION_JSON).post(null);
            return null;
        }
    }

    private static class KQueueDomainSocketInitializer
    implements NettyDockerCmdExecFactoryCopy.NettyInitializer {
        private volatile String mySocketPath;

        private KQueueDomainSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            if (dockerClientConfig.getDockerHost().getPath() == null) {
                throw new IllegalStateException("Path must not be null");
            }
            this.mySocketPath = dockerClientConfig.getDockerHost().getPath();
            KQueueEventLoopGroup nioEventLoopGroup = new KQueueEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(threadPrefix));
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channel(KQueueDomainSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<KQueueDomainSocketChannel>(){

                protected void initChannel(KQueueDomainSocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{FixedDockerCmdExecNettyFactoryCopyImpl.newLoggingHandler()});
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            if (this.mySocketPath == null) {
                throw new IllegalStateException("socket path is not initialized");
            }
            if (!Files.exists(Paths.get(this.mySocketPath, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("socket not found: " + this.mySocketPath);
            }
            DomainSocketAddress address = new DomainSocketAddress(this.mySocketPath);
            return (DuplexChannel)bootstrap.connect((SocketAddress)address).sync().channel();
        }
    }
}

