/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.ContainerActionBase;
import com.intellij.docker.action.DockerDeploymentActionBase;
import com.intellij.docker.action.ImageActionBase;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.ApplicationActionBase;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectDockerAction
extends DockerDeploymentActionBase {
    public InspectDockerAction() {
        super(DockerBundle.getText("InspectDockerAction.text", new Object[0]), null, null);
    }

    protected void updatePresentation(@NotNull Presentation presentation, @Nullable DeploymentNode node) {
        if (presentation == null) {
            InspectDockerAction.$$$reportNull$$$0(0);
        }
        super.updatePresentation(presentation, (ServersTreeNode)node);
        DockerApplicationRuntime runtime = (DockerApplicationRuntime)this.getApplicationRuntime(node);
        if (ImageActionBase.isImageApplicationRuntime(runtime)) {
            presentation.setDescription(DockerBundle.getText("InspectDockerAction.description.image", new Object[0]));
        } else {
            presentation.setDescription(DockerBundle.getText("InspectDockerAction.description.container", new Object[0]));
        }
    }

    protected boolean isVisible4(DeploymentNode node) {
        if (!super.isVisible4(node)) {
            return false;
        }
        DockerApplicationRuntime runtime = (DockerApplicationRuntime)this.getApplicationRuntime(node);
        return ImageActionBase.isImageApplicationRuntime(runtime) || ContainerActionBase.isContainerRuntime(runtime);
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e, DeploymentNode node) {
        if (content == null) {
            InspectDockerAction.$$$reportNull$$$0(1);
        }
        String TARGET_LOG_NAME = "Inspection";
        Project project = e.getProject();
        assert (project != null);
        DockerApplicationRuntime runtime = (DockerApplicationRuntime)this.getApplicationRuntime(node);
        assert (runtime != null);
        ((CompletableFuture)runtime.promiseInspectJson().thenAccept(json -> new ShowAsLogConsumer(project, runtime).showAsLog((String)json, "Inspection"))).thenRun((Runnable)new ApplicationActionBase.SelectLogRunnable((ApplicationActionBase)this, content, node, "Inspection"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/action/InspectDockerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doActionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ShowAsLogConsumer {
        private final Project myProject;
        private final DeploymentLogManagerImpl myLogManager;

        public ShowAsLogConsumer(@NotNull Project project, @NotNull DockerApplicationRuntime runtime) {
            if (project == null) {
                ShowAsLogConsumer.$$$reportNull$$$0(0);
            }
            if (runtime == null) {
                ShowAsLogConsumer.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myLogManager = (DeploymentLogManagerImpl)runtime.getDeploymentLogManager(project);
            assert (this.myLogManager != null) : "Missing deployment: " + (Object)((Object)runtime) + ": [" + runtime.getImageId() + ", " + runtime.getContainerId() + "]";
        }

        public void showAsLog(String preparedText, String logPresentableName) {
            if (this.myProject.isDisposed()) {
                return;
            }
            LoggingHandler handler = this.myLogManager.findOrCreateAdditionalLog(logPresentableName);
            handler.clear();
            handler.print(preparedText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runtime";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/action/InspectDockerAction$ShowAsLogConsumer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

