/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.cli.DockerCliSplitterBase;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRunCliBuilder {
    private final List<String> myOptions;
    private String myCommand;
    private final String myImageSpec;
    private DockerCliSplitterBase.NormalizedCommandLine myCustomRunOptions;

    public DockerRunCliBuilder(@NotNull String imageSpec) {
        if (imageSpec == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(0);
        }
        this.myOptions = new LinkedList<String>();
        this.myImageSpec = imageSpec;
    }

    public void setContainerTag(@NotNull String containerName) {
        if (containerName == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)containerName)) {
            return;
        }
        this.myOptions.add("--name " + containerName);
    }

    public void setEntryPoint(@NotNull String entrypoint) {
        if (entrypoint == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)entrypoint)) {
            return;
        }
        this.myOptions.add("--entrypoint " + entrypoint);
    }

    public void setCommand(@NotNull String command) {
        if (command == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(3);
        }
        this.myCommand = command;
    }

    public void setPublishAllPorts() {
        this.myOptions.add("-P");
    }

    public void addPublishedPorts(@NotNull List<DockerPortBindingImpl> ports) {
        if (ports == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(4);
        }
        if (ports.isEmpty()) {
            return;
        }
        String oneLineForAll = ports.stream().map(DockerPortBindingImpl::toCommandLineString).map(spec -> "-p " + spec).collect(Collectors.joining(" "));
        this.myOptions.add(oneLineForAll);
    }

    public void addVolume(@NotNull DockerVolumeBindingImpl spec) {
        if (spec == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(5);
        }
        this.myOptions.add("-v " + spec.toCommandLineString());
    }

    public void addEnvVar(@NotNull String name, @Nullable String value) {
        if (name == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(6);
        }
        if (value == null) {
            value = System.getenv(name);
        }
        if (value == null) {
            this.myOptions.add("-e " + name);
        } else {
            this.myOptions.add("--env " + name + "=" + value);
        }
    }

    public void setCustomRunOptions(@NotNull DockerCliSplitterBase.NormalizedCommandLine runOptions) {
        if (runOptions == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(7);
        }
        this.myCustomRunOptions = runOptions;
    }

    public List<String> buildPreviewLines(boolean hasCommandBefore) {
        LinkedList<String> result = new LinkedList<String>();
        result.add((hasCommandBefore ? "&& " : "") + "docker run");
        result.addAll(this.myOptions);
        if (this.myCustomRunOptions != null) {
            result.addAll(this.myCustomRunOptions.groupByOptions());
        }
        result.add(this.myImageSpec + (this.myCommand == null ? "" : " " + this.myCommand));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrypoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/cli/DockerRunCliBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setContainerTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setEntryPoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addPublishedPorts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addVolume";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addEnvVar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomRunOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

