/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v1;

import com.google.common.collect.Lists;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.configuration.beans.common.AccessMode;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBuilderBase;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeVolumesFromV1;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeServiceV1Builder
extends DockerComposeServiceBuilderBase<DockerComposeServiceV1Builder, DockerComposeServiceV1> {
    private String myBuild;
    private List<String> myVolumes;
    private List<DockerComposeVolumesFromV1> myVolumesFrom;

    @NotNull
    public DockerComposeServiceV1Builder withBuild(@NotNull String val) {
        if (val == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(0);
        }
        this.myBuild = val;
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(1);
        }
        return dockerComposeServiceV1Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV1Builder withBindVolumes(@Nullable DockerVolumeBinding[] volumeBindings) {
        if (volumeBindings == null) {
            DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
            if (dockerComposeServiceV1Builder == null) {
                DockerComposeServiceV1Builder.$$$reportNull$$$0(2);
            }
            return dockerComposeServiceV1Builder;
        }
        this.myVolumes = Lists.transform(Arrays.asList(volumeBindings), volume -> {
            StringBuilder stringBuilder = new StringBuilder();
            if (!StringUtil.isEmpty((String)volume.getHostPath())) {
                stringBuilder.append(volume.getHostPath()).append(":");
            }
            stringBuilder.append(volume.getContainerPath());
            if (!StringUtil.isEmpty((String)volume.getHostPath()) && !volume.isReadOnly()) {
                stringBuilder.append(":").append(AccessMode.RW.getCode());
            }
            return stringBuilder.toString();
        });
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(3);
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public DockerComposeServiceV1Builder addVolume(@NotNull String containerPath) {
        if (containerPath == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(4);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(containerPath);
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(5);
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public DockerComposeServiceV1Builder addVolume(@NotNull String hostPath, @NotNull String containerPath) {
        if (hostPath == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(6);
        }
        if (containerPath == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(7);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath);
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(8);
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public DockerComposeServiceV1Builder addVolume(@NotNull String hostPath, @NotNull String containerPath, @NotNull AccessMode accessMode) {
        if (hostPath == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(9);
        }
        if (containerPath == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(10);
        }
        if (accessMode == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(11);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath + ":" + accessMode.getCode());
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(12);
        }
        return dockerComposeServiceV1Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV1Builder withVolumesFrom(DockerVolumesFrom ... volumesFrom) {
        this.myVolumesFrom = volumesFrom == null ? null : Lists.transform(Arrays.asList(volumesFrom), input -> {
            AccessMode accessMode = input.isReadOnly() ? AccessMode.RO : AccessMode.RW;
            return new DockerComposeVolumesFromV1(input.getContainerId(), accessMode);
        });
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(13);
        }
        return dockerComposeServiceV1Builder;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV1 createServiceBean() {
        DockerComposeServiceV1 dockerComposeServiceV1 = new DockerComposeServiceV1();
        if (dockerComposeServiceV1 == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(14);
        }
        return dockerComposeServiceV1;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV1 tuneServiceBean(@NotNull DockerComposeServiceV1 serviceBean) {
        if (serviceBean == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(15);
        }
        serviceBean.setBuild(this.myBuild);
        serviceBean.setVolumes(this.myVolumes);
        serviceBean.setVolumesFrom(this.myVolumesFrom);
        DockerComposeServiceV1 dockerComposeServiceV1 = serviceBean;
        if (dockerComposeServiceV1 == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(16);
        }
        return dockerComposeServiceV1;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV1Builder getThis() {
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = this;
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(17);
        }
        return dockerComposeServiceV1Builder;
    }

    @NotNull
    public static DockerComposeServiceV1Builder builder() {
        DockerComposeServiceV1Builder dockerComposeServiceV1Builder = new DockerComposeServiceV1Builder();
        if (dockerComposeServiceV1Builder == null) {
            DockerComposeServiceV1Builder.$$$reportNull$$$0(18);
        }
        return dockerComposeServiceV1Builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerPath";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/v1/DockerComposeServiceV1Builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withBuild";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withBindVolumes";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addVolume";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withVolumesFrom";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createServiceBean";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneServiceBean";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withBuild";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addVolume";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tuneServiceBean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

