/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v2;

import com.google.common.collect.Lists;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.configuration.beans.common.AccessMode;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBuilderBase;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeBuildV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeVolumesFromV2;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeServiceV2Builder
extends DockerComposeServiceBuilderBase<DockerComposeServiceV2Builder, DockerComposeServiceV2> {
    private DockerComposeBuildV2 myBuild;
    private List<String> myVolumes;
    private List<DockerComposeVolumesFromV2> myVolumesFrom;

    @NotNull
    public DockerComposeServiceV2Builder withBuild(@NotNull String val) {
        if (val == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(0);
        }
        this.myBuild = new DockerComposeBuildV2(val);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(1);
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder withBuild(@NotNull String context, @NotNull String dockerfile) {
        if (context == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(2);
        }
        if (dockerfile == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(3);
        }
        this.myBuild = new DockerComposeBuildV2(context, dockerfile);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(4);
        }
        return dockerComposeServiceV2Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV2Builder withBindVolumes(@Nullable DockerVolumeBinding[] volumeBindings) {
        List<Object> volumeBindingsList = volumeBindings == null ? Collections.emptyList() : Arrays.asList(volumeBindings);
        this.myVolumes = Lists.transform(volumeBindingsList, volume -> {
            StringBuilder stringBuilder = new StringBuilder();
            if (!StringUtil.isEmpty((String)volume.getHostPath())) {
                stringBuilder.append(volume.getHostPath()).append(":");
            }
            stringBuilder.append(volume.getContainerPath());
            if (!StringUtil.isEmpty((String)volume.getHostPath()) && !volume.isReadOnly()) {
                stringBuilder.append(":").append(AccessMode.RW.getCode());
            }
            return stringBuilder.toString();
        });
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(5);
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder addVolume(@NotNull String containerPath) {
        if (containerPath == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(6);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(containerPath);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(7);
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder addVolume(@NotNull String hostPath, @NotNull String containerPath) {
        if (hostPath == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(8);
        }
        if (containerPath == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(9);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath);
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(10);
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public DockerComposeServiceV2Builder addVolume(@NotNull String hostPath, @NotNull String containerPath, @NotNull AccessMode accessMode) {
        if (hostPath == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(11);
        }
        if (containerPath == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(12);
        }
        if (accessMode == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(13);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<String>();
        }
        this.myVolumes.add(hostPath + ":" + containerPath + ":" + accessMode.getCode());
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(14);
        }
        return dockerComposeServiceV2Builder;
    }

    @Override
    @NotNull
    public DockerComposeServiceV2Builder withVolumesFrom(@Nullable DockerVolumesFrom[] volumesFrom) {
        this.myVolumesFrom = volumesFrom == null ? null : Lists.transform(Arrays.asList(volumesFrom), input -> {
            AccessMode accessMode = input.isReadOnly() ? AccessMode.RO : AccessMode.RW;
            return new DockerComposeVolumesFromV2(DockerComposeVolumesFromV2.Type.CONTAINER, input.getContainerId(), accessMode);
        });
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(15);
        }
        return dockerComposeServiceV2Builder;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV2 createServiceBean() {
        DockerComposeServiceV2 dockerComposeServiceV2 = new DockerComposeServiceV2();
        if (dockerComposeServiceV2 == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(16);
        }
        return dockerComposeServiceV2;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV2 tuneServiceBean(@NotNull DockerComposeServiceV2 serviceBean) {
        if (serviceBean == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(17);
        }
        serviceBean.setBuild(this.myBuild);
        serviceBean.setVolumes(this.myVolumes);
        serviceBean.setVolumesFrom(this.myVolumesFrom);
        DockerComposeServiceV2 dockerComposeServiceV2 = serviceBean;
        if (dockerComposeServiceV2 == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(18);
        }
        return dockerComposeServiceV2;
    }

    @Override
    @NotNull
    protected DockerComposeServiceV2Builder getThis() {
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = this;
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(19);
        }
        return dockerComposeServiceV2Builder;
    }

    @NotNull
    public static DockerComposeServiceV2Builder builder() {
        DockerComposeServiceV2Builder dockerComposeServiceV2Builder = new DockerComposeServiceV2Builder();
        if (dockerComposeServiceV2Builder == null) {
            DockerComposeServiceV2Builder.$$$reportNull$$$0(20);
        }
        return dockerComposeServiceV2Builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerfile";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerPath";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/v2/DockerComposeServiceV2Builder";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withBuild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withBindVolumes";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addVolume";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withVolumesFrom";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createServiceBean";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneServiceBean";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withBuild";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addVolume";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tuneServiceBean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

