/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeRunCliBuilder;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationSerializer;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeServiceRunCmd
extends AbstractServiceCmd<ComposeServiceRunCmd> {
    private static final Logger LOG = Logger.getInstance(ComposeServiceRunCmd.class);
    private boolean myNoDeps;
    private boolean myNoPty;
    private boolean myRemove;
    @Nullable
    private List<DockerComposePort> myPublishPorts;
    @Nullable
    private String myName;

    public ComposeServiceRunCmd(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(0);
        }
        super(dockerRuntime);
        this.myNoDeps = true;
        this.myNoPty = false;
        this.myRemove = false;
    }

    @Override
    @NotNull
    public KillableColoredProcessHandler execute() throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = this.execute(false);
        if (killableColoredProcessHandler == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(1);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    public String execDetached() throws IOException, ExecutionException {
        KillableColoredProcessHandler processHandler = this.execute(true);
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess();
        if (processOutput.checkSuccess(LOG)) {
            String string = processOutput.getStdout().trim();
            if (string == null) {
                ComposeServiceRunCmd.$$$reportNull$$$0(2);
            }
            return string;
        }
        throw new ExecutionException(processOutput.getStderr());
    }

    @Override
    @NotNull
    protected ComposeServiceRunCmd getThis() {
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(3);
        }
        return composeServiceRunCmd;
    }

    @Override
    public CapturingProcessHandler exec() throws IOException, ExecutionException {
        return new CapturingProcessHandler(ComposeServiceRunCmd.buildRunCommand(this, false).buildCommandLine());
    }

    public boolean isNoDeps() {
        return this.myNoDeps;
    }

    @NotNull
    public ComposeServiceRunCmd withNoDeps(boolean value) {
        this.myNoDeps = value;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(4);
        }
        return composeServiceRunCmd;
    }

    public boolean isNoPty() {
        return this.myNoPty;
    }

    @NotNull
    public ComposeServiceRunCmd withNoPty(boolean value) {
        this.myNoPty = value;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(5);
        }
        return composeServiceRunCmd;
    }

    public boolean isRemove() {
        return this.myRemove;
    }

    @NotNull
    public ComposeServiceRunCmd withRemove(boolean remove) {
        this.myRemove = remove;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(6);
        }
        return composeServiceRunCmd;
    }

    @Nullable
    public List<DockerComposePort> getPublishPorts() {
        return this.myPublishPorts;
    }

    @NotNull
    public ComposeServiceRunCmd withPublishPorts(@Nullable List<DockerComposePort> ports) {
        this.myPublishPorts = ports;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(7);
        }
        return composeServiceRunCmd;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public ComposeServiceRunCmd withName(@Nullable String name) {
        this.myName = name;
        ComposeServiceRunCmd composeServiceRunCmd = this;
        if (composeServiceRunCmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(8);
        }
        return composeServiceRunCmd;
    }

    @NotNull
    private KillableColoredProcessHandler execute(boolean detached) throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = ComposeServiceRunCmd.buildRunCommand(this, detached).run();
        if (killableColoredProcessHandler == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(9);
        }
        return killableColoredProcessHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DockerComposeRunCliBuilder buildRunCommand(@NotNull ComposeServiceRunCmd cmd, boolean detached) throws IOException {
        if (cmd == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(10);
        }
        if (ContainerUtil.isEmpty(cmd.getConfigurationPaths())) {
            throw new IllegalArgumentException("Compose configuration path must be defined");
        }
        if (StringUtil.isEmpty((String)cmd.getServiceName())) {
            throw new IllegalArgumentException("Compose service name must be defined");
        }
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
        List<Path> paths = DockerComposeConfigurationUtil.findConfigurationFiles(cmd.getConfigurationPaths());
        Path mainConfigurationPath = paths.iterator().next();
        Set<String> namedVolumes = ServiceCmdExecUtils.collectNamedVolumes(cmd.getVolumesBinding());
        DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(mainConfigurationPath, namedVolumes);
        if (!ArrayUtil.isEmpty((Object[])cmd.getVolumesFrom())) {
            ServiceCmdExecUtils.assertVolumesFromOptionSupported(configurationBuilder);
        }
        Object serviceBuilder = configurationBuilder.addService(cmd.getServiceName());
        String[] entrypoint = cmd.getEntrypoint();
        if (entrypoint != null) {
            serviceBuilder.withEntrypoint(entrypoint);
        } else {
            serviceBuilder.withEntrypointLine("");
        }
        DockerVolumeBinding[] updatedBindings = cmd.getVolumesBinding();
        serviceBuilder.withCommand(cmd.getCommand()).withWorkingDir(cmd.getWorkingDir()).withEnvironment(DockerComposeConfigurationUtil.escapeDollarSigns(cmd.getEnvironment())).withVolumesFrom(cmd.getVolumesFrom()).withBindVolumes(updatedBindings).withPorts(cmd.getPorts()).withUser(cmd.getUser()).withRestartPolicy(cmd.getRestartPolicy());
        ServiceCmdExecUtils.setupSharedVolume(configurationBuilder, serviceBuilder, cmd, updatedBindings);
        Object override = configurationBuilder.build();
        File tempFile = ServiceCmdExecUtils.createTempDockerComposeOverrideYml();
        try (FileWriter output = new FileWriter(tempFile);){
            DockerComposeConfigurationSerializer.newInstance().serialize(output, (DockerComposeConfiguration)override);
        }
        ImmutableList configurationPaths = ImmutableList.builder().addAll(paths).add((Object)tempFile.toPath()).build();
        DockerComposeRunCliBuilder dockerComposeRunCliBuilder = ((DockerComposeRunCliBuilder)((DockerComposeRunCliBuilder)DockerComposeCliUtil.buildRunCommand(cmd.getDockerRuntime()).withEnvironment((Map<String, String>)cmd.getEnvs())).withFiles((List<Path>)configurationPaths)).withDetached(detached).withRemove(cmd.isRemove()).withNoDeps(cmd.isNoDeps()).withNoPty(cmd.isNoPty()).withContainerName(cmd.getName()).withPublishPorts(cmd.getPublishPorts()).withService(cmd.getServiceName());
        if (dockerComposeRunCliBuilder == null) {
            ComposeServiceRunCmd.$$$reportNull$$$0(11);
        }
        return dockerComposeRunCliBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ComposeServiceRunCmd";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ComposeServiceRunCmd";
                break;
            }
            case 1: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execDetached";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withNoDeps";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withNoPty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withRemove";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withPublishPorts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRunCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildRunCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

