/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationSerializer;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComposeServiceUpCmd
extends AbstractServiceCmd<ComposeServiceUpCmd> {
    public ComposeServiceUpCmd(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(0);
        }
        super(dockerRuntime);
    }

    @Override
    @NotNull
    public KillableColoredProcessHandler execute() throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = this.createBuilder().run();
        if (killableColoredProcessHandler == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(1);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    public GeneralCommandLine buildCommandLine() throws IOException {
        GeneralCommandLine generalCommandLine = this.createBuilder().buildCommandLine();
        if (generalCommandLine == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DockerComposeUpCliBuilder createBuilder() throws IOException {
        if (ContainerUtil.isEmpty(this.getConfigurationPaths())) {
            throw new IllegalArgumentException("Compose configuration path must be defined");
        }
        if (StringUtil.isEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException("Compose service name must be defined");
        }
        List<Path> paths = DockerComposeConfigurationUtil.findConfigurationFiles(this.getConfigurationPaths());
        Path mainConfigurationPath = paths.iterator().next();
        Set<String> namedVolumes = ServiceCmdExecUtils.collectNamedVolumes(this.getVolumesBinding());
        DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(mainConfigurationPath, namedVolumes);
        if (!ArrayUtil.isEmpty((Object[])this.getVolumesFrom())) {
            ServiceCmdExecUtils.assertVolumesFromOptionSupported(configurationBuilder);
        }
        Object serviceBuilder = configurationBuilder.addService(this.getServiceName());
        String[] entrypoint = this.getEntrypoint();
        if (entrypoint != null) {
            serviceBuilder.withEntrypoint(entrypoint);
        }
        serviceBuilder.withCommand(this.getCommand()).withWorkingDir(this.getWorkingDir()).withEnvironment(DockerComposeConfigurationUtil.escapeDollarSigns(this.getEnvironment())).withVolumesFrom(this.getVolumesFrom()).withBindVolumes(this.getVolumesBinding()).withPorts(this.getPorts()).withUser(this.getUser()).withRestartPolicy(this.getRestartPolicy()).withStdinOpen(true);
        ServiceCmdExecUtils.setupSharedVolume(configurationBuilder, serviceBuilder, this, this.getVolumesBinding());
        Object override = configurationBuilder.build();
        File tempFile = ServiceCmdExecUtils.createTempDockerComposeOverrideYml();
        try (FileWriter output = new FileWriter(tempFile);){
            DockerComposeConfigurationSerializer.newInstance().serialize(output, (DockerComposeConfiguration)override);
        }
        ImmutableList.Builder withTempFile = ImmutableList.builder();
        withTempFile.addAll(paths);
        withTempFile.add((Object)tempFile.toPath());
        DockerComposeUpCliBuilder dockerComposeUpCliBuilder = ((DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(this.getDockerRuntime()).withEnvironment((Map<String, String>)this.getEnvs())).withFiles((List<Path>)withTempFile.build())).withServices(this.getServiceName()).withExitCodeFrom(this.getServiceName());
        if (dockerComposeUpCliBuilder == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(3);
        }
        return dockerComposeUpCliBuilder;
    }

    @Override
    @NotNull
    protected ComposeServiceUpCmd getThis() {
        ComposeServiceUpCmd composeServiceUpCmd = this;
        if (composeServiceUpCmd == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(4);
        }
        return composeServiceUpCmd;
    }

    @Override
    public CapturingProcessHandler exec() throws IOException, ExecutionException {
        return new CapturingProcessHandler(this.createBuilder().buildCommandLine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ComposeServiceUpCmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ComposeServiceUpCmd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

