/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.collect.ImmutableSet;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBuilder;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1Builder;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2Builder;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeServiceV2Builder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceCmdExecUtils {
    private static final Logger LOG = Logger.getInstance(ServiceCmdExecUtils.class);
    public static final String EMPTY_COMMAND = "";
    private static final String DOCKER_COMPOSE_OVERRIDE = "docker-compose.override.";
    private static final String YML_EXTENSION = ".yml";
    private static final Pattern DOCKER_START_PATTERN = Pattern.compile("\\$docker start (?<name>.+)");
    private static final Pattern SERVER_RUNTIME_EXCEPTION_MESSAGE_PATTERN = Pattern.compile("(?s).*\\{\"message\":\"(?<body>.*)\"\\}.*");
    private static final ImmutableSet<String> DOCKER_ENV_VARS = ImmutableSet.of((Object)"DOCKER_HOST", (Object)"DOCKER_TLS_VERIFY", (Object)"DOCKER_CERT_PATH");
    private static final String BIN_TRUE_CMD = "/bin/true";

    private ServiceCmdExecUtils() {
    }

    @NotNull
    public static DockerComposeConfigurationBuilder<?, ?, ?> createConfigurationBuilder(@NotNull Path mainConfigurationPath, final @NotNull Collection<String> volumes) throws IOException {
        if (mainConfigurationPath == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(0);
        }
        if (volumes == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(1);
        }
        DockerComposeConfigurationBuilder dockerComposeConfigurationBuilder = (DockerComposeConfigurationBuilder)DockerComposeConfigurationParser.newInstance().parseBean(mainConfigurationPath.toString()).accept(new DockerComposeConfiguration.Visitor<DockerComposeConfigurationBuilder<?, ?, ?>>(){

            @Override
            public DockerComposeConfigurationV1Builder visit(@NotNull DockerComposeConfigurationV1 configuration) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new DockerComposeConfigurationV1Builder();
            }

            @Override
            public DockerComposeConfigurationV2Builder visit(@NotNull DockerComposeConfigurationV2 configuration) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(1);
                }
                DockerComposeConfigurationV2Builder builder = new DockerComposeConfigurationV2Builder().withVersion(configuration.getVersion());
                for (String volume : volumes) {
                    builder.addVolume(volume);
                }
                return builder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$1", "visit"));
            }
        });
        if (dockerComposeConfigurationBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(2);
        }
        return dockerComposeConfigurationBuilder;
    }

    @NotNull
    public static Set<String> collectNamedVolumes(@Nullable DockerVolumeBinding[] bindings) {
        if (bindings == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(3);
            }
            return set;
        }
        LinkedHashSet<String> volumes = new LinkedHashSet<String>();
        for (DockerVolumeBinding bind : bindings) {
            String bindPath = bind.getHostPath();
            if (bindPath == null || !DockerComposeConfigurationUtil.isNamedVolumeBind(bindPath)) continue;
            volumes.add(bindPath);
        }
        LinkedHashSet<String> linkedHashSet = volumes;
        if (linkedHashSet == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    public static File createTempDockerComposeOverrideYml() throws IOException {
        File tempDir = new File(PathManager.getTempPath());
        File file = FileUtil.createTempFile((File)tempDir, (String)DOCKER_COMPOSE_OVERRIDE, (String)YML_EXTENSION, (boolean)true);
        if (file == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    public static String parseServiceContainerName(@NotNull String stdout) {
        if (stdout == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(6);
        }
        String trimmedStdout = StringUtil.trim((String)stdout);
        int last = Math.max(trimmedStdout.lastIndexOf("\n"), trimmedStdout.lastIndexOf("\r"));
        String string = trimmedStdout.substring(last + 1).trim();
        if (string == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String parseDockerStartCmd(@NotNull String s) {
        Matcher matcher;
        if (s == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(8);
        }
        if ((matcher = DOCKER_START_PATTERN.matcher(s)).matches()) {
            return matcher.group("name").trim();
        }
        return null;
    }

    @NotNull
    static Optional<Matcher> matches(@NotNull String s, @NotNull Iterable<Pattern> patterns) {
        if (s == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(9);
        }
        if (patterns == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(10);
        }
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            Optional<Matcher> optional = Optional.of(matcher);
            if (optional == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(11);
            }
            return optional;
        }
        Optional<Matcher> optional = Optional.empty();
        if (optional == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(12);
        }
        return optional;
    }

    @NotNull
    public static ServiceContainers listServiceContainerNames(@NotNull ProcessOutput dockerComposeProcessOutput) {
        if (dockerComposeProcessOutput == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(13);
        }
        LinkedHashSet<String> allServices = new LinkedHashSet<String>();
        List<Pattern> ignorePatterns = Arrays.asList(Pattern.compile("Creating volume \".*\" with .* driver"), Pattern.compile("Creating network \".*\" with .* driver"));
        List<Pattern> upToDatePatterns = Collections.singletonList(Pattern.compile("(?<container>.*) is up-to-date"));
        List<Pattern> patterns = Collections.singletonList(Pattern.compile("(?:Starting|Creating|Recreating) (?<container>.+)"));
        LinkedHashSet<String> upToDateServices = new LinkedHashSet<String>();
        boolean allErrLinesMatched = true;
        for (String line : dockerComposeProcessOutput.getStderrLines()) {
            String serviceContainerName;
            Optional<Matcher> matcher;
            if (!StringUtil.isNotEmpty((String)line)) continue;
            Optional<Matcher> ignoreMatcher = ServiceCmdExecUtils.matches(line, ignorePatterns);
            boolean matched = ignoreMatcher.isPresent();
            if (!matched && (matcher = ServiceCmdExecUtils.matches(line, patterns)).isPresent()) {
                serviceContainerName = matcher.get().group("container").trim();
                allServices.add(serviceContainerName);
                matched = true;
            }
            if (!matched && (matcher = ServiceCmdExecUtils.matches(line, upToDatePatterns)).isPresent()) {
                serviceContainerName = matcher.get().group("container").trim();
                allServices.add(serviceContainerName);
                upToDateServices.add(serviceContainerName);
                matched = true;
            }
            if (matched) continue;
            allErrLinesMatched = false;
        }
        if (!allErrLinesMatched && LOG.isDebugEnabled()) {
            LOG.debug("Failed to locate container names in every line of Docker Compose output.\nstderr:\n", new Object[]{dockerComposeProcessOutput.getStderr(), "\nstdout:\n" + dockerComposeProcessOutput.getStdout()});
        }
        ServiceContainers serviceContainers = new ServiceContainers(allServices, upToDateServices);
        if (serviceContainers == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(14);
        }
        return serviceContainers;
    }

    @NotNull
    public static String extractErrorMessage(@NotNull ServerRuntimeException e) {
        String message;
        if (e == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(15);
        }
        if ((message = e.getMessage()) == null) {
            String string = e.toString();
            if (string == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(16);
            }
            return string;
        }
        Matcher matcher = SERVER_RUNTIME_EXCEPTION_MESSAGE_PATTERN.matcher(message);
        String string = matcher.matches() ? matcher.group("body") : message;
        if (string == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static DockerEnvVar[] filterDockerEnvs(@NotNull DockerEnvVar[] vars) {
        if (vars == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(18);
        }
        DockerEnvVar[] dockerEnvVarArray = (DockerEnvVar[])Arrays.stream(vars).filter(var -> !DOCKER_ENV_VARS.contains((Object)var.getName())).toArray(DockerEnvVar[]::new);
        if (dockerEnvVarArray == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(19);
        }
        return dockerEnvVarArray;
    }

    @Nullable
    public static String extractHostPath(@NotNull String volume) {
        if (volume == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(20);
        }
        int i = -1;
        if (volume.startsWith(".") || volume.startsWith("~") || volume.startsWith("/")) {
            i = volume.indexOf(58);
        }
        if (volume.length() > 1 && volume.charAt(1) == ':') {
            i = volume.indexOf(58, 2);
        }
        return i != -1 ? volume.substring(0, i) : null;
    }

    public static void setupSharedVolume(@NotNull DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder, @NotNull DockerComposeServiceBuilder<?, ?> serviceBuilder, @NotNull AbstractServiceCmd<?> cmd, @Nullable DockerVolumeBinding[] bindings) {
        SharedVolume sharedVolume;
        if (configurationBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(21);
        }
        if (serviceBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(22);
        }
        if (cmd == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(23);
        }
        if ((sharedVolume = cmd.getSharedVolume()) != null) {
            if (configurationBuilder instanceof DockerComposeConfigurationV1Builder) {
                ServiceCmdExecUtils.setupSharedVolumesFrom(serviceBuilder, cmd, sharedVolume);
            } else if (configurationBuilder instanceof DockerComposeConfigurationV2Builder) {
                DockerComposeConfigurationV2Builder configurationV2Builder = (DockerComposeConfigurationV2Builder)configurationBuilder;
                String version = configurationV2Builder.getVersion();
                String majorVersion = DockerComposeConfigurationParser.getMajorVersion(version);
                if ("2".equals(majorVersion)) {
                    ServiceCmdExecUtils.setupSharedVolumesFrom(serviceBuilder, cmd, sharedVolume);
                } else {
                    ServiceCmdExecUtils.setupSharedServiceVolume(configurationV2Builder, serviceBuilder, bindings, sharedVolume);
                    if (cmd instanceof ComposeServiceRunCmd) {
                        ((ComposeServiceRunCmd)cmd).withNoDeps(false);
                    }
                }
            } else {
                throw new IllegalStateException("Unsupported Docker Compose version");
            }
        }
    }

    public static void assertVolumesFromOptionSupported(@NotNull DockerComposeConfigurationBuilder<?, ?, ?> builder) {
        String version;
        String majorVersion;
        if (builder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(24);
        }
        if (builder instanceof DockerComposeConfigurationV2Builder && !"2".equals(majorVersion = DockerComposeConfigurationParser.getMajorVersion(version = ((DockerComposeConfigurationV2Builder)builder).getVersion()))) {
            throw new IllegalArgumentException("Unsupported docker compose configuration version: " + version);
        }
    }

    private static void setupSharedServiceVolume(@NotNull DockerComposeConfigurationV2Builder configurationBuilder, @NotNull DockerComposeServiceBuilder<?, ?> serviceBuilder, @Nullable DockerVolumeBinding[] bindings, @NotNull SharedVolume sharedVolume) {
        if (configurationBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(25);
        }
        if (serviceBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(26);
        }
        if (sharedVolume == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(27);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create service " + sharedVolume.getName() + " to share " + sharedVolume.getImage() + " image volume " + sharedVolume.getVolumePath());
        }
        configurationBuilder.addVolume(sharedVolume.getName());
        DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl(sharedVolume.getVolumePath(), sharedVolume.getName(), true);
        serviceBuilder.withBindVolumes(ServiceCmdExecUtils.append(bindings, binding, DockerVolumeBinding.class));
        serviceBuilder.withDependsOn(Collections.singletonList(sharedVolume.getName()));
        DockerComposeServiceV2Builder helpersServiceBuilder = configurationBuilder.addService(sharedVolume.getName());
        ((DockerComposeServiceV2Builder)((DockerComposeServiceV2Builder)helpersServiceBuilder.withCommand(new String[]{BIN_TRUE_CMD})).withImage(sharedVolume.getImage())).withBindVolumes(new DockerVolumeBinding[]{binding});
    }

    private static void setupSharedVolumesFrom(@NotNull DockerComposeServiceBuilder<?, ?> serviceBuilder, @NotNull AbstractServiceCmd<?> cmd, @NotNull SharedVolume sharedVolume) {
        if (serviceBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(28);
        }
        if (cmd == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(29);
        }
        if (sharedVolume == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(30);
        }
        LOG.debug("Using volumes_from to share " + sharedVolume + " container volume " + sharedVolume.getVolumePath());
        serviceBuilder.withVolumesFrom(ServiceCmdExecUtils.append(cmd.getVolumesFrom(), ServiceCmdExecUtils.readOnlyVolumesFrom(sharedVolume.getContainer()), DockerVolumesFrom.class));
    }

    @NotNull
    private static DockerVolumesFrom readOnlyVolumesFrom(final @NotNull String container) {
        if (container == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(31);
        }
        DockerVolumesFrom dockerVolumesFrom = new DockerVolumesFrom(){

            public String getContainerId() {
                return container;
            }

            public boolean isReadOnly() {
                return true;
            }
        };
        if (dockerVolumesFrom == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(32);
        }
        return dockerVolumesFrom;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@Nullable T[] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (componentType == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(33);
        }
        if (src == null) {
            Object[] array = (Object[])Array.newInstance(componentType, 1);
            array[0] = element;
            if (array == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(34);
            }
            return array;
        }
        Object[] objectArray = ArrayUtil.append((Object[])src, element, componentType);
        if (objectArray == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(35);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainConfigurationPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeProcessOutput";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volume";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationBuilder";
                break;
            }
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBuilder";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedVolume";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamedVolumes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDockerComposeOverrideYml";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseServiceContainerName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "matches";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listServiceContainerNames";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractErrorMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDockerEnvs";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "readOnlyVolumesFrom";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 34: 
            case 35: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceContainerName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseDockerStartCmd";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "listServiceContainerNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractErrorMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterDockerEnvs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractHostPath";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setupSharedVolume";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "assertVolumesFromOptionSupported";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setupSharedServiceVolume";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setupSharedVolumesFrom";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "readOnlyVolumesFrom";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ServiceContainers {
        @NotNull
        private final Set<String> myAllServices;
        @NotNull
        private final Set<String> myUpToDateServices;

        public ServiceContainers(@NotNull Set<String> allServices, @NotNull Set<String> upToDateServices) {
            if (allServices == null) {
                ServiceContainers.$$$reportNull$$$0(0);
            }
            if (upToDateServices == null) {
                ServiceContainers.$$$reportNull$$$0(1);
            }
            this.myAllServices = allServices;
            this.myUpToDateServices = upToDateServices;
        }

        @NotNull
        public Set<String> getAllServices() {
            Set<String> set = this.myAllServices;
            if (set == null) {
                ServiceContainers.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        public Set<String> getUpToDateServices() {
            Set<String> set = this.myUpToDateServices;
            if (set == null) {
                ServiceContainers.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allServices";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upToDateServices";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllServices";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpToDateServices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

