/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deploymentSource.DockerDeploymentConfigurator;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRunConfigurationProducerBase
extends RunConfigurationProducer<DeployToServerRunConfiguration<?, DockerDeploymentConfiguration>> {
    protected DockerRunConfigurationProducerBase(@NotNull DockerSingletonDeploymentSourceType sourceType) {
        if (sourceType == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(0);
        }
        super((ConfigurationFactory)DockerCloudType.getRunConfigurationType().getFactoryForType((DeploymentSourceType)sourceType));
    }

    @Nullable
    protected abstract DockerSingletonDeploymentSourceType getDeploymentSourceType(@NotNull PsiFile var1);

    protected boolean setupConfigurationFromContext(DeployToServerRunConfiguration<?, DockerDeploymentConfiguration> configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        RemoteServer<DockerCloudConfiguration> docker;
        PsiFile psiFile = DockerRunConfigurationProducerBase.findPsiFile(context);
        if (psiFile == null || psiFile.getVirtualFile() == null) {
            return false;
        }
        DockerSingletonDeploymentSourceType sourceType = this.getDeploymentSourceType(psiFile);
        if (sourceType == null) {
            return false;
        }
        Project project = context.getProject();
        DockerDeploymentConfigurator configurator = DockerCloudType.getInstance().createDeploymentConfigurator(project);
        DeploymentSource deploymentSource = sourceType.getSingletonSource();
        DockerDeploymentConfiguration deploymentConfig = configurator.createDefaultConfiguration(deploymentSource);
        DockerDeploymentConfiguration.ProjectAwareHelper.setSourceFile(project, deploymentConfig, psiFile.getVirtualFile());
        configuration.setDeploymentSource(deploymentSource);
        configuration.setDeploymentConfiguration((DeploymentConfiguration)deploymentConfig);
        String suggestedName = configurator.suggestConfigurationName(deploymentSource, deploymentConfig);
        if (suggestedName != null) {
            configuration.setName(suggestedName);
        }
        configuration.setServerName((docker = DockerRunConfigurationProducerBase.findFirstDockerAccount()) == null ? null : docker.getName());
        return true;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(2);
        }
        if (startRunnable == null) {
            DockerRunConfigurationProducerBase.$$$reportNull$$$0(3);
        }
        DeployToServerRunConfiguration runConfiguration = (DeployToServerRunConfiguration)configuration.getConfiguration();
        Project project = context.getProject();
        boolean cancelled = false;
        if (runConfiguration.getServerName() == null) {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings settings = configuration.getConfigurationSettings();
            if (!runManager.getAllSettings().contains(settings)) {
                runManager.addConfiguration(settings);
            }
            runManager.setSelectedConfiguration(settings);
            EditConfigurationsDialog dialog = new EditConfigurationsDialog(project);
            if (!dialog.showAndGet()) {
                cancelled = true;
            }
        }
        if (!cancelled) {
            super.onFirstRun(configuration, context, startRunnable);
        }
    }

    public boolean isConfigurationFromContext(DeployToServerRunConfiguration<?, DockerDeploymentConfiguration> configuration, ConfigurationContext context) {
        if (configuration.getServerType() != DockerCloudType.getInstance()) {
            return false;
        }
        DeploymentSourceType sourceType = Optional.ofNullable(configuration.getDeploymentSource()).map(DeploymentSource::getType).orElse(null);
        if (!(sourceType instanceof DockerSingletonDeploymentSourceType)) {
            return false;
        }
        PsiFile contextFile = DockerRunConfigurationProducerBase.findPsiFile(context);
        return contextFile != null && contextFile.getVirtualFile() != null && sourceType == this.getDeploymentSourceType(contextFile) && DockerDeploymentConfiguration.ProjectAwareHelper.isForSameFile(context.getProject(), (DockerDeploymentConfiguration)configuration.getDeploymentConfiguration(), contextFile.getVirtualFile());
    }

    @Nullable
    private static PsiFile findPsiFile(ConfigurationContext context) {
        return Optional.ofNullable(context).map(ConfigurationContext::getLocation).map(Location::getPsiElement).filter(PsiFile.class::isInstance).map(PsiFile.class::cast).orElse(null);
    }

    @Nullable
    private static RemoteServer<DockerCloudConfiguration> findFirstDockerAccount() {
        return (RemoteServer)ContainerUtil.getFirstItem((List)RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/deployment/DockerRunConfigurationProducerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onFirstRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

