/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.cli.DockerCliParserBase;
import com.intellij.docker.cli.DockerCliSplitter;
import com.intellij.docker.cli.DockerCliSplitterBase;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCliOptionsField
extends ExpandableTextField {
    private final DockerCliSplitter mySplitter;

    public DockerCliOptionsField() {
        this(new DockerCliSplitter());
    }

    public DockerCliOptionsField(@NotNull DockerCliSplitter splitter) {
        if (splitter == null) {
            DockerCliOptionsField.$$$reportNull$$$0(0);
        }
        super(splitter::splitCliOptions, ParametersListUtil.DEFAULT_LINE_JOINER);
        this.mySplitter = splitter;
    }

    public void setContextFolder(File contextFolder) {
        this.mySplitter.setContextFolder(contextFolder);
    }

    public void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerCliOptionsField.$$$reportNull$$$0(1);
        }
        String optionsLine = configuration.getCommandLineOptions();
        this.setText(optionsLine);
    }

    public void applyValueTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerCliOptionsField.$$$reportNull$$$0(2);
        }
        configuration.setCommandLineOptions(this.getText());
        try {
            this.getParsedOptions();
        }
        catch (ParseException e) {
            throw new RuntimeConfigurationWarning(DockerBundle.getText("DockerCliOptionsField.onParseError", e.getMessage()));
        }
        catch (DockerCliParserBase.IllegalOptionException e) {
            throw new RuntimeConfigurationWarning(e.getMessage());
        }
    }

    @Nullable
    public DockerCliSplitterBase.NormalizedCommandLine getParsedOptions() throws ParseException, DockerCliParserBase.IllegalOptionException {
        String optionsLine = this.getText();
        if (StringUtil.isEmptyOrSpaces((String)optionsLine)) {
            return null;
        }
        return this.mySplitter.trySplitCliOptions(optionsLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerCliOptionsField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyValueTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

