/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeFilesTextField
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent {
    private static final List<String> DOCKER_COMPOSE_YML = ImmutableList.of((Object)"docker-compose.yml", (Object)"docker-compose.yaml");
    private static final String DOCKER_COMPOSE_OVERRIDE_YML = "docker-compose.override.yml";
    protected static final String SEPARATOR = "; ";
    private final Project myProject;
    private final List<ChangeListener> myListeners = ContainerUtil.newSmartList();
    private List<String> myConfigurationFiles = ContainerUtil.newSmartList();
    private boolean myAllowToChoseFolders = true;

    public DockerComposeFilesTextField(@Nullable Project project) {
        this.myProject = project;
        this.setEditable(false);
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DockerComposeFileDialog dialog = new DockerComposeFileDialog(DockerComposeFilesTextField.this.myProject, DockerComposeFilesTextField.this.myConfigurationFiles, DockerComposeFilesTextField.this.myAllowToChoseFolders);
                if (dialog.showAndGet()) {
                    DockerComposeFilesTextField.this.setConfigurationFiles(dialog.getConfigurationFiles());
                }
            }
        });
    }

    public void setAllowToChoseFolders(boolean allowToChooseFolders) {
        this.myAllowToChoseFolders = allowToChooseFolders;
    }

    @NotNull
    public List<String> getConfigurationFiles() {
        List<String> list = this.myConfigurationFiles;
        if (list == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setConfigurationFiles(@NotNull List<String> configurationFiles) {
        if (configurationFiles == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(1);
        }
        this.myConfigurationFiles = configurationFiles;
        this.setText(this.getPresentation(configurationFiles));
        this.fireStateChanged();
    }

    @NotNull
    protected String getPresentation(@NotNull List<String> configurationFiles) {
        if (configurationFiles == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(2);
        }
        if (this.myProject == null || this.myProject.getBasePath() == null) {
            String string = StringUtil.join(configurationFiles, (String)SEPARATOR);
            if (string == null) {
                DockerComposeFilesTextField.$$$reportNull$$$0(3);
            }
            return string;
        }
        File baseDir = new File(this.myProject.getBasePath());
        String string = configurationFiles.stream().map(File::new).map(nextFile -> this.getFilePresentation(baseDir, (File)nextFile)).collect(Collectors.joining(SEPARATOR));
        if (string == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String getFilePresentation(@NotNull File baseDir, @NotNull File file) {
        if (baseDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(6);
        }
        String string = FileUtil.isAncestor((String)baseDir.getPath(), (String)file.getPath(), (boolean)true) ? "." + File.separatorChar + FileUtil.getRelativePath((File)baseDir, (File)file) : file.getPath();
        if (string == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void initComposeFilePaths(@NotNull String baseDir) {
        if (baseDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(8);
        }
        this.setConfigurationFiles(DockerComposeFilesTextField.getConfigurationFilesFromDir(baseDir, false));
    }

    public void initComposeFilePaths(@NotNull List<String> composerFilePaths) {
        String mainConfiguration;
        if (composerFilePaths == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)(mainConfiguration = (String)ContainerUtil.getFirstItem(composerFilePaths))) && Files.isDirectory(Paths.get(mainConfiguration, new String[0]), new LinkOption[0])) {
            this.setConfigurationFiles(DockerComposeFilesTextField.getConfigurationFilesFromDir(mainConfiguration, true));
        } else {
            this.setConfigurationFiles(composerFilePaths);
        }
    }

    @NotNull
    private static List<String> getConfigurationFilesFromDir(@NotNull String configurationDir, boolean withDefault) {
        if (configurationDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(10);
        }
        ArrayList<String> configurationFiles = new ArrayList<String>();
        String mainConfigurationFile = DockerComposeFilesTextField.getMainConfigurationFile(configurationDir, withDefault);
        if (mainConfigurationFile != null) {
            configurationFiles.add(mainConfigurationFile);
            Path overrideConfigurationPath = Paths.get(configurationDir, DOCKER_COMPOSE_OVERRIDE_YML);
            if (Files.exists(overrideConfigurationPath, new LinkOption[0])) {
                configurationFiles.add(overrideConfigurationPath.toString());
            }
        }
        ArrayList<String> arrayList = configurationFiles;
        if (arrayList == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static String getMainConfigurationFile(@NotNull String configurationDir, boolean withDefault) {
        if (configurationDir == null) {
            DockerComposeFilesTextField.$$$reportNull$$$0(12);
        }
        for (String fileName : DOCKER_COMPOSE_YML) {
            Path path = Paths.get(configurationDir, fileName);
            if (!Files.exists(path, new LinkOption[0])) continue;
            return path.toString();
        }
        return withDefault ? Paths.get(configurationDir, DOCKER_COMPOSE_YML.get(0)).toString() : null;
    }

    public void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myListeners.remove(changeListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerComposeFilesTextField";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerFilePaths";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFiles";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerComposeFilesTextField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePresentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFilesFromDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilePresentation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initComposeFilePaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFilesFromDir";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMainConfigurationFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DockerComposeFileDialog
    extends DialogWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JPanel myMainPanel;
        @NotNull
        private final JBList<String> myConfigurationFilesList;
        @NotNull
        private final DefaultListModel<String> myConfigurationFilesModel;
        private final boolean myAllowToChoseFolders;

        protected DockerComposeFileDialog(@Nullable Project project, @NotNull List<String> configurationFiles, boolean allowToChoseFolders) {
            if (configurationFiles == null) {
                DockerComposeFileDialog.$$$reportNull$$$0(0);
            }
            super(project);
            this.setTitle(DockerBundle.getText("DockerComposeFilesTextField.DockerComposeFileDialog.title", new Object[0]));
            this.myProject = project;
            this.myAllowToChoseFolders = allowToChoseFolders;
            this.myConfigurationFilesModel = new DefaultListModel();
            this.myConfigurationFilesList = new JBList(this.myConfigurationFilesModel);
            configurationFiles.forEach(file -> this.myConfigurationFilesModel.addElement(FileUtil.toSystemDependentName((String)file)));
            this.myMainPanel = ToolbarDecorator.createDecorator(this.myConfigurationFilesList).setAddAction(button -> this.addConfigurationFileItem()).setRemoveAction(button -> this.deleteConfigurationFileItems()).createPanel();
            this.init();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return DockerComposeFileDialog.class.getSimpleName();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        @NotNull
        private String getChooserTitle() {
            String string = this.myAllowToChoseFolders ? DockerBundle.getText("DockerComposeFilesTextField.DockerComposeFileDialog.title.chooser.fileOrFolder", new Object[0]) : DockerBundle.getText("DockerComposeFilesTextField.DockerComposeFileDialog.title.chooser.fileOnly", new Object[0]);
            if (string == null) {
                DockerComposeFileDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        private void addConfigurationFileItem() {
            FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, this.myAllowToChoseFolders, false, true, false, true);
            fileChooserDescriptor.withTitle(this.getChooserTitle());
            VirtualFile toSelect = this.myProject == null ? null : this.myProject.getBaseDir();
            FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.myProject, this.myConfigurationFilesList, (VirtualFile)toSelect, this::onConfigurationFileChosen);
        }

        private void onConfigurationFileChosen(List<VirtualFile> chosenFiles) {
            LinkedHashSet<String> systemDependentPaths = new LinkedHashSet<String>();
            for (VirtualFile nextFile : chosenFiles) {
                if (nextFile.isDirectory()) {
                    DockerComposeFilesTextField.getConfigurationFilesFromDir(nextFile.getPath(), false).stream().map(FileUtil::toSystemDependentName).forEach(systemDependentPaths::add);
                    continue;
                }
                systemDependentPaths.add(FileUtil.toSystemDependentName((String)nextFile.getPath()));
            }
            systemDependentPaths.removeAll(Collections.list(this.myConfigurationFilesModel.elements()));
            systemDependentPaths.forEach(configurationFile -> this.myConfigurationFilesModel.addElement((String)configurationFile));
        }

        private void deleteConfigurationFileItems() {
            ListUtil.removeSelectedItems(this.myConfigurationFilesList);
        }

        @NotNull
        public List<String> getConfigurationFiles() {
            SmartList configurationFilePaths = new SmartList();
            for (int i = 0; i < this.myConfigurationFilesList.getModel().getSize(); ++i) {
                configurationFilePaths.add(this.myConfigurationFilesList.getModel().getElementAt(i));
            }
            SmartList smartList = configurationFilePaths;
            if (smartList == null) {
                DockerComposeFileDialog.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationFiles";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/deployment/ui/DockerComposeFilesTextField$DockerComposeFileDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/deployment/ui/DockerComposeFilesTextField$DockerComposeFileDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChooserTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

