/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.cli.DockerRunCliBuilder;
import com.intellij.docker.deployment.ui.DockerBuildSettingsUI;
import com.intellij.docker.deployment.ui.DockerContainerSettingsUI;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentEditor
extends SettingsEditor<DockerDeploymentConfiguration> {
    private final boolean myImageNotFileSource;
    private final Project myProject;
    private JPanel myMainPanel;
    private JTextField myImageIdTextField;
    private JBLabel myImageIdLabel;
    private JPanel myBuildImageOptionsPanel;
    private JPanel myContainerOptionsPanel;
    private JTextField myContainerNameTextField;
    private JBCheckBox myShouldRunContainerCheckbox;
    private ExpandableTextField myCommandPreviewField;
    private JTextField myHiddenPathJsonFileField;
    private DockerContainerSettingsUI myContainerSettingsUI;
    private DockerBuildSettingsUI myBuildSettingsUI;

    public DockerDeploymentEditor(@NotNull Project project, boolean imageNotFileSource) {
        if (project == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myImageNotFileSource = imageNotFileSource;
        this.$$$setupUI$$$();
        if (this.myImageNotFileSource) {
            this.myBuildImageOptionsPanel.setVisible(false);
            this.myShouldRunContainerCheckbox.setVisible(false);
            this.myImageIdTextField.setVisible(true);
            this.myImageIdLabel.setVisible(true);
        } else {
            this.myBuildImageOptionsPanel.setVisible(true);
            this.myBuildSettingsUI.setContextFolderListener(this.myContainerSettingsUI::setContextFolder);
            this.myShouldRunContainerCheckbox.setVisible(true);
            this.myImageIdTextField.setVisible(false);
            this.myImageIdLabel.setVisible(false);
        }
        this.myCommandPreviewField.setForeground(UIUtil.getInactiveTextColor());
        this.myHiddenPathJsonFileField.setVisible(false);
    }

    protected void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(1);
        }
        if (this.myImageNotFileSource) {
            this.myImageIdTextField.setText(configuration.getImageTag());
        } else {
            this.myBuildSettingsUI.resetEditorFrom(configuration);
            this.myShouldRunContainerCheckbox.setSelected(!configuration.isBuildOnly());
        }
        this.myContainerNameTextField.setText(configuration.getContainerName());
        this.myContainerSettingsUI.resetEditorFrom(configuration);
        this.myHiddenPathJsonFileField.setText(configuration.getJSONFilePath());
    }

    protected void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(2);
        }
        this.updatePreview();
        configuration.setContainerName(this.myContainerNameTextField.getText());
        if (this.myImageNotFileSource) {
            configuration.setImageTag(this.myImageIdTextField.getText());
            configuration.setBuildArgs(null);
        } else {
            this.myBuildSettingsUI.applyEditorTo(configuration);
            configuration.setBuildOnly(!this.myShouldRunContainerCheckbox.isSelected());
        }
        this.myContainerSettingsUI.applyEditorTo(configuration);
        if (!StringUtil.isEmptyOrSpaces((String)this.myHiddenPathJsonFileField.getText())) {
            throw new RuntimeConfigurationWarning(DockerBundle.getText("DockerDeploymentEditor.error.json.file.is.not.supported", new Object[0]), () -> {
                if (configuration == null) {
                    DockerDeploymentEditor.$$$reportNull$$$0(6);
                }
                this.migrateUnsupportedJSONFile(configuration);
            });
        }
        configuration.setJSONFilePath(this.myHiddenPathJsonFileField.getText());
    }

    private void migrateUnsupportedJSONFile(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(3);
        }
        Optional.ofNullable(configuration.getJSONFilePath()).map(FileUtil::toSystemDependentName).map(arg_0 -> ((LocalFileSystem)LocalFileSystem.getInstance()).findFileByPath(arg_0)).ifPresent(vFile -> FileEditorManager.getInstance((Project)this.myProject).openFile(vFile, true));
        this.myHiddenPathJsonFileField.setText(null);
    }

    @NotNull
    private String getNotEmptyImageTag() {
        String imageTag = this.myImageNotFileSource ? this.myImageIdTextField.getText() : this.myBuildSettingsUI.getNotEmptyImageTag();
        String string = StringUtil.isEmptyOrSpaces((String)imageTag) ? "<image_tag>" : imageTag;
        if (string == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void updatePreview() {
        LinkedList<String> allLines = new LinkedList<String>();
        String imageTag = this.getNotEmptyImageTag();
        if (!this.myImageNotFileSource) {
            List<String> buildLines = this.myBuildSettingsUI.prepareBuildCliBuilder().buildPreviewLines();
            allLines.add(buildLines.stream().collect(Collectors.joining(" ")));
        }
        if (this.myImageNotFileSource || this.myShouldRunContainerCheckbox.isSelected()) {
            DockerRunCliBuilder runBuilder = this.myContainerSettingsUI.prepareRunCliBuilder(imageTag);
            runBuilder.setContainerTag(this.myContainerNameTextField.getText());
            allLines.addAll(runBuilder.buildPreviewLines(!allLines.isEmpty()));
        }
        this.getCommandPreviewField().setSplittedText(allLines);
    }

    private void createUIComponents() {
        this.myContainerSettingsUI = new DockerContainerSettingsUI(this.myProject);
        this.myContainerOptionsPanel = this.myContainerSettingsUI.getMainPanel();
        this.myBuildSettingsUI = new DockerBuildSettingsUI(this.myProject);
        this.myBuildImageOptionsPanel = this.myBuildSettingsUI.getMainPanel();
        this.myCommandPreviewField = new CommandPreviewField();
    }

    private CommandPreviewField getCommandPreviewField() {
        return (CommandPreviewField)this.myCommandPreviewField;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyImageTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "migrateUnsupportedJSONFile";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyEditorTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JBCheckBox jBCheckBox;
        JTextField jTextField2;
        JTextField jTextField3;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myImageIdLabel = jBLabel = new JBLabel();
        jBLabel.setText("Image ID:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageIdTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myContainerNameTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Container name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShouldRunContainerCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Run built image");
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myContainerOptionsPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setEnabled(false);
        jBLabel3.setText("Command preview:");
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ExpandableTextField expandableTextField = this.myCommandPreviewField;
        expandableTextField.setEditable(false);
        expandableTextField.setEnabled(true);
        jPanel.add((Component)expandableTextField, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myHiddenPathJsonFileField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(6, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = this.myBuildImageOptionsPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        jBLabel.setLabelFor(jTextField3);
        jBLabel2.setLabelFor(jTextField2);
        jBLabel3.setLabelFor((Component)expandableTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class CommandPreviewField
    extends ExpandableTextField {
        private final ExternalSplitter mySplitter;

        public CommandPreviewField() {
            this(new ExternalSplitter());
        }

        public CommandPreviewField(ExternalSplitter splitter) {
            super((Function)splitter, ParametersListUtil.DEFAULT_LINE_JOINER);
            this.mySplitter = splitter;
        }

        public void setSplittedText(@NotNull List<String> split) {
            String text;
            boolean changed;
            if (split == null) {
                CommandPreviewField.$$$reportNull$$$0(0);
            }
            if (changed = this.mySplitter.setTextAndCustomSplit(text = (String)ParametersListUtil.DEFAULT_LINE_JOINER.fun(split), split)) {
                super.setText(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/intellij/docker/deployment/ui/DockerDeploymentEditor$CommandPreviewField", "setSplittedText"));
        }

        static class ExternalSplitter
        implements Function<String, List<String>> {
            private String myExpectedText;
            private List<String> myExpectedSplit;

            ExternalSplitter() {
            }

            public boolean setTextAndCustomSplit(@NotNull String expectedText, @NotNull List<String> expectedSplit) {
                boolean changed;
                if (expectedText == null) {
                    ExternalSplitter.$$$reportNull$$$0(0);
                }
                if (expectedSplit == null) {
                    ExternalSplitter.$$$reportNull$$$0(1);
                }
                boolean bl = changed = !expectedText.equals(this.myExpectedText);
                if (changed) {
                    this.myExpectedText = expectedText;
                    this.myExpectedSplit = expectedSplit;
                }
                return changed;
            }

            public List<String> fun(String text) {
                if (this.myExpectedText == null) {
                    throw new IllegalStateException("I am not ready to split anything");
                }
                if (!text.equals(this.myExpectedText)) {
                    // empty if block
                }
                return this.myExpectedSplit;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedSplit";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor$CommandPreviewField$ExternalSplitter";
                objectArray[2] = "setTextAndCustomSplit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

