/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Optional;
import javax.swing.JComboBox;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerDeploymentSourcePathCombo
extends ComboboxWithBrowseButton {
    public DockerDeploymentSourcePathCombo() {
        super((JComboBox)new ComboBox());
        this.getComboBox().setEditable(true);
    }

    public void applyUiTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(0);
        }
        configuration.setSourceFilePath(this.getValueToApply());
    }

    public String getValueToApply() {
        String displayPath = (String)this.getComboBox().getEditor().getItem();
        return displayPath == null ? null : FileUtil.toSystemIndependentName((String)displayPath);
    }

    public void resetUiFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(1);
        }
        String sourcePath = Optional.ofNullable(configuration.getSourceFilePath()).filter(path -> !StringUtil.isEmptyOrSpaces((String)path)).map(FileUtil::toSystemDependentName).orElse(null);
        this.getComboBox().setSelectedItem(sourcePath);
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(2);
        }
        this.getTextComponent().getDocument().addDocumentListener(listener);
    }

    public void addPredefinedFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(4);
        }
        String nextDisplayPath = this.getPathToDisplay(project, file);
        this.getComboBox().addItem(nextDisplayPath);
    }

    public void addBrowseFolderActionListener(final @NotNull Project project, @NotNull @Nls String title, @NotNull @Nls String description, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        if (project == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(5);
        }
        if (title == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(6);
        }
        if (description == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(7);
        }
        if (fileChooserDescriptor == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(8);
        }
        this.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JComboBox>(title, description, (ComponentWithBrowseButton)this, project, fileChooserDescriptor, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = DockerDeploymentSourcePathCombo.this.getPathToDisplay(project, chosenFile);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            protected VirtualFile getInitialFile() {
                String currentValue = this.getComponentText();
                if (StringUtil.isEmptyOrSpaces((String)currentValue)) {
                    return null;
                }
                File ioFile = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(project, currentValue);
                if (ioFile == null) {
                    return null;
                }
                return LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    protected String getPathToDisplay(@NotNull Project project, @NotNull VirtualFile chosenFile) {
        if (project == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(9);
        }
        if (chosenFile == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(10);
        }
        String storeable = DockerDeploymentConfiguration.ProjectAwareHelper.getPathToStore(project, chosenFile);
        String string = FileUtil.toSystemDependentName((String)storeable);
        if (string == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(11);
        }
        return string;
    }

    private JTextComponent getTextComponent() {
        return (JTextComponent)((JComboBox)this.getChildComponent()).getEditor().getEditorComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyUiTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetUiFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderActionListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathToDisplay";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

