/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.deployment.ui.DockerTextFieldWithBrowseButton;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DockerKeyValueFieldWithBrowseButton
extends DockerTextFieldWithBrowseButton {
    private EnvironmentVariablesData myData = EnvironmentVariablesData.DEFAULT;

    public DockerKeyValueFieldWithBrowseButton() {
        this.setEditable(false);
        this.addActionListener(e -> this.showDialog());
    }

    protected void showDialog() {
        MyDialog dialog = new MyDialog(this);
        dialog.setTitle(this.getDialogTitle());
        dialog.setEmptyText(this.getEmptyText());
        dialog.show();
    }

    @NotNull
    protected abstract String getDialogTitle();

    @NotNull
    protected abstract String getEmptyText();

    @NotNull
    protected String stringifyPairs(@NotNull Map<String, String> pairs) {
        if (pairs == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(0);
        }
        if (pairs.isEmpty()) {
            if ("" == null) {
                DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(1);
            }
            return "";
        }
        String string = pairs.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("; "));
        if (string == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getPairs() {
        Map map = this.myData.getEnvs();
        if (map == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(3);
        }
        return map;
    }

    public void setPairs(@NotNull Map<String, String> pairs) {
        if (pairs == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(4);
        }
        this.setData(EnvironmentVariablesData.create(pairs, (boolean)false));
    }

    public void setData(@NotNull EnvironmentVariablesData data) {
        if (data == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(5);
        }
        EnvironmentVariablesData oldData = this.myData;
        this.myData = data;
        this.setText(this.stringifyPairs(data.getEnvs()));
        if (!oldData.equals((Object)data)) {
            this.fireStateChanged();
        }
    }

    @NotNull
    public <T> List<T> mapPairs(@NotNull BiFunction<String, String, T> producer) {
        if (producer == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(6);
        }
        List list = this.getPairs().entrySet().stream().map(e -> {
            if (producer == null) {
                DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(9);
            }
            return producer.apply((String)e.getKey(), (String)e.getValue());
        }).collect(Collectors.toList());
        if (list == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected final void setPairs(@NotNull List<EnvironmentVariable> fromDialog) {
        if (fromDialog == null) {
            DockerKeyValueFieldWithBrowseButton.$$$reportNull$$$0(8);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (EnvironmentVariable variable : fromDialog) {
            result.put(variable.getName(), variable.getValue());
        }
        this.setPairs(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerKeyValueFieldWithBrowseButton";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerKeyValueFieldWithBrowseButton";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyPairs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mapPairs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringifyPairs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPairs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mapPairs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mapPairs$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MyDialog
    extends DialogWrapper {
        private final DockerKeyValueFieldWithBrowseButton myParent;
        private final EnvVariablesTable myEnvVariablesTable;
        private final JPanel myPanel;

        public MyDialog(DockerKeyValueFieldWithBrowseButton parent) {
            super((Component)((Object)parent), true);
            this.myParent = parent;
            this.myPanel = new JPanel(new BorderLayout());
            this.myEnvVariablesTable = new EnvVariablesTable();
            this.myEnvVariablesTable.setValues(parent.mapPairs((key, value) -> new EnvironmentVariable(key, value, false)));
            this.myPanel.add((Component)this.myEnvVariablesTable.getComponent(), "Center");
            this.init();
        }

        public void setEmptyText(@NotNull String emptyText) {
            if (emptyText == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            this.myEnvVariablesTable.getTableView().getEmptyText().setText(emptyText);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        protected void doOKAction() {
            this.myEnvVariablesTable.stopEditing();
            this.myParent.setPairs(this.myEnvVariablesTable.getEnvironmentVariables());
            super.doOKAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/docker/deployment/ui/DockerKeyValueFieldWithBrowseButton$MyDialog", "setEmptyText"));
        }
    }
}

