/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deployment.ui.DockerBindingsFieldBase;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DockerVolumeBindingsField
extends DockerBindingsFieldBase<DockerVolumeBindingImpl> {
    private String mySampleHostPath;

    public DockerVolumeBindingsField() {
        this.addActionListener(e -> this.showDialog());
        this.setEditable(false);
    }

    public DockerVolumeBindingsField withSampleHostPath(@Nullable String sampleHostPath) {
        this.mySampleHostPath = sampleHostPath;
        return this;
    }

    private void showDialog() {
        DockerBindingsFieldBase.BindingsDialogBase<DockerVolumeBindingImpl> dialog = new DockerBindingsFieldBase.BindingsDialogBase<DockerVolumeBindingImpl>(this, new VolumeBindingsTable());
        dialog.setTitle(DockerBundle.getText("DockerVolumeBindingsField.dialogTitle", new Object[0]));
        dialog.setEmptyText(DockerBundle.getText("DockerVolumeBindingsField.dialogEmptyText", new Object[0]));
        dialog.show();
    }

    @Override
    protected String stringify(@NotNull DockerVolumeBindingImpl binding) {
        if (binding == null) {
            DockerVolumeBindingsField.$$$reportNull$$$0(0);
        }
        return binding.toCommandLineString();
    }

    @Override
    protected String stringifyAll(@NotNull List<DockerVolumeBindingImpl> list) {
        if (list == null) {
            DockerVolumeBindingsField.$$$reportNull$$$0(1);
        }
        return this.stringifyAll(list, "  ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerVolumeBindingsField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "stringify";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "stringifyAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LocalPathCellEditorEx
    extends LocalPathCellEditor {
        private LocalPathCellEditorEx() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component result = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            assert (result == this.myComponent);
            this.myComponent.requestFocus();
            return result;
        }
    }

    private class VolumeBindingsTable
    extends DockerBindingsFieldBase.BindingsTableBase<DockerVolumeBindingImpl> {
        private final DockerVolumeBindingImpl EMPTY = new DockerVolumeBindingImpl();

        private VolumeBindingsTable() {
        }

        protected ListTableModel createListModel() {
            DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl> source = new DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl>(DockerBundle.getText("DockerVolumeBindingsField.VolumeBindingsTable.source", new Object[0]), DockerVolumeBindingImpl::getHostPath, DockerVolumeBindingImpl::setHostPath){

                @Nullable
                public TableCellEditor getEditor(DockerVolumeBindingImpl item) {
                    return new LocalPathCellEditorEx().fileChooserDescriptor(FileChooserDescriptorFactory.createSingleFolderDescriptor());
                }

                @Nullable
                public String getPreferredStringValue() {
                    return DockerVolumeBindingsField.this.mySampleHostPath;
                }
            };
            DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl> destination = new DockerBindingsFieldBase.BindingsTableBase.StringColumnBase<DockerVolumeBindingImpl>(DockerBundle.getText("DockerVolumeBindingsField.VolumeBindingsTable.destination", new Object[0]), DockerVolumeBindingImpl::getContainerPath, DockerVolumeBindingImpl::setContainerPath){

                public String getMaxStringValue() {
                    return "/some/reasonably/long/container/path";
                }
            };
            DockerBindingsFieldBase.BindingsTableBase.BooleanColumnBase<DockerVolumeBindingImpl> readOnly = new DockerBindingsFieldBase.BindingsTableBase.BooleanColumnBase<DockerVolumeBindingImpl>(DockerBundle.getText("DockerVolumeBindingsField.VolumeBindingsTable.readOnly", new Object[0]), DockerVolumeBindingImpl::isReadOnly, DockerVolumeBindingImpl::setReadOnly);
            return new ListTableModel(new ColumnInfo[]{source, destination, readOnly});
        }

        protected DockerVolumeBindingImpl createElement() {
            return new DockerVolumeBindingImpl();
        }

        protected boolean isEmpty(DockerVolumeBindingImpl element) {
            return this.EMPTY.equals((Object)element);
        }

        protected DockerVolumeBindingImpl cloneElement(DockerVolumeBindingImpl variable) {
            return new DockerVolumeBindingImpl((DockerVolumeBinding)variable);
        }

        protected boolean canDeleteElement(DockerVolumeBindingImpl selection) {
            return true;
        }
    }
}

