/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.RegistryAuthCallback;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRegistryConfigurable
extends NamedConfigurable<DockerRegistry> {
    private JComboBox myAddressComboBox;
    private JTextField myUsernameTextField;
    private JPasswordField myPasswordField;
    private JTextField myEmailTextField;
    private JPanel myMainPanel;
    private JBLabel myConnectionStatusLabel;
    private JComboBox myServerComboBox;
    private final DockerRegistry myRegistry;
    private boolean myNew;
    private String myRegistryName;
    private final DelayedRunner myRunner;
    private ConnectionTester myConnectionTester;

    public DockerRegistryConfigurable(DockerRegistry registry, Runnable treeUpdater, boolean isNew) {
        super(true, treeUpdater);
        this.myRegistry = registry;
        this.myNew = isNew;
        this.$$$setupUI$$$();
        this.myRegistryName = registry.getName();
        this.myAddressComboBox.addItem("registry.hub.docker.com");
        for (String provider : DockerRegistry.PROVIDER_ADDRESSES) {
            this.myAddressComboBox.addItem(provider);
        }
        this.resetAddressComboBox();
        for (RemoteServer account : RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance())) {
            this.myServerComboBox.addItem(new ServerItem(account));
        }
        this.myRunner = new DelayedRunner(this.myMainPanel){
            private DockerRegistry myPreviousConfig;
            private RemoteServer<?> myPreviousServer;

            protected boolean wasChanged() {
                RemoteServer<?> currentServer;
                DockerRegistry currentConfig = new DockerRegistry();
                try {
                    DockerRegistryConfigurable.this.applyTo(currentConfig);
                }
                catch (ConfigurationException e) {
                    DockerRegistryConfigurable.this.setConnectionStatus("");
                    DockerRegistryConfigurable.this.myConnectionTester = null;
                    return true;
                }
                ServerItem selectedServerItem = (ServerItem)DockerRegistryConfigurable.this.myServerComboBox.getSelectedItem();
                RemoteServer<?> remoteServer = currentServer = selectedServerItem == null ? null : selectedServerItem.getServer();
                if (this.myPreviousConfig != null && DockerRegistryConfigurable.isConfigEqual(this.myPreviousConfig, currentConfig) && this.myPreviousServer != null && this.myPreviousServer == currentServer) {
                    return false;
                }
                DockerRegistryConfigurable.this.myConnectionTester = null;
                DockerRegistryConfigurable.this.setConnectionStatus("");
                this.myPreviousConfig = currentConfig;
                this.myPreviousServer = currentServer;
                return true;
            }

            protected void run() {
                if (!this.myPreviousConfig.hasUserData()) {
                    return;
                }
                DockerRegistryConfigurable.this.setConnectionStatus("Connecting...");
                DockerRegistryConfigurable.this.myConnectionTester = new ConnectionTester();
                DockerRegistryConfigurable.this.myConnectionTester.testConnection(this.myPreviousConfig, this.myPreviousServer);
            }
        };
    }

    private void setConnectionStatus(String text) {
        this.myConnectionStatusLabel.setText(UIUtil.toHtml((String)text));
        this.myConnectionStatusLabel.setVisible(StringUtil.isNotEmpty((String)text));
    }

    private void resetAddressComboBox() {
        this.myAddressComboBox.setSelectedItem(this.myNew ? "registry.hub.docker.com" : this.myRegistry.getAddress());
    }

    private static boolean isConfigEqual(DockerRegistry config1, DockerRegistry config2) {
        return Comparing.equal((String)config1.getAddress(), (String)config2.getAddress()) && Comparing.equal((String)config1.getUsername(), (String)config2.getUsername()) && Comparing.equal((String)config1.getPasswordSafe(), (String)config2.getPasswordSafe()) && Comparing.equal((String)config1.getEmail(), (String)config2.getEmail());
    }

    public boolean isModified() {
        if (this.myNew) {
            return true;
        }
        DockerRegistry currentConfig = new DockerRegistry();
        try {
            this.applyTo(currentConfig);
        }
        catch (ConfigurationException e) {
            return true;
        }
        return !DockerRegistryConfigurable.isConfigEqual(this.myRegistry, currentConfig) || !this.myRegistry.isPasswordSafe();
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myRegistry);
        this.myNew = false;
    }

    public void reset() {
        this.myEmailTextField.setText(this.myRegistry.getEmail());
        this.myPasswordField.setText(this.myRegistry.getPasswordSafe());
        this.resetAddressComboBox();
        this.myUsernameTextField.setText(this.myRegistry.getUsername());
    }

    protected void applyTo(DockerRegistry registry) throws ConfigurationException {
        String address = ((JTextComponent)this.myAddressComboBox.getEditor().getEditorComponent()).getText();
        if (StringUtil.isEmpty((String)address)) {
            throw new RuntimeConfigurationException("Address required");
        }
        String username = this.myUsernameTextField.getText();
        String password = new String(this.myPasswordField.getPassword());
        String email = this.myEmailTextField.getText();
        boolean hasUsername = StringUtil.isEmpty((String)username);
        boolean hasPassword = StringUtil.isEmpty((String)password);
        boolean hasEmail = StringUtil.isEmpty((String)email);
        if (!(!hasUsername && !hasPassword && !hasEmail || hasUsername && hasPassword && hasEmail)) {
            throw new RuntimeConfigurationException("Either all or none of Username, Password and Email should be specified");
        }
        registry.setAddress(address);
        registry.setUsername(username);
        registry.setPasswordSafe(password);
        registry.setEmail(email);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myRunner);
    }

    public void setDisplayName(String name) {
        this.myRegistryName = name;
    }

    public DockerRegistry getEditableObject() {
        return this.myRegistry;
    }

    public String getBannerSlogan() {
        return this.myRegistry.getName();
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    @Nls
    public String getDisplayName() {
        return this.myRegistryName;
    }

    @Nullable
    public String getHelpTopic() {
        return "Docker_Registry_dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JTextField jTextField;
        JPasswordField jPasswordField;
        JTextField jTextField2;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 10, 0, 10), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Address:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddressComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Username:");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEmailTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Password:");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Email:");
        jPanel.add((Component)jBLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Test connection");
        jPanel.add((Component)titledSeparator, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Server:");
        jPanel.add((Component)jBLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConnectionStatusLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(6, 0, 1, 2, 8, 0, 1, 0, null, null, null));
        this.myServerComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        jPanel.add(jComboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox2);
        jBLabel3.setLabelFor(jTextField2);
        jBLabel4.setLabelFor(jPasswordField);
        jBLabel5.setLabelFor(jTextField);
        jBLabel6.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class ServerItem {
        private final RemoteServer<?> myServer;

        public ServerItem(RemoteServer<?> server) {
            this.myServer = server;
        }

        public RemoteServer<?> getServer() {
            return this.myServer;
        }

        public String toString() {
            return this.myServer.getName();
        }
    }

    private class ConnectionTester {
        private ConnectionTester() {
        }

        public void testConnection(final DockerRegistry registry, RemoteServer<?> account) {
            final ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(account);
            final AtomicReference<Object> errorMessageRef = new AtomicReference<Object>(null);
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

                public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                    if (serverRuntimeInstance == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ((DockerServerRuntimeInstance)serverRuntimeInstance).imageRegistryAuth(registry, new RegistryAuthCallback(){

                        public void errorOccurred(@NotNull String errorMessage) {
                            if (errorMessage == null) {
                                ConnectionTester.1.$$$reportNull$$$0(0);
                            }
                            errorMessageRef.set(errorMessage);
                            semaphore.up();
                            connection.disconnect();
                        }

                        @Override
                        public void succeeded() {
                            semaphore.up();
                            connection.disconnect();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/docker/registry/DockerRegistryConfigurable$ConnectionTester$1$1", "errorOccurred"));
                        }
                    });
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    errorMessageRef.set(connection.getStatusText());
                    semaphore.up();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "serverRuntimeInstance";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/docker/registry/DockerRegistryConfigurable$ConnectionTester$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "connected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            new Task.Backgroundable(null, "Connecting...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    do {
                        if (!indicator.isCanceled()) continue;
                        return;
                    } while (!semaphore.waitFor(500L));
                    UIUtil.invokeLaterIfNeeded(() -> {
                        String errorMessage = (String)errorMessageRef.get();
                        if (DockerRegistryConfigurable.this.myConnectionTester == ConnectionTester.this) {
                            DockerRegistryConfigurable.this.setConnectionStatus(errorMessage == null ? "Connection successful" : "Cannot connect: " + errorMessage);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/registry/DockerRegistryConfigurable$ConnectionTester$2", "run"));
                }
            }.queue();
        }
    }
}

