/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ComposeDeploymentRuntime
extends ComposeApplicationRuntime {
    private final Project myProject;
    private final DeploymentTask<DockerDeploymentConfiguration> myTask;
    private final DeploymentLogManager myLogManager;
    private final DockerCloudConfiguration myServerConfiguration;
    private final List<File> myComposeFiles;
    private final File myWorkingDirectory;

    public ComposeDeploymentRuntime(DockerAgent agent, DeploymentTask<DockerDeploymentConfiguration> task, DeploymentLogManager logManager, ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, DockerCloudConfiguration serverConfiguration) throws ServerRuntimeException {
        this(agent, task, logManager, taskExecutor, agentTaskExecutor, serverConfiguration, ComposeDeploymentRuntime.getComposeFiles(task.getProject(), (DockerDeploymentConfiguration)task.getConfiguration()));
    }

    public ComposeDeploymentRuntime(DockerAgent agent, DeploymentTask<DockerDeploymentConfiguration> task, DeploymentLogManager logManager, ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, DockerCloudConfiguration serverConfiguration, List<File> composeFiles) throws ServerRuntimeException {
        super(taskExecutor, agentTaskExecutor, ComposeDeploymentRuntime.computeApplicationId(composeFiles));
        this.myProject = task.getProject();
        this.myTask = task;
        this.myLogManager = logManager;
        this.myServerConfiguration = serverConfiguration;
        this.myComposeFiles = composeFiles;
        this.myWorkingDirectory = ComposeDeploymentRuntime.computeWorkingDir(this.myComposeFiles);
    }

    @Override
    @NotNull
    public String getComposeProjectName() {
        String string = ComposeDeploymentRuntime.computeErasedProjectName(this.myWorkingDirectory.getName());
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean mayHaveComposeProjectName(@NotNull String projectName) {
        if (projectName == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(1);
        }
        return ComposeDeploymentRuntime.computeErasedProjectName(projectName).equals(this.getComposeProjectName());
    }

    @NotNull
    private static String computeErasedProjectName(@NotNull String name) {
        if (name == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(2);
        }
        String string = StringUtil.toLowerCase((String)name.replaceAll("[^a-zA-Z0-9]+", ""));
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public List<File> getComposeFiles() {
        List<File> list = Collections.unmodifiableList(this.myComposeFiles);
        if (list == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime getRuntimeHelper() throws ServerRuntimeException {
        RemoteDockerRuntime result = RemoteDockerRuntime.create(this.myServerConfiguration, this.myProject);
        assert (result != null);
        RemoteDockerRuntime remoteDockerRuntime = result;
        if (remoteDockerRuntime == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(5);
        }
        return remoteDockerRuntime;
    }

    private Map<String, String> getTaskEnvVars() {
        return ((DockerDeploymentConfiguration)this.myTask.getConfiguration()).getEnvVars().stream().filter(var -> !StringUtil.isEmptyOrSpaces((String)var.getName())).collect(Collectors.toMap(var -> StringUtil.trim((String)var.getName()), var -> StringUtil.trim((String)var.getValue()), (oldVal, newVal) -> newVal));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder) {
        if (cliBuilder == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(6);
        }
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        GeneralCommandLine cli = cliBuilder.buildCommandLine().withWorkDirectory(this.myWorkingDirectory).withEnvironment(this.getTaskEnvVars());
        try {
            ColoredProcessHandler processHandler = new ColoredProcessHandler(cli);
            this.myLogManager.getMainLoggingHandler().attachToProcess((ProcessHandler)processHandler);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    int exitCode;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((exitCode = event.getExitCode()) == 0) {
                        result.complete(null);
                    } else {
                        result.completeExceptionally(new CompletionException("`docker-compose` process finished with exit code " + exitCode, null));
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            processHandler.startNotify();
        }
        catch (ExecutionException e) {
            result.completeExceptionally(e);
        }
        CompletableFuture<Void> completableFuture = result;
        if (completableFuture == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    private DockerDeploymentConfiguration getDeploymentConfiguration() {
        return (DockerDeploymentConfiguration)this.myTask.getConfiguration();
    }

    @NotNull
    private LoggingHandler getMainLoggingHandler() {
        LoggingHandler loggingHandler = this.myLogManager.getMainLoggingHandler();
        if (loggingHandler == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(8);
        }
        return loggingHandler;
    }

    public void deploy(ServerRuntimeInstance.DeploymentOperationCallback callback) {
        CompletableFuture<?> promise;
        try {
            promise = this.doDeploy();
        }
        catch (ServerRuntimeException e2) {
            callback.errorOccurred(e2.getMessage());
            return;
        }
        ((CompletableFuture)promise.thenRun(() -> callback.succeeded((DeploymentRuntime)this))).exceptionally(e -> {
            callback.errorOccurred(e.getMessage());
            return null;
        });
    }

    @NotNull
    private static List<File> getComposeFiles(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) {
        if (project == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(10);
        }
        LinkedList<String> paths = new LinkedList<String>();
        paths.add(configuration.getSourceFilePath());
        paths.addAll(configuration.getSecondarySourceFiles());
        List<File> list = paths.stream().filter(Objects::nonNull).map(path -> {
            if (project == null) {
                ComposeDeploymentRuntime.$$$reportNull$$$0(18);
            }
            return DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(project, path);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static String computeApplicationId(@NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(12);
        }
        return "Docker-compose: " + ComposeDeploymentRuntime.computeWorkingDir(composeFiles).getName();
    }

    private static File computeWorkingDir(@NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(13);
        }
        ComposeDeploymentRuntime.validateComposeFiles(composeFiles);
        return composeFiles.get(0).getParentFile();
    }

    private static void validateComposeFiles(@NotNull List<File> files) throws ServerRuntimeException {
        if (files == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(14);
        }
        if (files.isEmpty()) {
            throw new ServerRuntimeException("Compose file is not specified");
        }
        Optional<File> firstMissing = files.stream().filter(f -> !f.exists() || !f.isFile()).findFirst();
        if (firstMissing.isPresent()) {
            throw new ServerRuntimeException("Can't read compose file at " + firstMissing.get());
        }
    }

    private CompletableFuture<?> doDeploy() throws ServerRuntimeException {
        DockerComposeUpCliBuilder cliBuilder = (DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(this.getRuntimeHelper()).withDetached(true).withForcedBuild(this.isForcedBuild()).withFiles(this.getComposeFilePaths());
        List<String> services = this.getDeploymentConfiguration().getServices();
        if (!services.isEmpty()) {
            cliBuilder = cliBuilder.withServices(ArrayUtil.toStringArray(services));
        }
        return this.executeCli(cliBuilder);
    }

    private boolean isForcedBuild() {
        return DockerComposeDeploymentSourceType.getInstance().isForceBuild(this.getDeploymentConfiguration());
    }

    public CompletableFuture<?> down() throws ServerRuntimeException {
        RemoteDockerRuntime helper = this.getRuntimeHelper();
        DockerComposeDownCliBuilder cliBuilder = ((DockerComposeDownCliBuilder)DockerComposeCliUtil.buildDownCommand(helper).withFiles(this.getComposeFilePaths())).withRemoveOrphans();
        return this.executeCli(cliBuilder);
    }

    public CompletableFuture<?> stopAllServices() throws ServerRuntimeException {
        RemoteDockerRuntime helper = this.getRuntimeHelper();
        String[] allServices = (String[])this.getServiceRuntimes().stream().map(ComposeServiceRuntime::getServiceName).toArray(String[]::new);
        DockerComposeStopCliBuilder cliBuilder = ((DockerComposeStopCliBuilder)DockerComposeCliUtil.buildStopCommand(helper).withFiles(this.getComposeFilePaths())).withServices(allServices);
        return this.executeCli(cliBuilder);
    }

    @Override
    public boolean isUndeploySupported() {
        return true;
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        CompletableFuture<?> downPromise;
        if (callback == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(15);
        }
        try {
            downPromise = this.down();
        }
        catch (ServerRuntimeException e2) {
            callback.errorOccurred(e2.getMessage());
            return;
        }
        ((CompletableFuture)downPromise.thenRun(() -> {
            if (callback == null) {
                ComposeDeploymentRuntime.$$$reportNull$$$0(17);
            }
            callback.succeeded();
        })).exceptionally(e -> {
            if (callback == null) {
                ComposeDeploymentRuntime.$$$reportNull$$$0(16);
            }
            callback.errorOccurred(e.getMessage());
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliBuilder";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeFiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeProjectName";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeErasedProjectName";
                break;
            }
            case 4: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeHelper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCli";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainLoggingHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveComposeProjectName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeErasedProjectName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeCli";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getComposeFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeApplicationId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeWorkingDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateComposeFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$undeploy$10";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$undeploy$9";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getComposeFiles$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

