/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.ComposeExternalRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRuntimesCache {
    private final ServerTaskExecutor myTaskExecutor;
    private final AgentTaskExecutor myAgentTaskExecutor;
    private final DockerApplicationRuntime myContainersGroup;
    private final DockerApplicationRuntime myImagesGroup;
    private final Map<String, ComposeDeploymentRuntime> myComposeDeploymentRuntimes;
    private final Map<String, ComposeExternalRuntime> myExternalComposeApps;
    private final Map<String, DockerApplicationRuntime> myApplicationName2Runtime;
    private final Map<String, String> myContainerId2Name;

    public DockerRuntimesCache(@NotNull ServerTaskExecutor taskExecutor, @NotNull AgentTaskExecutor agentTaskExecutor) {
        if (taskExecutor == null) {
            DockerRuntimesCache.$$$reportNull$$$0(0);
        }
        if (agentTaskExecutor == null) {
            DockerRuntimesCache.$$$reportNull$$$0(1);
        }
        this.myComposeDeploymentRuntimes = new HashMap<String, ComposeDeploymentRuntime>();
        this.myExternalComposeApps = new HashMap<String, ComposeExternalRuntime>();
        this.myApplicationName2Runtime = new HashMap<String, DockerApplicationRuntime>();
        this.myContainerId2Name = new HashMap<String, String>();
        this.myTaskExecutor = taskExecutor;
        this.myAgentTaskExecutor = agentTaskExecutor;
        this.myContainersGroup = new DockerGroupRuntime.ContainersGroup(this.myTaskExecutor, this.myAgentTaskExecutor);
        this.myImagesGroup = new DockerGroupRuntime.ImagesGroup(this.myTaskExecutor, this.myAgentTaskExecutor);
    }

    @Deprecated
    @NotNull
    public DockerApplicationRuntime getImageNotContainerGroupRuntime(boolean imageNotContainer) {
        DockerApplicationRuntime dockerApplicationRuntime = imageNotContainer ? this.myImagesGroup : this.myContainersGroup;
        if (dockerApplicationRuntime == null) {
            DockerRuntimesCache.$$$reportNull$$$0(2);
        }
        return dockerApplicationRuntime;
    }

    @Deprecated
    @Nullable
    public String findContainerName(@Nullable String containerId) {
        return containerId == null ? null : this.myContainerId2Name.get(containerId);
    }

    @NotNull
    public List<CloudApplicationRuntime> refreshStructure(@NotNull DockerAgentApplication[] agentApps) {
        if (agentApps == null) {
            DockerRuntimesCache.$$$reportNull$$$0(3);
        }
        ArrayList<DockerApplicationRuntime> leafs = new ArrayList<DockerApplicationRuntime>(agentApps.length);
        for (DockerAgentApplication nextAgentApp : agentApps) {
            leafs.add(this.mapAgentApplication(nextAgentApp));
        }
        LinkedHashSet<DockerApplicationRuntime> parents = new LinkedHashSet<DockerApplicationRuntime>();
        parents.add(this.myContainersGroup);
        parents.add(this.myImagesGroup);
        for (DockerApplicationRuntime nextLeaf : leafs) {
            boolean unknownParent;
            CloudApplicationRuntime parent = nextLeaf.getParent();
            while (parent instanceof DockerApplicationRuntime && (unknownParent = parents.add((DockerApplicationRuntime)parent))) {
                parent = parent.getParent();
            }
        }
        ArrayList<CloudApplicationRuntime> result = new ArrayList<CloudApplicationRuntime>(leafs.size() + parents.size());
        result.addAll(parents);
        result.addAll(leafs);
        ArrayList<CloudApplicationRuntime> arrayList = result;
        if (arrayList == null) {
            DockerRuntimesCache.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Deprecated
    public void registerComposeDeployment(@NotNull String deploymentName, @NotNull ComposeDeploymentRuntime localComposeDeployment) {
        if (deploymentName == null) {
            DockerRuntimesCache.$$$reportNull$$$0(5);
        }
        if (localComposeDeployment == null) {
            DockerRuntimesCache.$$$reportNull$$$0(6);
        }
        this.myComposeDeploymentRuntimes.put(deploymentName, localComposeDeployment);
    }

    @NotNull
    private DockerApplicationRuntime mapAgentApplication(@NotNull DockerAgentApplication application) {
        DockerApplicationRuntime composeService;
        if (application == null) {
            DockerRuntimesCache.$$$reportNull$$$0(7);
        }
        this.myContainerId2Name.put(application.getContainerId(), application.getContainerName());
        DockerApplicationRuntime result = this.myApplicationName2Runtime.computeIfAbsent(application.getUniqueName(), this::newApplicationRuntime);
        result.setApplication(application);
        String containerId = application.getContainerId();
        DockerApplicationRuntime parent = containerId == null ? this.myImagesGroup : ((composeService = this.findComposeService(application)) == null ? this.myContainersGroup : composeService);
        result.setParent(parent);
        DockerApplicationRuntime dockerApplicationRuntime = result;
        if (dockerApplicationRuntime == null) {
            DockerRuntimesCache.$$$reportNull$$$0(8);
        }
        return dockerApplicationRuntime;
    }

    @Nullable
    private DockerApplicationRuntime findComposeService(@NotNull DockerAgentApplication agentApp) {
        Map containerLabels;
        if (agentApp == null) {
            DockerRuntimesCache.$$$reportNull$$$0(9);
        }
        if ((containerLabels = agentApp.getContainerLabels()) == null) {
            return null;
        }
        String composeService = (String)containerLabels.get("com.docker.compose.service");
        String composeProject = (String)containerLabels.get("com.docker.compose.project");
        if (composeProject == null || composeService == null) {
            return null;
        }
        ComposeApplicationRuntime composeRuntime = this.findOrCreateComposeApplicationRuntime(composeProject);
        return composeRuntime.findOrCreateService(composeService);
    }

    @NotNull
    private ComposeApplicationRuntime findOrCreateComposeApplicationRuntime(@NotNull String composeProject) {
        if (composeProject == null) {
            DockerRuntimesCache.$$$reportNull$$$0(10);
        }
        for (ComposeDeploymentRuntime next : this.myComposeDeploymentRuntimes.values()) {
            if (!next.mayHaveComposeProjectName(composeProject)) continue;
            ComposeDeploymentRuntime composeDeploymentRuntime = next;
            if (composeDeploymentRuntime == null) {
                DockerRuntimesCache.$$$reportNull$$$0(11);
            }
            return composeDeploymentRuntime;
        }
        ComposeApplicationRuntime composeApplicationRuntime = this.myExternalComposeApps.computeIfAbsent(composeProject, this::newComposeExternalApplicationRuntime);
        if (composeApplicationRuntime == null) {
            DockerRuntimesCache.$$$reportNull$$$0(12);
        }
        return composeApplicationRuntime;
    }

    @NotNull
    private DockerApplicationRuntime newApplicationRuntime(String applicationName) {
        DockerApplicationRuntime dockerApplicationRuntime = new DockerApplicationRuntime(this.myTaskExecutor, this.myAgentTaskExecutor, applicationName, null);
        if (dockerApplicationRuntime == null) {
            DockerRuntimesCache.$$$reportNull$$$0(13);
        }
        return dockerApplicationRuntime;
    }

    @NotNull
    private ComposeExternalRuntime newComposeExternalApplicationRuntime(String composeProject) {
        ComposeExternalRuntime composeExternalRuntime = new ComposeExternalRuntime(this.myTaskExecutor, this.myAgentTaskExecutor, composeProject);
        if (composeExternalRuntime == null) {
            DockerRuntimesCache.$$$reportNull$$$0(14);
        }
        return composeExternalRuntime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentTaskExecutor";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/DockerRuntimesCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentApps";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localComposeDeployment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentApp";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/DockerRuntimesCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageNotContainerGroupRuntime";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshStructure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mapAgentApplication";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateComposeApplicationRuntime";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newApplicationRuntime";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newComposeExternalApplicationRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshStructure";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerComposeDeployment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mapAgentApplication";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findComposeService";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateComposeApplicationRuntime";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

