/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.settings.DockerVolumeBindingConfigurable;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.Column;

public class DockerVolumeBindingsEditor
extends TableWithCardEditor<DockerVolumeBindingImpl, ColumnBase> {
    private final RemoteServer myServer;

    public DockerVolumeBindingsEditor(final RemoteServer server) {
        super((Column[])new ColumnBase[]{new ContainerPathColumn(), new HostPathColumn(){

            @Override
            public Object getColumnValue(DockerVolumeBindingImpl row) {
                return DockerVolumeBindingConfigurable.toLocalPath(server, row.getHostPath());
            }
        }, new ReadOnlyColumn()});
        this.myServer = server;
    }

    @Override
    protected DockerVolumeBindingImpl createItem() {
        return new DockerVolumeBindingImpl();
    }

    @Override
    protected DockerVolumeBindingImpl cloneItem(DockerVolumeBindingImpl item) {
        return new DockerVolumeBindingImpl((DockerVolumeBinding)item);
    }

    @Override
    protected Configurable createItemConfigurable(DockerVolumeBindingImpl item) {
        return new DockerVolumeBindingConfigurable(item, this.myServer);
    }

    @Override
    protected boolean isEditable(int row) {
        return ((DockerVolumeBindingImpl)this.getItems().get(row)).isEditable();
    }

    private static class ReadOnlyColumn
    extends ColumnBase {
        public ReadOnlyColumn() {
            super("Read only");
        }

        public Object getColumnValue(DockerVolumeBindingImpl row) {
            return row.isReadOnly();
        }

        public Class<?> getValueClass() {
            return Boolean.class;
        }

        public boolean needPack() {
            return true;
        }
    }

    private static class HostPathColumn
    extends ColumnBase {
        public HostPathColumn() {
            super("Host path");
        }

        public Object getColumnValue(DockerVolumeBindingImpl row) {
            return row.getHostPath();
        }
    }

    private static class ContainerPathColumn
    extends ColumnBase {
        public ContainerPathColumn() {
            super("Container path");
        }

        public Object getColumnValue(DockerVolumeBindingImpl row) {
            return row.getContainerPath();
        }
    }

    public static abstract class ColumnBase
    extends Column<DockerVolumeBindingImpl> {
        public ColumnBase(String name) {
            super(name);
        }
    }
}

