/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.stats;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDockerUsageCollector
extends AbstractProjectsUsagesCollector {

    protected static class Registrar {
        private final Map<String, DockerUsageDescriptor> myUsages = new HashMap<String, DockerUsageDescriptor>();

        public Set<UsageDescriptor> getCollectedResults() {
            return new HashSet<DockerUsageDescriptor>(this.myUsages.values()).stream().map(DockerUsageDescriptor::toUsageDescriptor).collect(Collectors.toSet());
        }

        public void advance(@NotNull String kind) {
            if (kind == null) {
                Registrar.$$$reportNull$$$0(0);
            }
            this.advance(kind, 1L);
        }

        public void registerByType(@NotNull String key, @NotNull Class<?> type, @NotNull List<?> list) {
            if (key == null) {
                Registrar.$$$reportNull$$$0(1);
            }
            if (type == null) {
                Registrar.$$$reportNull$$$0(2);
            }
            if (list == null) {
                Registrar.$$$reportNull$$$0(3);
            }
            this.advance(key, list.stream().filter(type::isInstance).count());
        }

        public <T> void advanceIfNotNull(@NotNull String key, @NotNull List<? extends T> list, Function<? super T, ?> getter) {
            if (key == null) {
                Registrar.$$$reportNull$$$0(4);
            }
            if (list == null) {
                Registrar.$$$reportNull$$$0(5);
            }
            this.advance(key, list.stream().map(getter).filter(Objects::nonNull).count());
        }

        public <T> void advanceIfNotEmpty(@NotNull String key, @NotNull List<? extends T> list, Function<? super T, String> getter) {
            if (key == null) {
                Registrar.$$$reportNull$$$0(6);
            }
            if (list == null) {
                Registrar.$$$reportNull$$$0(7);
            }
            this.advance(key, list.stream().map(getter).filter(s -> !StringUtil.isEmpty((String)s)).count());
        }

        public void advance(@NotNull String kind, long value) {
            if (kind == null) {
                Registrar.$$$reportNull$$$0(8);
            }
            assert (value < Integer.MAX_VALUE) : "wow?: " + kind + " += " + value;
            DockerUsageDescriptor descriptor = this.myUsages.computeIfAbsent(kind, id -> new DockerUsageDescriptor((String)id, 0));
            descriptor.setValue(descriptor.myValue + (int)value);
        }

        public void histogram(@NotNull String kind, int value, int ... thresholds) {
            if (kind == null) {
                Registrar.$$$reportNull$$$0(9);
            }
            if (thresholds.length > 0) {
                this.advance(kind + "." + Registrar.describeBin(value, thresholds));
            }
            this.advance(kind, value);
        }

        public static String describeBin(int value, int ... thresholds) {
            assert (thresholds.length > 0);
            for (int i = 0; i < thresholds.length; ++i) {
                int nextThreshold = thresholds[i];
                if (value > nextThreshold) continue;
                if (i == 0) {
                    return Registrar.describeOneBin(-1, thresholds[0]);
                }
                return Registrar.describeOneBin(thresholds[i - 1], thresholds[i]);
            }
            return thresholds[thresholds.length - 1] + "+";
        }

        private static String describeOneBin(int leftExclusive, int right) {
            int left = leftExclusive + 1;
            return left == right ? String.valueOf(left) : left + "-" + right;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/stats/AbstractDockerUsageCollector$Registrar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "advance";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerByType";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "advanceIfNotNull";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "advanceIfNotEmpty";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "histogram";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DockerUsageDescriptor {
        protected final String myKey;
        protected int myValue;

        public DockerUsageDescriptor(@NotNull String key, int value) {
            if (key == null) {
                DockerUsageDescriptor.$$$reportNull$$$0(0);
            }
            this.myKey = ConvertUsagesUtil.ensureProperKey((String)key);
            this.myValue = value;
        }

        public String getKey() {
            return this.myKey;
        }

        public int getValue() {
            return this.myValue;
        }

        public void setValue(int value) {
            this.myValue = value;
        }

        public UsageDescriptor toUsageDescriptor() {
            return new UsageDescriptor(this.myKey, this.myValue);
        }

        public String toString() {
            return this.myKey + " -> " + this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/docker/stats/AbstractDockerUsageCollector$DockerUsageDescriptor", "<init>"));
        }
    }
}

