/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.codeInsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.javascript.trace.debugger.ExpressionEvaluator;
import com.intellij.javascript.trace.debugger.TraceSessionEvaluator;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.PropertyMetadata;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.ProcessingContext;
import com.intellij.util.concurrency.Semaphore;
import icons.SpyJSIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class TraceCompletionContributor
extends CompletionContributor {
    private static final PsiElementPattern.Capture<PsiElement> PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{".", "["});
    private final Map<String, Icon> myIcons = new HashMap<String, Icon>();
    private static final Logger LOG = Logger.getInstance(TraceCompletionContributor.class);
    private static final CompletionSorter SORTER = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new DispreferLiveTemplates()).weigh(new LookupElementWeigher("priority"){

        @NotNull
        public Double weigh(@NotNull LookupElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            Double d = -JSCompletionUtil.getLookupElementPriority((LookupElement)element);
            if (d == null) {
                1.$$$reportNull$$$0(1);
            }
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/trace/codeInsight/TraceCompletionContributor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/trace/codeInsight/TraceCompletionContributor$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }).weigh((LookupElementWeigher)new PreferStartMatching()).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher());
    private static final InsertHandler<LookupElement> FUNCTION_NO_PARAMS_INSERT_HANDLER = new MyInsertHandler(false);
    private static final InsertHandler<LookupElement> FUNCTION_INSERT_HANDLER = new MyInsertHandler(true);

    public TraceCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                Project project;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((project = parameters.getEditor().getProject()) == null || project.isDisposed()) {
                    return;
                }
                PsiFile file = parameters.getOriginalFile();
                TraceSessionEvaluator evaluator = ExpressionEvaluator.getRemoteEvaluator(project, file);
                if (evaluator == null || !evaluator.isReadyToEvaluate()) {
                    return;
                }
                PsiElement position = parameters.getOriginalPosition();
                if (position == null) {
                    return;
                }
                Expression expression = TraceCompletionContributor.getExpression(parameters.getPosition());
                if (!expression.shouldEvaluate()) {
                    return;
                }
                Promise<ExpressionEvaluationResult> resultFuture = evaluator.evaluateExpression(ExpressionEvaluationRequest.createAutocompletePropertiesRequest(position, expression.getText(), !expression.isBracket()));
                HashMap results = new HashMap();
                CompletionResultSet sortedResult = result.withRelevanceSorter(SORTER);
                sortedResult.runRemainingContributors(parameters, result12 -> {
                    LookupElement lookupElement = result12.getLookupElement();
                    String lookupString = lookupElement.getLookupString();
                    ArrayList<LookupElement> elements = (ArrayList<LookupElement>)results.get(lookupString);
                    if (elements == null) {
                        elements = new ArrayList<LookupElement>();
                        results.put(lookupString, elements);
                    }
                    elements.add(lookupElement);
                }, true);
                Semaphore semaphore = new Semaphore();
                Ref evalResultRef = Ref.create();
                semaphore.down();
                resultFuture.onSuccess(result1 -> {
                    evalResultRef.set(result1);
                    semaphore.up();
                }).onError(error -> {
                    semaphore.up();
                    LOG.warn(error);
                });
                try {
                    semaphore.waitForUnsafe();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                ExpressionEvaluationResult evalResult = (ExpressionEvaluationResult)evalResultRef.get();
                if (evalResult == null) {
                    return;
                }
                if (evalResult.isFileNotFound()) {
                    evaluator.cache(evalResult);
                    LOG.info("Remote expression evaluator didn't find matching trace file with the same number of functions as in source file");
                }
                for (PropertyMetadata prop : evalResult.getProperties()) {
                    String propName = prop.getNormalizedName();
                    boolean isCallableFunction = prop.getParams() != null;
                    List duplicates = (List)results.remove(propName);
                    PsiElement singleDuplicate = duplicates != null && duplicates.size() == 1 ? ((LookupElement)duplicates.get(0)).getPsiElement() : null;
                    Couple existingTailAndType = TraceCompletionContributor.getTailAndType(duplicates);
                    String tailText = !isCallableFunction ? "" : TraceCompletionContributor.mergeTailText("(" + prop.getParams() + ")", (String)existingTailAndType.first);
                    String propType = prop.getType();
                    if (propType.equals("Null") || propType.equals("Undefined") || propType.equals("Function") && isCallableFunction) {
                        propType = "";
                    }
                    String typeText = TraceCompletionContributor.mergeTypeText(propType, (String)existingTailAndType.second);
                    boolean hasParams = !StringUtil.isEmpty((String)tailText) && tailText.length() > 2;
                    LookupElementBuilder element = (singleDuplicate != null ? LookupElementBuilder.create((Object)singleDuplicate, (String)propName) : LookupElementBuilder.create((String)propName)).withBoldness(true).withTailText(tailText).withTypeText(typeText).withIcon(TraceCompletionContributor.this.getIcon(prop, evaluator));
                    if (isCallableFunction) {
                        element = element.withInsertHandler(hasParams ? FUNCTION_INSERT_HANDLER : FUNCTION_NO_PARAMS_INSERT_HANDLER);
                    }
                    sortedResult.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)200.0));
                }
                for (List elements : results.values()) {
                    sortedResult.addAllElements((Iterable)elements);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/trace/codeInsight/TraceCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static Expression getExpression(PsiElement position) {
        int index;
        PsiElement element = PsiTreeUtil.prevLeaf((PsiElement)position);
        if (element == null) {
            return Expression.nonEvaluatable();
        }
        if (position.getParent() == null || position.getParent().getParent() == null) {
            return Expression.nonEvaluatable();
        }
        boolean isBracket = element.getText().equals("[");
        String parent = isBracket ? position.getParent().getParent().getText() : position.getParent().getText();
        int n = index = isBracket ? Math.max(parent.lastIndexOf("['"), parent.lastIndexOf("[\"")) : parent.lastIndexOf(".");
        if (index > 0) {
            return new Expression(parent.substring(0, index), isBracket);
        }
        return Expression.nonEvaluatable();
    }

    private static Couple<String> getTailAndType(List<LookupElement> elements) {
        String existingTailText = "";
        String existingTypeText = "";
        if (elements != null) {
            for (LookupElement element : elements) {
                LookupElementPresentation presentation = new LookupElementPresentation();
                element.renderElement(presentation);
                String elementTailText = StringUtil.notNullize((String)presentation.getTailText()).replace("(exports)", "");
                String elementTypeText = StringUtil.notNullize((String)presentation.getTypeText()).replace(JSBundle.message((String)"javascript.completion.several.definitions", (Object[])new Object[0]), "");
                existingTailText = StringUtil.isEmpty((String)elementTailText) ? existingTailText : elementTailText;
                existingTypeText = StringUtil.isEmpty((String)elementTypeText) ? existingTypeText : elementTypeText;
            }
        }
        return new Couple((Object)existingTailText, (Object)existingTypeText);
    }

    private static String mergeTypeText(String typeText, String existingTypeText) {
        return StringUtil.nullize((String)(existingTypeText.length() > 0 ? existingTypeText : typeText));
    }

    private static String mergeTailText(String tailText, String existingTailText) {
        int indexOfClosePar = existingTailText.indexOf(")");
        String existingParams = indexOfClosePar > 0 ? existingTailText.substring(0, indexOfClosePar + 1) : "";
        return StringUtil.nullize((String)(existingParams.contains("[") || existingParams.split(",").length > tailText.split(",").length ? existingParams : tailText));
    }

    private Icon getIcon(PropertyMetadata property, TraceSessionEvaluator evaluator) {
        Icon icon = SpyJSIcons.Spy_js;
        if (property.getContext().length == 1) {
            ContextMetadata contextMetadata = evaluator.getContextMetadata(property.getContext()[0]);
            String agent = contextMetadata.getAgent();
            Icon cachedIcon = this.myIcons.get(agent);
            if (cachedIcon == null) {
                RowIcon newIcon = new RowIcon(2);
                newIcon.setIcon(SpyJSIcons.Spy_js, 0);
                newIcon.setIcon(Utils.isNodeJsAgent(agent) ? SpyJSIcons.Nodejs_16 : Utils.getAgentIcon(agent), 1);
                cachedIcon = newIcon;
                this.myIcons.put(agent, cachedIcon);
            }
            icon = cachedIcon;
        }
        return icon;
    }

    private static class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private final int myOffset;

        private MyInsertHandler(boolean hasParameters) {
            this.myOffset = hasParameters ? 1 : 2;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            CaretModel caretModel = context.getEditor().getCaretModel();
            int offset = caretModel.getOffset();
            context.getEditor().getDocument().insertString(offset, (CharSequence)"()");
            caretModel.moveToOffset(offset + this.myOffset);
        }
    }

    private static class Expression {
        private final String myExpression;
        private final boolean myIsBracket;

        private Expression(String expression, boolean isBracket) {
            this.myExpression = expression;
            this.myIsBracket = isBracket;
        }

        private static Expression nonEvaluatable() {
            return new Expression(null, false);
        }

        public String getText() {
            return this.myExpression;
        }

        public boolean isBracket() {
            return this.myIsBracket;
        }

        public boolean shouldEvaluate() {
            return !StringUtil.isEmpty((String)this.myExpression);
        }
    }
}

