/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.CompatibilityAwareRunProfile;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.ide.browsers.BrowserStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceBrowserRunConfigurationEditor;
import com.intellij.javascript.trace.execution.TraceBrowserRunConfigurationSettings;
import com.intellij.javascript.trace.execution.TraceBrowserSettingsSerializationUtil;
import com.intellij.javascript.trace.execution.TraceProfileState;
import com.intellij.javascript.trace.execution.TraceRunConfiguration;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.systemProxy.ProxyConfigurator;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class TraceBrowserConfiguration
extends TraceRunConfiguration
implements RunConfigurationWithSuppressedDefaultRunAction,
RefactoringListenerProvider,
CompatibilityAwareRunProfile {
    public static final int DEFAULT_TRACE_SERVER_PORT = 3546;
    private TraceBrowserRunConfigurationSettings mySettings;
    private VirtualFile myConfigFile;

    public TraceBrowserConfiguration(Project project, @NotNull ConfigurationFactory factory, String name) {
        if (factory == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
        this.mySettings = new TraceBrowserRunConfigurationSettings(3546, false, true, "", NodeJsInterpreterRef.createProjectRef(), false, null, null);
    }

    @Override
    @NotNull
    public JSONObject getConfigJson() {
        boolean hasConfigurationFile = this.mySettings.hasConfig();
        String config = hasConfigurationFile ? this.mySettings.getConfigPath() : this.mySettings.getUrl();
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!hasConfigurationFile) {
            config = config.replace("\\", "/");
        }
        values.put(hasConfigurationFile ? "path" : "url", config);
        if (this.mySettings.getTraceLimits() != null) {
            this.mySettings.getTraceLimits().addToConfigJson(values);
        }
        JSONObject jSONObject = new JSONObject(values);
        if (jSONObject == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(1);
        }
        return jSONObject;
    }

    @Override
    @NotNull
    public GeneralCommandLine createCommandLine() throws ExecutionException {
        NodeJsInterpreter interpreter = this.mySettings.getNodeInterpreterRef().resolveNotNull(this.getProject());
        int serverPort = this.mySettings.getProxyPort();
        int debugPort = StringUtil.parseInt((String)System.getenv("DEBUG_SPY_JS"), (int)-1);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)interpreter, (boolean)false);
        commandLine.addParameter(Utils.getServerScriptPath("spy.js", debugPort <= 0));
        commandLine.addParameter("--port=" + serverPort);
        NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    @Override
    @Nullable
    public VirtualFile getConfigFile() {
        if (this.mySettings.hasConfig() && this.myConfigFile == null) {
            this.myConfigFile = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getConfigPath()), (boolean)false);
        }
        return this.myConfigFile;
    }

    @Override
    public void configurationStarted(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(3);
        }
        UsageTrigger.trigger((String)"spy.js.browser.rc.start");
        if (this.mySettings.isSystemProxyUsed()) {
            ProxyConfigurator.getInstance().requestStart(this.mySettings.getProxyPort());
        }
        if (this.mySettings.needToOpenBrowser() && !this.mySettings.hasConfig() && !StringUtil.isEmpty((String)this.mySettings.getUrl())) {
            String browserId = this.mySettings.getBrowserId();
            StartBrowserSettings settings = new StartBrowserSettings();
            settings.setSelected(true);
            settings.setUrl(this.mySettings.getUrl());
            settings.setBrowser(StringUtil.isEmpty((String)browserId) ? WebBrowserManager.getInstance().getFirstActiveBrowser() : WebBrowserManager.getInstance().findBrowserById(browserId));
            settings.setStartJavaScriptDebugger(false);
            new BrowserStarter((RunConfiguration)this, settings, processHandler).start();
        }
    }

    @Override
    public void configurationStopped() {
        if (this.mySettings.isSystemProxyUsed()) {
            ProxyConfigurator.getInstance().requestStop(this.mySettings.getProxyPort());
        }
    }

    @Override
    public int getProxyPort() {
        return this.mySettings.getProxyPort();
    }

    @NotNull
    public TraceBrowserRunConfigurationSettings getTraceSettings() {
        TraceBrowserRunConfigurationSettings traceBrowserRunConfigurationSettings = this.mySettings;
        if (traceBrowserRunConfigurationSettings == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(4);
        }
        return traceBrowserRunConfigurationSettings;
    }

    public void setTraceSettings(@NotNull TraceBrowserRunConfigurationSettings settings) {
        if (settings == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(5);
        }
        this.mySettings = settings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        TraceBrowserRunConfigurationEditor traceBrowserRunConfigurationEditor = new TraceBrowserRunConfigurationEditor(this.getProject());
        if (traceBrowserRunConfigurationEditor == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(6);
        }
        return traceBrowserRunConfigurationEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)this.mySettings.getNodeInterpreterRef().resolve(this.getProject()));
        if (this.mySettings.hasConfig()) {
            String configPath = this.mySettings.getConfigPath();
            if (configPath.trim().isEmpty()) {
                throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.emptyConfigPath", new Object[0]));
            }
            File config = new File(configPath);
            if (!config.isFile() || !config.exists()) {
                throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.incorrectConfigPath", new Object[0]));
            }
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(7);
        }
        if (env == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(8);
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return new TraceProfileState(this.getProject(), env);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(9);
        }
        super.readExternal(element);
        this.setTraceSettings(TraceBrowserSettingsSerializationUtil.readFromXml(element));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(10);
        }
        super.writeExternal(element);
        TraceBrowserSettingsSerializationUtil.writeToXml(element, this.getTraceSettings());
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (!this.mySettings.hasConfig()) {
            return null;
        }
        VirtualFile file = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        String configPath = FileUtil.toSystemIndependentName((String)this.mySettings.getConfigPath());
        if (configPath.equals(path)) {
            return new UndoRefactoringElementAdapter(){

                protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                    VirtualFile newFile;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((newFile = PsiUtilBase.asVirtualFile((PsiElement)element)) != null) {
                        String newPath = FileUtil.toSystemDependentName((String)newFile.getPath());
                        TraceBrowserConfiguration.this.setTraceSettings(new TraceBrowserRunConfigurationSettings(TraceBrowserConfiguration.this.mySettings.getProxyPort(), true, TraceBrowserConfiguration.this.mySettings.isSystemProxyUsed(), newPath, TraceBrowserConfiguration.this.mySettings.getNodeInterpreterRef(), TraceBrowserConfiguration.this.mySettings.needToOpenBrowser(), TraceBrowserConfiguration.this.mySettings.getBrowserId(), TraceBrowserConfiguration.this.mySettings.getTraceLimits()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration$1", "refactored"));
                }
            };
        }
        return null;
    }

    public boolean mustBeStoppedToRun(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            TraceBrowserConfiguration.$$$reportNull$$$0(11);
        }
        return configuration instanceof JavaScriptDebugConfiguration && this.mySettings.isSystemProxyUsed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/TraceBrowserConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/TraceBrowserConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigJson";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configurationStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTraceSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mustBeStoppedToRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

