/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceLoadedHandler;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import icons.SpyJSIcons;
import org.jetbrains.annotations.NotNull;

public class LoadTraceAction
extends AnAction {
    private final TraceSession mySession;
    private final Runnable myLoaded;

    public LoadTraceAction(@NotNull TraceSession session, @NotNull Runnable loaded) {
        if (session == null) {
            LoadTraceAction.$$$reportNull$$$0(0);
        }
        if (loaded == null) {
            LoadTraceAction.$$$reportNull$$$0(1);
        }
        super(TraceBundle.message("console.trace.toolbar.loadTrace", new Object[0]), TraceBundle.message("console.trace.toolbar.loadTrace", new Object[0]), SpyJSIcons.LoadTrace);
        this.mySession = session;
        this.myLoaded = loaded;
    }

    public void update(AnActionEvent e) {
        if (!this.mySession.isRunning()) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FileChooserDialog chooser;
        VirtualFile[] files;
        if (e == null) {
            LoadTraceAction.$$$reportNull$$$0(2);
        }
        if ((files = (chooser = FileChooserFactory.getInstance().createFileChooser(new FileChooserDescriptor(true, false, true, false, false, false).withTitle(TraceBundle.message("console.trace.toolbar.loadTrace.fileChooser.title", new Object[0])), null, null)).choose(null, new VirtualFile[0])).length == 1) {
            final Semaphore semaphore = new Semaphore();
            final TraceLoadedHandler loaded = new TraceLoadedHandler(){

                @Override
                public void traceLoaded(@NotNull String traceId) {
                    if (traceId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        LoadTraceAction.this.myLoaded.run();
                    }
                    finally {
                        semaphore.up();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceId", "com/intellij/javascript/trace/execution/actions/LoadTraceAction$1", "traceLoaded"));
                }
            };
            semaphore.down();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(LoadTraceAction.getEventProject((AnActionEvent)e), TraceBundle.message("console.trace.toolbar.loading", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    LoadTraceAction.this.mySession.loadTrace(StringUtil.trimEnd((String)files[0].getPath(), (String)"!/"), loaded);
                    semaphore.waitFor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/trace/execution/actions/LoadTraceAction$2", "run"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaded";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/actions/LoadTraceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

