/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.events.EventMessageNode;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.javascript.trace.execution.events.NodeWithRemovableChildren;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventRootNode
extends EventTreeNode
implements NodeWithRemovableChildren {
    private final List<EventStreamNode> myChildren = new ArrayList<EventStreamNode>();
    private final SimpleNode[] NO_EVENTS = new SimpleNode[]{new EventMessageNode(this, TraceBundle.message("console.trace.events.noEventsCaptured", new Object[0]))};
    private final Map<String, EventStreamNode> myContextMap = new HashMap<String, EventStreamNode>();
    private final Map<String, ContextMetadata> myContextDetailsMap = new HashMap<String, ContextMetadata>();
    private final HashSet<String> myRemovedNodes = new HashSet();
    private final List<Consumer<EventTreeNode>> myCappedHandlers = new ArrayList<Consumer<EventTreeNode>>();

    public EventRootNode() {
        super(null);
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    @Override
    public SimpleNode[] getChildren() {
        if (this.myChildren.isEmpty()) {
            return this.NO_EVENTS;
        }
        return this.myChildren.toArray(new EventStreamNode[0]);
    }

    public boolean addOrUpdateEvent(@NotNull EventMetadataExtended eventData, @NotNull TraceProjectSettings.EventFilterState activeFilter) {
        String streamId;
        if (eventData == null) {
            EventRootNode.$$$reportNull$$$0(0);
        }
        if (activeFilter == null) {
            EventRootNode.$$$reportNull$$$0(1);
        }
        if (this.myRemovedNodes.contains(streamId = eventData.getStreamId())) {
            return false;
        }
        EventStreamNode streamNode = this.getOrCreateEventStream(streamId);
        return streamNode.addOrUpdateEvent(eventData, activeFilter);
    }

    public EventStreamNode getEventStream(String streamId) {
        return this.myContextMap.get(streamId);
    }

    public void addEventStream(ContextMetadata context) {
        if (this.myRemovedNodes.contains(context.getId())) {
            return;
        }
        this.myContextDetailsMap.put(context.getId(), context);
        this.getOrCreateEventStream(context.getId());
    }

    private EventStreamNode getOrCreateEventStream(String streamId) {
        ContextMetadata details;
        EventStreamNode node = this.myContextMap.get(streamId);
        if (node == null) {
            node = new EventStreamNode(this, streamId);
            this.myContextMap.put(streamId, node);
            this.myChildren.add(0, node);
            for (Consumer<EventTreeNode> handler : this.myCappedHandlers) {
                node.addCappedHandler(handler);
            }
        }
        if ((details = this.myContextDetailsMap.get(streamId)) != null) {
            node.setContextData(details.getDocument(), details.getAgent(), details.getReferrer());
        }
        return node;
    }

    public void addCappedHandler(Consumer<EventTreeNode> onBeforeCapped) {
        this.myCappedHandlers.add(onBeforeCapped);
    }

    @Override
    public void removeChild(EventTreeNode nodeToRemove) {
        if (!(nodeToRemove instanceof EventStreamNode)) {
            return;
        }
        EventStreamNode streamNode = (EventStreamNode)nodeToRemove;
        this.removeStreamNode(streamNode);
    }

    private void removeStreamNode(EventStreamNode streamNode) {
        this.myChildren.remove(streamNode);
        this.myContextMap.remove(streamNode.getStreamId());
        this.myRemovedNodes.add(streamNode.getStreamId());
    }

    public EventStreamNode eventStreamInterrupted(String id) {
        if (this.myRemovedNodes.contains(id)) {
            return null;
        }
        EventStreamNode node = this.getOrCreateEventStream(id);
        node.interrupted();
        return node;
    }

    public void eventStreamExpired(String streamId) {
        EventStreamNode node = this.getEventStream(streamId);
        if (node != null) {
            node.expired();
        }
    }

    public void eventStreamActivated(String streamId) {
        EventStreamNode node = this.getEventStream(streamId);
        if (node != null && node.isExpired()) {
            node.activated();
        }
    }

    public void clearRemovedElementsCache() {
        this.myRemovedNodes.clear();
    }

    @NotNull
    public EventNode[] getAllEventNodesOrderedByOccurenceTimeDesc() {
        ArrayList eventNodes = new ArrayList();
        for (EventStreamNode streamNode : this.myChildren) {
            Collections.addAll(eventNodes, streamNode.getAllEventNodesOrderedByOccurenceTimeDesc());
        }
        EventNode[] eventNodeArray = eventNodes.toArray(new EventNode[0]);
        if (eventNodeArray == null) {
            EventRootNode.$$$reportNull$$$0(2);
        }
        return eventNodeArray;
    }

    @Nullable
    public EventNode getEventNodeByEventId(@NotNull String streamId, long eventId) {
        EventStreamNode streamNode;
        if (streamId == null) {
            EventRootNode.$$$reportNull$$$0(3);
        }
        if ((streamNode = this.myContextMap.get(streamId)) == null) {
            return null;
        }
        return streamNode.getEventNodeByEventId(eventId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/events/EventRootNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/events/EventRootNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEventNodesOrderedByOccurenceTimeDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateEvent";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEventNodeByEventId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

