/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.session;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.javascript.trace.execution.TraceNodeConfiguration;
import com.intellij.javascript.trace.execution.TraceRunConfiguration;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticInReturn;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.EventDataReceivedHandler;
import com.intellij.javascript.trace.execution.common.EventDataReceivingHandler;
import com.intellij.javascript.trace.execution.common.EventMetadata;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.common.EventMetadataReceivedHandler;
import com.intellij.javascript.trace.execution.common.EventStreamChangeType;
import com.intellij.javascript.trace.execution.common.EventStreamChangedHandler;
import com.intellij.javascript.trace.execution.common.EventStreamCommand;
import com.intellij.javascript.trace.execution.common.FileLoadedHandler;
import com.intellij.javascript.trace.execution.common.MappedSourceFile;
import com.intellij.javascript.trace.execution.common.MappedTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.NewEventStreamHandler;
import com.intellij.javascript.trace.execution.common.OriginalTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.SourceFile;
import com.intellij.javascript.trace.execution.common.StackEntryBase;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceLoadedHandler;
import com.intellij.javascript.trace.execution.common.TraceSavedHandler;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraph;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyRequest;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyVirtualFile;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.search.TraceSearchRequest;
import com.intellij.javascript.trace.execution.search.TraceSearchResult;
import com.intellij.javascript.trace.execution.session.JsonSerialization;
import com.intellij.javascript.trace.execution.session.StaticCodeElementParser;
import com.intellij.javascript.trace.execution.session.TraceSessionCache;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import io.socket.IOAcknowledge;
import io.socket.IOCallback;
import io.socket.SocketIO;
import io.socket.SocketIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TraceSessionImpl
implements TraceSession,
Disposable {
    private final ProcessHandler myProcessHandler;
    private final FileUrlMapper[] fileUrlMappers;
    private final MyBackendConnection myBackendConnection;
    private final TraceRunConfiguration myConfiguration;
    private final Project myProject;
    private final VirtualFile myConfigFile;
    private final List<Consumer<Exception>> myErrorHandlers = new ArrayList<Consumer<Exception>>();
    private final List<Consumer<VirtualFile>> myTraceFileChangedHandlers = new ArrayList<Consumer<VirtualFile>>();
    private final List<TraceLoadedHandler> myTraceLoadedHandlers = new ArrayList<TraceLoadedHandler>();
    private final TraceSessionCache myCache = new TraceSessionCache();
    private static final String SERVER_STARTED = "spy-js has started";
    private static final Logger LOG = Logger.getInstance(TraceSessionImpl.class);
    private final List<Runnable> mySessionStoppedHandlers = new ArrayList<Runnable>();
    private TraceSettings myConfig;
    private boolean myIsLoaded;

    public TraceSessionImpl(TraceRunConfiguration configuration, Project project) throws ExecutionException {
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myProcessHandler = this.createTraceServerProcess();
        this.myBackendConnection = new MyBackendConnection(configuration.getConfigJson());
        this.myConfigFile = this.myConfiguration.getConfigFile();
        this.myConfiguration.configurationStarted(this.myProcessHandler);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((text = event.getText()) != null && text.contains(TraceSessionImpl.SERVER_STARTED)) {
                    TraceSessionImpl.this.reconnect();
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                TraceSessionImpl.this.closeConnection();
                TraceSessionImpl.this.myConfiguration.configurationStopped();
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (Runnable handler : TraceSessionImpl.this.mySessionStoppedHandlers) {
                        handler.run();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/trace/execution/session/TraceSessionImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.handleAnyFileChange((VirtualFileEvent)event, false);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.handleAnyFileChange(event, true);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.handleAnyFileChange(event, false);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                this.handleAnyFileChange((VirtualFileEvent)event, false);
            }

            private void handleAnyFileChange(VirtualFileEvent event, boolean contentsChanged) {
                if (!TraceSessionImpl.this.myBackendConnection.isOpen()) {
                    return;
                }
                if (TraceSessionImpl.this.myConfigFile != null && TraceSessionImpl.this.myConfigFile.equals(event.getFile())) {
                    TraceSessionImpl.this.myBackendConnection.updateConfigFile(event.getFile().isValid() ? event.getFile().getPath() : null, contentsChanged);
                } else {
                    String remoteUrl = TraceSessionImpl.this.myCache.getRemoteUrlByLocalUrl(event.getFile().getUrl());
                    if (remoteUrl == null) {
                        return;
                    }
                    TraceSessionImpl.this.myBackendConnection.clearFileCache(remoteUrl);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/javascript/trace/execution/session/TraceSessionImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        FileUrlMapper[] extensions = (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions();
        this.fileUrlMappers = extensions.length == 0 ? null : extensions;
    }

    @Override
    public void reconnect() {
        try {
            this.closeConnection();
            this.openConnection();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public TraceVirtualFile[] getLoadedTracedSourceFiles(@NotNull String streamId) {
        if (streamId == null) {
            TraceSessionImpl.$$$reportNull$$$0(0);
        }
        return this.myCache.getTraceVirtualFilesStreamId(streamId);
    }

    @Override
    public ContextMetadata getContextMetadata(@NotNull String id) {
        if (id == null) {
            TraceSessionImpl.$$$reportNull$$$0(1);
        }
        return this.myCache.getContextMetadataById(id);
    }

    @Override
    public String getRemoteTracedFile(@NotNull VirtualFile file) {
        if (file == null) {
            TraceSessionImpl.$$$reportNull$$$0(2);
        }
        return this.myCache.getRemoteUrlByLocalUrl(file.getUrl());
    }

    private void openConnection() {
        this.myBackendConnection.open();
    }

    private void closeConnection() {
        if (this.myBackendConnection != null) {
            this.myBackendConnection.close();
        }
    }

    private void disposeConnection() {
        if (this.myBackendConnection != null) {
            Disposer.dispose((Disposable)this.myBackendConnection);
        }
    }

    @NotNull
    private ProcessHandler createTraceServerProcess() throws ExecutionException {
        GeneralCommandLine commandLine = this.myConfiguration.createCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        processHandler.setShouldDestroyProcessRecursively(true);
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            TraceSessionImpl.$$$reportNull$$$0(3);
        }
        return killableColoredProcessHandler;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    public void applySettings(@NotNull TraceSettings config) {
        if (config == null) {
            TraceSessionImpl.$$$reportNull$$$0(4);
        }
        this.myConfig = config;
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> connection.applyConfig(this.myConfig)));
    }

    @Override
    public TraceSettings getSettings() {
        return this.myConfig;
    }

    @Override
    public void executeInBrowser(@NotNull EventStreamCommand command) {
        if (command == null) {
            TraceSessionImpl.$$$reportNull$$$0(5);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (command == null) {
                TraceSessionImpl.$$$reportNull$$$0(47);
            }
            connection.executeInBrowser(command);
        }));
    }

    @Override
    public void evaluateExpression(@NotNull ExpressionEvaluationRequest request, @NotNull Consumer<ExpressionEvaluationResult> evaluationResultConsumer) {
        if (request == null) {
            TraceSessionImpl.$$$reportNull$$$0(6);
        }
        if (evaluationResultConsumer == null) {
            TraceSessionImpl.$$$reportNull$$$0(7);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (request == null) {
                TraceSessionImpl.$$$reportNull$$$0(45);
            }
            if (evaluationResultConsumer == null) {
                TraceSessionImpl.$$$reportNull$$$0(46);
            }
            ((MyBackendConnection)connection).evaluateExpression(request, (Consumer<ExpressionEvaluationResult>)evaluationResultConsumer);
        }));
    }

    @Override
    public void searchFunction(@NotNull TraceSearchRequest request, @NotNull Consumer<TraceSearchResult> searchResultConsumer) {
        if (request == null) {
            TraceSessionImpl.$$$reportNull$$$0(8);
        }
        if (searchResultConsumer == null) {
            TraceSessionImpl.$$$reportNull$$$0(9);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (request == null) {
                TraceSessionImpl.$$$reportNull$$$0(43);
            }
            if (searchResultConsumer == null) {
                TraceSessionImpl.$$$reportNull$$$0(44);
            }
            connection.searchFunction(request, searchResultConsumer);
        }));
    }

    @Override
    public void getFileDependencyVirtualFile(@NotNull FileDependencyRequest request, @NotNull Consumer<FileDependencyVirtualFile> fileDependencyGraphConsumer) {
        FileDependencyVirtualFile dependencyVirtualFile;
        if (request == null) {
            TraceSessionImpl.$$$reportNull$$$0(10);
        }
        if (fileDependencyGraphConsumer == null) {
            TraceSessionImpl.$$$reportNull$$$0(11);
        }
        if ((dependencyVirtualFile = this.myCache.getFileDependencyVirtualFile(request)) != null && dependencyVirtualFile.isUpToDate()) {
            fileDependencyGraphConsumer.consume((Object)dependencyVirtualFile);
            return;
        }
        if (dependencyVirtualFile != null) {
            request.setFileToUpdate(dependencyVirtualFile);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (request == null) {
                TraceSessionImpl.$$$reportNull$$$0(41);
            }
            if (fileDependencyGraphConsumer == null) {
                TraceSessionImpl.$$$reportNull$$$0(42);
            }
            connection.getFileDependencyGraph(request, fileDependencyGraphConsumer);
        }));
    }

    @Override
    public void saveTrace(@NotNull TraceSavedHandler onTraceSaved) {
        if (onTraceSaved == null) {
            TraceSessionImpl.$$$reportNull$$$0(12);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (onTraceSaved == null) {
                TraceSessionImpl.$$$reportNull$$$0(40);
            }
            connection.saveTrace(onTraceSaved);
        }));
    }

    @Override
    public void loadTrace(@NotNull String trace, @NotNull TraceLoadedHandler onTraceLoaded) {
        if (trace == null) {
            TraceSessionImpl.$$$reportNull$$$0(13);
        }
        if (onTraceLoaded == null) {
            TraceSessionImpl.$$$reportNull$$$0(14);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (trace == null) {
                TraceSessionImpl.$$$reportNull$$$0(37);
            }
            if (onTraceLoaded == null) {
                TraceSessionImpl.$$$reportNull$$$0(38);
            }
            connection.loadTrace(trace, traceId -> {
                if (onTraceLoaded == null) {
                    TraceSessionImpl.$$$reportNull$$$0(39);
                }
                this.myIsLoaded = true;
                this.myCache.clear();
                onTraceLoaded.traceLoaded(traceId);
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (TraceLoadedHandler handler : this.myTraceLoadedHandlers) {
                        handler.traceLoaded(traceId);
                    }
                });
            });
        }));
    }

    @Override
    public boolean isLoaded() {
        return this.myIsLoaded;
    }

    @Override
    @Nullable
    public StaticCodeElement getCodeElementById(@NotNull String id) {
        if (id == null) {
            TraceSessionImpl.$$$reportNull$$$0(15);
        }
        return this.myCache.getCodeElementById(id);
    }

    private void runOnConnection(Consumer<MyBackendConnection> delegate) {
        if (this.myBackendConnection != null) {
            try {
                delegate.consume((Object)this.myBackendConnection);
            }
            catch (Exception e) {
                this.handleConnectionError(e);
            }
        }
    }

    @Override
    public Runnable getEvent(@NotNull EventMetadataExtended event, @NotNull EventDataReceivingHandler progress, @NotNull EventDataReceivedHandler done) {
        if (event == null) {
            TraceSessionImpl.$$$reportNull$$$0(16);
        }
        if (progress == null) {
            TraceSessionImpl.$$$reportNull$$$0(17);
        }
        if (done == null) {
            TraceSessionImpl.$$$reportNull$$$0(18);
        }
        if (this.isRunning()) {
            try {
                String requestId = this.myBackendConnection.getEvent(event, progress, done);
                return () -> {
                    if (this.isRunning() && requestId != null) {
                        try {
                            this.myCache.putCancelledRequestId(requestId);
                            this.myBackendConnection.stopGettingEvent(requestId);
                        }
                        catch (Exception e) {
                            this.handleConnectionError(e);
                        }
                    }
                };
            }
            catch (Exception e) {
                this.handleConnectionError(e);
            }
        } else {
            done.eventDataReceived(new StackEntryBase[0]);
        }
        return () -> {};
    }

    @Override
    public void ensureFileDataLoaded(@NotNull String[] fileIds, @NotNull Runnable runWhenFileDataLoaded) {
        if (fileIds == null) {
            TraceSessionImpl.$$$reportNull$$$0(19);
        }
        if (runWhenFileDataLoaded == null) {
            TraceSessionImpl.$$$reportNull$$$0(20);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (fileIds == null) {
                TraceSessionImpl.$$$reportNull$$$0(35);
            }
            if (runWhenFileDataLoaded == null) {
                TraceSessionImpl.$$$reportNull$$$0(36);
            }
            connection.ensureFileDataLoaded(fileIds, runWhenFileDataLoaded);
        }));
    }

    @Override
    public void getTracedSourceFile(@NotNull RuntimeFunctionScope functionScope, @NotNull FileLoadedHandler done, boolean useMappedSourceIfAvailable) {
        if (functionScope == null) {
            TraceSessionImpl.$$$reportNull$$$0(21);
        }
        if (done == null) {
            TraceSessionImpl.$$$reportNull$$$0(22);
        }
        try {
            String fileId = functionScope.getFileId();
            String streamId = functionScope.getEventMetadata().getStreamId();
            OriginalTraceVirtualFile file = this.myCache.getTraceVirtualFileByIdAndStreamId(fileId, streamId);
            Object[] statementsToLoad = (RuntimeStatement[])ContainerUtil.findAllAsArray((Object[])functionScope.getStatements(), statement -> !statement.isLoaded());
            Integer[] indices = (Integer[])ContainerUtil.map((Object[])statementsToLoad, statement -> statement.getId(), (Object[])new Integer[0]);
            if (file != null && statementsToLoad.length == 0) {
                TraceSessionImpl.invokeFileLoaded(file, functionScope, done, useMappedSourceIfAvailable);
                return;
            }
            if (this.isRunning()) {
                this.myBackendConnection.getFragment(functionScope.getEventMetadata(), indices, file != null ? null : functionScope.getFileId(), (arg_0, arg_1) -> this.lambda$getTracedSourceFile$14(file, streamId, (RuntimeStatement[])statementsToLoad, functionScope, done, useMappedSourceIfAvailable, arg_0, arg_1));
            }
        }
        catch (Exception e) {
            this.handleConnectionError(e);
        }
    }

    private OriginalTraceVirtualFile createTraceVirtualFile(TraceSessionCache traceSessionCache, SourceFile sourceFile, String streamId) {
        ArrayList<MappedTraceVirtualFile> mappedVirtualFiles = new ArrayList<MappedTraceVirtualFile>();
        for (MappedSourceFile mappedSourceFile : sourceFile.getMappedSourceFiles()) {
            mappedVirtualFiles.add(new MappedTraceVirtualFile(mappedSourceFile.getUrl(), mappedSourceFile.getSource(), this.findLocalFileByUrl(mappedSourceFile.getUrl()), streamId));
        }
        return new OriginalTraceVirtualFile(traceSessionCache.getRemoteUrlByFileId(sourceFile.getFileId()), sourceFile.getSource(), traceSessionCache.getLocalVirtualFileByRemoteUrl(traceSessionCache.getRemoteUrlByFileId(sourceFile.getFileId())), mappedVirtualFiles.toArray(new MappedTraceVirtualFile[0]), streamId);
    }

    private static void invokeFileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, FileLoadedHandler handler, boolean useMappedSourceIfAvailable) {
        ApplicationManager.getApplication().invokeLater(() -> handler.fileLoaded(file, functionScope, useMappedSourceIfAvailable));
    }

    @Override
    public void onNewEvent(@NotNull EventMetadataReceivedHandler done) {
        if (done == null) {
            TraceSessionImpl.$$$reportNull$$$0(23);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (done == null) {
                TraceSessionImpl.$$$reportNull$$$0(32);
            }
            connection.onNewEvent(done);
        }));
    }

    @Override
    public void onNewContext(@NotNull NewEventStreamHandler onNewContext) {
        if (onNewContext == null) {
            TraceSessionImpl.$$$reportNull$$$0(24);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (onNewContext == null) {
                TraceSessionImpl.$$$reportNull$$$0(31);
            }
            connection.onNewContext(onNewContext);
        }));
    }

    @Override
    public void onTraceFileChanged(@NotNull Consumer<VirtualFile> onTraceFileChanged) {
        if (onTraceFileChanged == null) {
            TraceSessionImpl.$$$reportNull$$$0(25);
        }
        this.myTraceFileChangedHandlers.add(onTraceFileChanged);
    }

    @Override
    public void onContextChanged(@NotNull EventStreamChangedHandler onContextChanged) {
        if (onContextChanged == null) {
            TraceSessionImpl.$$$reportNull$$$0(26);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (onContextChanged == null) {
                TraceSessionImpl.$$$reportNull$$$0(30);
            }
            connection.onContextChanged(onContextChanged);
        }));
    }

    @Override
    public void onTraceLoaded(@NotNull TraceLoadedHandler onTraceLoaded) {
        if (onTraceLoaded == null) {
            TraceSessionImpl.$$$reportNull$$$0(27);
        }
        this.myTraceLoadedHandlers.add(onTraceLoaded);
    }

    @Override
    public void onSessionStopped(@NotNull Runnable onSessionStopped) {
        if (onSessionStopped == null) {
            TraceSessionImpl.$$$reportNull$$$0(28);
        }
        this.mySessionStoppedHandlers.add(onSessionStopped);
    }

    @Override
    public void onError(@NotNull Consumer<Exception> onError) {
        if (onError == null) {
            TraceSessionImpl.$$$reportNull$$$0(29);
        }
        this.myErrorHandlers.add(onError);
    }

    @Override
    public boolean isRunning() {
        return this.myBackendConnection != null && this.myBackendConnection.isOpen();
    }

    @Override
    public boolean isNodeJsSession() {
        return this.myConfiguration instanceof TraceNodeConfiguration;
    }

    public void dispose() {
        this.disposeConnection();
        this.myProcessHandler.putUserData(TraceContext.KEY, null);
        if (!this.myProcessHandler.isProcessTerminated()) {
            this.myProcessHandler.destroyProcess();
        }
    }

    private void fileCached(String url) {
        VirtualFile file = this.findLocalFileByUrl(url);
        if (file == null) {
            return;
        }
        this.myCache.putRemoteUrlLocalVirtualFile(file, url);
        for (Consumer<VirtualFile> handler : this.myTraceFileChangedHandlers) {
            handler.consume((Object)file);
        }
    }

    private VirtualFile findLocalFileByUrl(String url) {
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        String protocol = VirtualFileManager.extractProtocol((String)url);
        if (StringUtil.isEmpty((String)protocol)) {
            return LocalFileSystem.getInstance().findFileByPath(url);
        }
        Url fileUrl = Urls.parse((String)url, (boolean)false);
        if (fileUrl == null) {
            return null;
        }
        if (this.fileUrlMappers != null) {
            for (FileUrlMapper mapper : this.fileUrlMappers) {
                VirtualFile file = mapper.getFile(fileUrl, this.myProject, null);
                if (file == null) continue;
                return file;
            }
        }
        return WebServerPathToFileManager.getInstance((Project)this.myProject).findVirtualFile(fileUrl.getPath());
    }

    private void handleConnectionError(Exception error) {
        LOG.warn((Throwable)error);
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Consumer<Exception> handler : this.myErrorHandlers) {
                handler.consume((Object)error);
            }
        });
        if (error instanceof SocketIOException) {
            Disposer.dispose((Disposable)this);
        }
    }

    private /* synthetic */ void lambda$getTracedSourceFile$14(OriginalTraceVirtualFile file, String streamId, RuntimeStatement[] statementsToLoad, @NotNull RuntimeFunctionScope functionScope, @NotNull FileLoadedHandler done, boolean useMappedSourceIfAvailable, SourceFile sourceFile, StackEntryBase[] fragment) {
        if (functionScope == null) {
            TraceSessionImpl.$$$reportNull$$$0(33);
        }
        if (done == null) {
            TraceSessionImpl.$$$reportNull$$$0(34);
        }
        try {
            OriginalTraceVirtualFile virtualFile = file == null ? this.createTraceVirtualFile(this.myCache, sourceFile, streamId) : file;
            for (int i = 0; i < fragment.length; ++i) {
                RuntimeReturnStatement returnStatement;
                RuntimeStatement statement = statementsToLoad[i];
                StaticCodeElement element = fragment[i].getStaticCodeElement();
                statement.update(element);
                if (!(element instanceof StaticInReturn) || (returnStatement = functionScope.getReturnStatement()) == null) continue;
                returnStatement.setInReturnStatement(statement);
            }
            if (file == null) {
                this.myCache.putTraceVirtualFileIdAndStreamId(sourceFile.getFileId(), streamId, virtualFile);
            }
            TraceSessionImpl.invokeFileLoaded(virtualFile, functionScope, done, useMappedSourceIfAvailable);
        }
        catch (Exception e) {
            this.handleConnectionError(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/session/TraceSessionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 7: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationResultConsumer";
                break;
            }
            case 9: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchResultConsumer";
                break;
            }
            case 11: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDependencyGraphConsumer";
                break;
            }
            case 12: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTraceSaved";
                break;
            }
            case 13: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 14: 
            case 27: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTraceLoaded";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "done";
                break;
            }
            case 19: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIds";
                break;
            }
            case 20: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhenFileDataLoaded";
                break;
            }
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionScope";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onNewContext";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onTraceFileChanged";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onContextChanged";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSessionStopped";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/session/TraceSessionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTraceServerProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoadedTracedSourceFiles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContextMetadata";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteTracedFile";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applySettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeInBrowser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "searchFunction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileDependencyVirtualFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveTrace";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadTrace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCodeElementById";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEvent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ensureFileDataLoaded";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTracedSourceFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onNewEvent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onNewContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "onTraceFileChanged";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "onContextChanged";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onTraceLoaded";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onSessionStopped";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onContextChanged$18";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onNewContext$17";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onNewEvent$16";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTracedSourceFile$14";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$ensureFileDataLoaded$11";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadTrace$8";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$saveTrace$5";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileDependencyVirtualFile$4";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchFunction$3";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateExpression$2";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeInBrowser$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEventReceiver {
        private final List<Pair<Integer, StackEntryBase[]>> myReceivedStackEntries;
        private int mySize;
        private int myTotalExpectedStackEntries;
        private final String myRequestId;
        private final EventDataReceivingHandler myProgress;
        private final EventDataReceivedHandler myDone;

        public MyEventReceiver(@NotNull EventDataReceivingHandler progress, @NotNull EventDataReceivedHandler done) {
            if (progress == null) {
                MyEventReceiver.$$$reportNull$$$0(0);
            }
            if (done == null) {
                MyEventReceiver.$$$reportNull$$$0(1);
            }
            this.myReceivedStackEntries = new ArrayList<Pair<Integer, StackEntryBase[]>>();
            this.myProgress = progress;
            this.myDone = done;
            this.myRequestId = Long.toHexString(Double.doubleToLongBits(Math.random()));
        }

        public boolean isExpectingEvent(String eventRequestId) {
            return this.myRequestId.equals(eventRequestId);
        }

        public void addEventChunk(int chunkId, @NotNull StackEntryBase[] chunk) {
            if (chunk == null) {
                MyEventReceiver.$$$reportNull$$$0(2);
            }
            this.mySize += chunk.length;
            this.myReceivedStackEntries.add((Pair<Integer, StackEntryBase[]>)new Pair((Object)chunkId, (Object)chunk));
            this.myProgress.eventDataReceiving((double)this.mySize / (double)this.myTotalExpectedStackEntries);
        }

        public String getRequestId() {
            return this.myRequestId;
        }

        public void finished() {
            this.myProgress.eventDataReceiving(1.0);
            this.myDone.eventDataReceived(this.getEvent());
            this.myReceivedStackEntries.clear();
            this.mySize = 0;
            this.myTotalExpectedStackEntries = 0;
        }

        private StackEntryBase[] getEvent() {
            Collections.sort(this.myReceivedStackEntries, Comparator.comparing(pair -> (Integer)pair.getFirst()));
            List entries = ContainerUtil.concat(this.myReceivedStackEntries, pair -> Arrays.asList((Object[])pair.getSecond()));
            return entries.toArray(new StackEntryBase[0]);
        }

        public void setExpectedTotal(int expectedTotal) {
            this.myTotalExpectedStackEntries = expectedTotal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "done";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyEventReceiver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addEventChunk";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyBackendConnection
    implements IOCallback,
    Disposable {
        private static final String SESSION_START = "session.start";
        private static final String SESSION_SAVE = "session.save";
        private static final String SESSION_LOAD = "session.load";
        private static final String CONFIG_FILE_CHANGE = "config.file.change";
        private static final String CONFIG_CHANGE = "config.change";
        private static final String BROWSER_EXECUTE = "browser.execute";
        private static final String FILE_CACHE_CLEAR = "file.cache.clear";
        private static final String FILE_DEPENDENCY_GET = "file.dependency.get";
        private static final String EVENT_GET = "event.get";
        private static final String EVENT_GET_CANCEL = "event.get.cancel";
        private static final String FRAGMENT_GET = "fragment.get";
        private static final String EXPRESSION_EVALUATE = "expression.evaluate";
        private static final String FUNCTION_SEARCH = "function.search";
        private static final String INSTRUMENTATION_MAP_GET = "source.instrumentationMap.get";
        private static final String EVENT_SESSION_NEW = "event.session.new";
        private static final String EVENT_SESSION_DISPOSE = "event.session.dispose";
        private static final String EVENT_CONTEXT_NEW = "event.context.new";
        private static final String EVENT_CONTEXT_EXPIRED = "event.context.expired";
        private static final String EVENT_CONTEXT_ACTIVE = "event.context.active";
        private static final String EVENT_CONTEXT_INTERRUPTION = "event.context.interruption";
        private static final String EVENT_FILE_CACHE = "event.file.cache";
        private static final String EVENT_EVENT_METADATA = "event.event.metadata";
        private static final String EVENT_EVENT_DATA = "event.event.data";
        private static final String EVENT_EVENT_DATA_END = "event.event.data.end";
        private SocketIO mySocket;
        private final List<NewEventStreamHandler> myNewContextAddedHandlers = new ArrayList<NewEventStreamHandler>();
        private final List<EventStreamChangedHandler> myContextChangedHandlers = new ArrayList<EventStreamChangedHandler>();
        private final List<EventMetadataReceivedHandler> myExpectedEventMetadataReceivedHandlers = new ArrayList<EventMetadataReceivedHandler>();
        private final List<Runnable> myStartDelegates = new ArrayList<Runnable>();
        private MyEventReceiver myEventReceiver;
        private final JSONObject myConfig;

        private MyBackendConnection(JSONObject config) {
            this.myConfig = config;
        }

        public void open() {
            try {
                this.mySocket = new SocketIO("http://127.0.0.1:" + TraceSessionImpl.this.myConfiguration.getProxyPort());
                this.mySocket.connect((IOCallback)this);
                java.util.logging.Logger.getLogger("io.socket").setLevel(Level.OFF);
                for (Runnable delegate : this.myStartDelegates) {
                    delegate.run();
                }
                this.myStartDelegates.clear();
            }
            catch (Exception e) {
                TraceSessionImpl.this.handleConnectionError(e);
            }
        }

        public void onDisconnect() {
        }

        public void onConnect() {
        }

        public void onMessage(String s, IOAcknowledge acknowledge) {
        }

        public void onMessage(JSONObject object, IOAcknowledge acknowledge) {
        }

        public void on(String s, IOAcknowledge acknowledge, Object ... objects) {
            try {
                JSONObject incomingJson = this.getJsonObject(objects);
                if (s.equals(EVENT_SESSION_NEW)) {
                    this.mySocket.emit(SESSION_START, objects1 -> LOG.info("session started"), new Object[]{this.myConfig});
                } else if (s.equals(EVENT_SESSION_DISPOSE)) {
                    LOG.info("session disposed");
                } else if (s.equals(EVENT_CONTEXT_NEW)) {
                    if (!this.myNewContextAddedHandlers.isEmpty()) {
                        String id = incomingJson.getString("id");
                        String doc = incomingJson.optString("doc");
                        String agent = incomingJson.getString("agent");
                        String referrer = incomingJson.optString("referrer");
                        ApplicationManager.getApplication().invokeLater(() -> {
                            for (NewEventStreamHandler handler : this.myNewContextAddedHandlers) {
                                ContextMetadata context = new ContextMetadata(id, doc, agent, referrer);
                                handler.newEventStreamAdded(context);
                                TraceSessionImpl.this.myCache.putContextMetadata(context);
                            }
                        });
                    }
                } else if (s.equals(EVENT_CONTEXT_INTERRUPTION) || s.equals(EVENT_CONTEXT_EXPIRED) || s.equals(EVENT_CONTEXT_ACTIVE)) {
                    if (!this.myContextChangedHandlers.isEmpty()) {
                        String id = incomingJson.getString("id");
                        ApplicationManager.getApplication().invokeLater(() -> {
                            for (EventStreamChangedHandler handler : this.myContextChangedHandlers) {
                                handler.eventStreamChanged(id, s.equals(EVENT_CONTEXT_INTERRUPTION) ? EventStreamChangeType.INTERRUPTED : (s.equals(EVENT_CONTEXT_EXPIRED) ? EventStreamChangeType.EXPIRED : EventStreamChangeType.ACTIVATED));
                            }
                        });
                    }
                } else if (s.equals(EVENT_FILE_CACHE)) {
                    TraceSessionImpl.this.fileCached(incomingJson.getString("url"));
                } else if (s.equals(EVENT_EVENT_METADATA)) {
                    EventMetadataExtended eventMetadata = JsonSerialization.deserializeEventMetadataExtended(incomingJson, TraceSessionImpl.this.myCache);
                    FileDependencyVirtualFile appDependencyFile = TraceSessionImpl.this.myCache.getFileDependencyVirtualFile(new FileDependencyRequest(eventMetadata.getStreamId(), ""));
                    FileDependencyVirtualFile eventDependencyFile = TraceSessionImpl.this.myCache.getFileDependencyVirtualFile(new FileDependencyRequest(eventMetadata.getStreamId(), "", eventMetadata.getEventId()));
                    if (appDependencyFile != null) {
                        appDependencyFile.setExpired();
                    }
                    if (eventDependencyFile != null) {
                        eventDependencyFile.setExpired();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!this.myExpectedEventMetadataReceivedHandlers.isEmpty()) {
                            for (EventMetadataReceivedHandler handler : this.myExpectedEventMetadataReceivedHandlers) {
                                handler.eventMetadataReceived(eventMetadata);
                            }
                        }
                    });
                } else if (s.equals(EVENT_EVENT_DATA) || s.equals(EVENT_EVENT_DATA_END)) {
                    String correlationId = incomingJson.getString("correlationId");
                    if (s.equals(EVENT_EVENT_DATA) && this.isExpectingEvent(correlationId)) {
                        StackEntryBase[] receivedEntries = JsonSerialization.deserializeStackBaseEntries(incomingJson, TraceSessionImpl.this.myCache);
                        int chunkId = incomingJson.getInt("chunkId");
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.isExpectingEvent(correlationId)) {
                                this.myEventReceiver.addEventChunk(chunkId, receivedEntries);
                            }
                        });
                    } else if (s.equals(EVENT_EVENT_DATA_END) && this.isExpectingEvent(correlationId)) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.isExpectingEvent(correlationId)) {
                                this.myEventReceiver.finished();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                TraceSessionImpl.this.handleConnectionError(e);
            }
        }

        private boolean isExpectingEvent(String correlationId) {
            return this.myEventReceiver != null && this.myEventReceiver.isExpectingEvent(correlationId);
        }

        public void onError(SocketIOException e) {
            TraceSessionImpl.this.handleConnectionError((Exception)e);
        }

        private JSONObject getJsonObject(Object ... objects) {
            if (objects.length > 0 && objects[0] instanceof JSONObject) {
                return (JSONObject)objects[0];
            }
            return new JSONObject();
        }

        public void close() {
            if (this.mySocket != null) {
                this.mySocket.disconnect();
            }
        }

        public void dispose() {
            this.close();
        }

        public String getEvent(@NotNull EventMetadataExtended eventMetadata, @NotNull EventDataReceivingHandler progress, @NotNull EventDataReceivedHandler done) {
            if (eventMetadata == null) {
                MyBackendConnection.$$$reportNull$$$0(0);
            }
            if (progress == null) {
                MyBackendConnection.$$$reportNull$$$0(1);
            }
            if (done == null) {
                MyBackendConnection.$$$reportNull$$$0(2);
            }
            this.myEventReceiver = new MyEventReceiver(progress, done);
            if (this.mySocket == null) {
                return null;
            }
            String requestId = this.myEventReceiver.getRequestId();
            Runnable getEventData = () -> {
                if (eventMetadata == null) {
                    MyBackendConnection.$$$reportNull$$$0(21);
                }
                if (TraceSessionImpl.this.myCache.isRequestCancelled(requestId)) {
                    return;
                }
                try {
                    JSONObject json = JsonSerialization.serializeEventMetadata(eventMetadata);
                    json.put("compact", true);
                    json.put("correlationId", (Object)requestId);
                    this.mySocket.emit(EVENT_GET, objects -> {
                        if (TraceSessionImpl.this.myCache.isRequestCancelled(requestId)) {
                            return;
                        }
                        try {
                            this.myEventReceiver.setExpectedTotal(Integer.parseInt(objects[0].toString()));
                        }
                        catch (Exception e) {
                            TraceSessionImpl.this.handleConnectionError(e);
                        }
                    }, new Object[]{json});
                }
                catch (Exception e) {
                    TraceSessionImpl.this.handleConnectionError(e);
                }
            };
            this.ensureFileDataLoaded(eventMetadata.getFileIds(), getEventData);
            return requestId;
        }

        public void ensureFileDataLoaded(@NotNull String[] fileIds, @NotNull Runnable runWhenFileDataLoaded) {
            List<String> fileIdList;
            JSONArray fileIdsToLoadMapFor;
            if (fileIds == null) {
                MyBackendConnection.$$$reportNull$$$0(3);
            }
            if (runWhenFileDataLoaded == null) {
                MyBackendConnection.$$$reportNull$$$0(4);
            }
            if ((fileIdsToLoadMapFor = new JSONArray(ContainerUtil.subtract(fileIdList = Arrays.asList(fileIds), Arrays.asList(TraceSessionImpl.this.myCache.getFileIdsWithLoadedInstrumentationMap())))).length() > 0) {
                this.mySocket.emit(INSTRUMENTATION_MAP_GET, objects -> {
                    if (runWhenFileDataLoaded == null) {
                        MyBackendConnection.$$$reportNull$$$0(20);
                    }
                    try {
                        JSONObject incomingJson = this.getJsonObject(objects);
                        incomingJson.remove("functionsInFile");
                        for (Object key : () -> incomingJson.keys()) {
                            TraceSessionImpl.this.myCache.putCodeElementId(key.toString(), StaticCodeElementParser.parseCodeElement(incomingJson.getString(key.toString()), TraceSessionImpl.this.myCache));
                        }
                        TraceSessionImpl.this.myCache.addFileIdsWithLoadedInstrumentationMap(fileIdList);
                        runWhenFileDataLoaded.run();
                    }
                    catch (Exception e) {
                        TraceSessionImpl.this.handleConnectionError(e);
                    }
                }, new Object[]{fileIdsToLoadMapFor});
            } else {
                runWhenFileDataLoaded.run();
            }
        }

        public void getFragment(@NotNull EventMetadata eventMetadata, @NotNull Integer[] ids, String fileId, @NotNull FragmentReceivedHandler done) throws JSONException {
            if (eventMetadata == null) {
                MyBackendConnection.$$$reportNull$$$0(5);
            }
            if (ids == null) {
                MyBackendConnection.$$$reportNull$$$0(6);
            }
            if (done == null) {
                MyBackendConnection.$$$reportNull$$$0(7);
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeEventMetadata(eventMetadata);
            json.put("fileId", (Object)fileId);
            json.put("ids", (Object)new JSONArray((Object)ids));
            this.mySocket.emit(FRAGMENT_GET, objects -> {
                if (done == null) {
                    MyBackendConnection.$$$reportNull$$$0(19);
                }
                try {
                    JSONObject json1 = this.getJsonObject(objects);
                    SourceFile file = JsonSerialization.deserializeSourceFile(json1.optJSONObject("source"));
                    StackEntryBase[] entries = JsonSerialization.deserializeStackBaseEntries(json1, TraceSessionImpl.this.myCache);
                    done.fragmentReceived(file, entries);
                }
                catch (Exception e) {
                    TraceSessionImpl.this.handleConnectionError(e);
                }
            }, new Object[]{json});
        }

        private void evaluateExpression(@NotNull ExpressionEvaluationRequest request, Consumer<ExpressionEvaluationResult> expressionEvaluationResultConsumer) {
            if (request == null) {
                MyBackendConnection.$$$reportNull$$$0(8);
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeExpressionEvaluationRequest(request);
            this.mySocket.emit(EXPRESSION_EVALUATE, objects -> expressionEvaluationResultConsumer.consume((Object)JsonSerialization.deserializeExpressionEvaluationResult(this.getJsonObject(objects))), new Object[]{json});
        }

        public void searchFunction(@NotNull TraceSearchRequest request, @NotNull Consumer<TraceSearchResult> searchResultConsumer) {
            if (request == null) {
                MyBackendConnection.$$$reportNull$$$0(9);
            }
            if (searchResultConsumer == null) {
                MyBackendConnection.$$$reportNull$$$0(10);
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeFunctionSearchRequest(request);
            this.mySocket.emit(FUNCTION_SEARCH, objects -> {
                if (searchResultConsumer == null) {
                    MyBackendConnection.$$$reportNull$$$0(18);
                }
                searchResultConsumer.consume((Object)JsonSerialization.deserializeFunctionSearchResult(this.getJsonObject(objects)));
            }, new Object[]{json});
        }

        public void getFileDependencyGraph(@NotNull FileDependencyRequest request, @NotNull Consumer<FileDependencyVirtualFile> fileDependencyGraphConsumer) {
            if (request == null) {
                MyBackendConnection.$$$reportNull$$$0(11);
            }
            if (fileDependencyGraphConsumer == null) {
                MyBackendConnection.$$$reportNull$$$0(12);
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeFileDependencyRequest(request);
            this.mySocket.emit(FILE_DEPENDENCY_GET, objects -> {
                if (request == null) {
                    MyBackendConnection.$$$reportNull$$$0(15);
                }
                if (fileDependencyGraphConsumer == null) {
                    MyBackendConnection.$$$reportNull$$$0(16);
                }
                FileDependencyGraph dependencyGraph = JsonSerialization.deserializeFileDependencyGraph(this.getJsonObject(objects), TraceSessionImpl.this.myCache, request.getStreamId());
                assert (dependencyGraph != null);
                FileDependencyVirtualFile file = request.getFileToUpdate();
                if (file != null) {
                    file.update(dependencyGraph);
                } else {
                    file = new FileDependencyVirtualFile(dependencyGraph, request.getName());
                    TraceSessionImpl.this.myCache.putFileDependencyVirtualFile(request, file);
                    if (request.getEventId() != null) {
                        file.addNodeFilter((Predicate<FileNode>)((Predicate)input -> {
                            if (request == null) {
                                MyBackendConnection.$$$reportNull$$$0(17);
                            }
                            return input != null && input.isUsedInEvent(request.getEventId());
                        }));
                    }
                }
                fileDependencyGraphConsumer.consume((Object)file);
            }, new Object[]{json});
        }

        public void onNewEvent(@NotNull EventMetadataReceivedHandler done) {
            if (done == null) {
                MyBackendConnection.$$$reportNull$$$0(13);
            }
            this.myExpectedEventMetadataReceivedHandlers.add(done);
        }

        public void onNewContext(NewEventStreamHandler onNewContext) {
            this.myNewContextAddedHandlers.add(onNewContext);
        }

        public void onContextChanged(@NotNull EventStreamChangedHandler onContextChanged) {
            if (onContextChanged == null) {
                MyBackendConnection.$$$reportNull$$$0(14);
            }
            this.myContextChangedHandlers.add(onContextChanged);
        }

        public void clearFileCache(String url) {
            this.mySocket.emit(FILE_CACHE_CLEAR, new Object[]{url});
        }

        public void stopGettingEvent(String requestId) {
            this.mySocket.emit(EVENT_GET_CANCEL, new Object[]{requestId});
        }

        public void updateConfigFile(String path, boolean reload) {
            JSONObject json = new JSONObject();
            try {
                json.put("path", (Object)path);
                json.put("reload", reload);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.mySocket.emit(CONFIG_FILE_CHANGE, new Object[]{json});
        }

        public boolean isOpen() {
            return this.mySocket != null && this.mySocket.isConnected();
        }

        public void applyConfig(TraceSettings config) {
            this.runWhenConnectionIsOpen(() -> this.mySocket.emit(CONFIG_CHANGE, new Object[]{JsonSerialization.serializeConfig(config)}));
        }

        public void executeInBrowser(EventStreamCommand command) {
            this.mySocket.emit(BROWSER_EXECUTE, new Object[]{JsonSerialization.serializeEventStreamCommand(command)});
        }

        public void saveTrace(TraceSavedHandler saved) {
            this.mySocket.emit(SESSION_SAVE, objects -> {
                try {
                    JSONObject json = this.getJsonObject(objects);
                    String file = json.optString("file");
                    if (!StringUtil.isEmpty((String)file)) {
                        saved.traceSaved(file);
                    }
                }
                catch (Exception e) {
                    TraceSessionImpl.this.handleConnectionError(e);
                }
            }, new Object[0]);
        }

        public void loadTrace(String trace, TraceLoadedHandler onTraceLoaded) {
            this.mySocket.emit(SESSION_LOAD, objects -> {
                JSONObject json = this.getJsonObject(objects);
                String traceId = StringUtil.notNullize((String)json.optString("id"));
                onTraceLoaded.traceLoaded(traceId);
            }, new Object[]{trace});
        }

        private void runWhenConnectionIsOpen(Runnable delegate) {
            if (this.isOpen()) {
                delegate.run();
            } else {
                this.myStartDelegates.add(delegate);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventMetadata";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 2: 
                case 7: 
                case 13: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "done";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileIds";
                    break;
                }
                case 4: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runWhenFileDataLoaded";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
                case 8: 
                case 9: 
                case 11: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 10: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchResultConsumer";
                    break;
                }
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileDependencyGraphConsumer";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onContextChanged";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEvent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ensureFileDataLoaded";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFragment";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateExpression";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchFunction";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileDependencyGraph";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onNewEvent";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onContextChanged";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getFileDependencyGraph$14";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$13";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$searchFunction$12";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getFragment$10";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$ensureFileDataLoaded$9";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getEvent$7";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface FragmentReceivedHandler {
        public void fragmentReceived(SourceFile var1, StackEntryBase[] var2);
    }
}

