/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack;

import com.intellij.javascript.trace.execution.code.StaticAnotherStatement;
import com.intellij.javascript.trace.execution.code.StaticConditionalAlternate;
import com.intellij.javascript.trace.execution.code.StaticConditionalConsequent;
import com.intellij.javascript.trace.execution.code.StaticElementVisitor;
import com.intellij.javascript.trace.execution.code.StaticExceptionElement;
import com.intellij.javascript.trace.execution.code.StaticFuncEnd;
import com.intellij.javascript.trace.execution.code.StaticFuncStart;
import com.intellij.javascript.trace.execution.code.StaticLogicalLeft;
import com.intellij.javascript.trace.execution.code.StaticLogicalRight;
import com.intellij.javascript.trace.execution.code.StaticProgramEnd;
import com.intellij.javascript.trace.execution.code.StaticProgramStart;
import com.intellij.javascript.trace.execution.code.StaticReturn;
import com.intellij.javascript.trace.execution.code.StaticUnknownElement;
import com.intellij.javascript.trace.execution.common.EventMetadata;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.StackEntryBase;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StackTreeStructure
extends SimpleTreeStructure {
    private final StackNode myRootNode;
    private final List<StackNode> myAllNodes;
    private StackEntryBase myCurrentEntry;
    private final Stack<MyStackLevel> myStack;
    private int myIndex;

    public StackTreeStructure(StackEntryBase[] entries, EventMetadata eventMetadata, @NotNull TraceProjectSettings.EventFilterState activeFilter) {
        if (activeFilter == null) {
            StackTreeStructure.$$$reportNull$$$0(0);
        }
        this.myRootNode = new StackNode();
        this.myAllNodes = new ArrayList<StackNode>();
        this.myStack = new Stack();
        this.buildNodes(entries, eventMetadata, activeFilter);
    }

    public StackNode[] getAllNodes() {
        return this.myAllNodes.toArray(new StackNode[0]);
    }

    private StackEntryBase getCurrentEntry() {
        return this.myCurrentEntry;
    }

    private int getCurrentIndex() {
        return this.myIndex++;
    }

    private void buildNodes(StackEntryBase[] stackEntries, final EventMetadata eventMetadata, final TraceProjectSettings.EventFilterState activeFilter) {
        final StackNode rootNode = this.myRootNode;
        this.myIndex = 0;
        StaticElementVisitor treeBuilder = new StaticElementVisitor(){
            private StackNode myCurrentNode;
            {
                this.myCurrentNode = rootNode;
            }

            @Override
            public void visit(StaticFuncStart element) {
                RuntimeStatement callerStatement = this.getCallerStatement();
                StackTreeStructure.this.myStack.push((Object)new MyStackLevel(activeFilter.matchesFileName(element.getFile())));
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.myCurrentNode = this.myCurrentNode.createChild(new RuntimeFunctionScope(eventMetadata, element, StackTreeStructure.this.getCurrentEntry().getObjDump(), callerStatement));
                this.visitScopeStart();
            }

            private RuntimeStatement getCallerStatement() {
                if (StackTreeStructure.this.myStack.size() <= 0) {
                    return null;
                }
                MyStackLevel stackLevel = null;
                for (int i = StackTreeStructure.this.myStack.size() - 1; i >= 0 && (stackLevel = (MyStackLevel)StackTreeStructure.this.myStack.get(i)).isMuted(); --i) {
                }
                if (stackLevel == null || stackLevel.isMuted()) {
                    return null;
                }
                return stackLevel.getLastStatement() != null ? stackLevel.getLastStatement() : RuntimeFunctionScope.FIRST_STATEMENT;
            }

            @Override
            public void visit(StaticFuncEnd element) {
                this.visitScopeEnd();
            }

            @Override
            public void visit(StaticProgramStart element) {
                RuntimeStatement callerStatement = this.getCallerStatement();
                StackTreeStructure.this.myStack.push((Object)new MyStackLevel(activeFilter.matchesFileName(element.getFile())));
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.myCurrentNode = this.myCurrentNode.createChild(new RuntimeFunctionScope(eventMetadata, element, callerStatement));
                this.visitScopeStart();
            }

            @Override
            public void visit(StaticProgramEnd element) {
                this.visitScopeEnd();
            }

            @Override
            public void visit(StaticExceptionElement element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.myCurrentNode.getScope().setExceptionValue(StackTreeStructure.this.getCurrentEntry().getObjDump());
            }

            @Override
            public void visit(StaticReturn element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.myCurrentNode.getScope().setReturnValue(StackTreeStructure.this.getCurrentEntry().getObjDump());
                this.setLastStatement(this.myCurrentNode.getScope().addReturnStatement(element));
            }

            @Override
            public void visit(StaticConditionalAlternate element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.setLastStatement(this.myCurrentNode.getScope().addStatement(element));
            }

            @Override
            public void visit(StaticConditionalConsequent element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.setLastStatement(this.myCurrentNode.getScope().addStatement(element));
            }

            @Override
            public void visit(StaticLogicalLeft element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.setLastStatement(this.myCurrentNode.getScope().addStatement(element));
            }

            @Override
            public void visit(StaticLogicalRight element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.setLastStatement(this.myCurrentNode.getScope().addStatement(element));
            }

            @Override
            public void visit(StaticAnotherStatement element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.setLastStatement(this.myCurrentNode.getScope().addStatement(element));
            }

            @Override
            public void visit(StaticUnknownElement element) {
                if (this.isStackLevelMuted()) {
                    return;
                }
                this.setLastStatement(this.myCurrentNode.getScope().addStatementStub(element, StackTreeStructure.this.getCurrentEntry().getId()));
            }

            private void visitScopeStart() {
                this.myCurrentNode.startedAt(StackTreeStructure.this.getCurrentEntry().getTimeStamp());
                StackTreeStructure.this.myAllNodes.add(this.myCurrentNode);
                this.myCurrentNode.setNodeIndex(StackTreeStructure.this.getCurrentIndex());
            }

            private void visitScopeEnd() {
                if (((MyStackLevel)StackTreeStructure.this.myStack.pop()).isMuted()) {
                    return;
                }
                this.myCurrentNode.finishedAt(StackTreeStructure.this.getCurrentEntry().getTimeStamp());
                StackNode currentNode = this.myCurrentNode;
                this.myCurrentNode = this.myCurrentNode.getParentStackNode();
                Object[] children = currentNode.getChildren();
                if (children.length < 2) {
                    return;
                }
                double halfTime = currentNode.getExecutionTime() / 2.0;
                SimpleNode moreThanHalfTimeNode = (SimpleNode)ContainerUtil.find((Object[])children, node -> node instanceof StackNode && ((StackNode)((Object)node)).getExecutionTime() > halfTime);
                if (!(moreThanHalfTimeNode instanceof StackNode)) {
                    return;
                }
                ((StackNode)moreThanHalfTimeNode).takesSignificantTimeToExecute();
            }

            private boolean isStackLevelMuted() {
                return ((MyStackLevel)StackTreeStructure.this.myStack.peek()).isMuted();
            }

            private void setLastStatement(RuntimeStatement statement) {
                ((MyStackLevel)StackTreeStructure.this.myStack.peek()).setLastStatement(statement);
            }
        };
        StackEntryBase[] stackEntryBaseArray = stackEntries;
        int n = stackEntryBaseArray.length;
        for (int i = 0; i < n; ++i) {
            StackEntryBase currentEntry;
            this.myCurrentEntry = currentEntry = stackEntryBaseArray[i];
            currentEntry.getStaticCodeElement().accept(treeBuilder);
        }
    }

    public Object getRootElement() {
        return this.myRootNode;
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeFilter", "com/intellij/javascript/trace/execution/stack/StackTreeStructure", "<init>"));
    }

    private static class MyStackLevel {
        private final boolean myIgnore;
        private RuntimeStatement myStatement;

        private MyStackLevel(boolean ignore) {
            this.myIgnore = ignore;
        }

        public boolean isMuted() {
            return this.myIgnore;
        }

        public void setLastStatement(RuntimeStatement statement) {
            this.myStatement = statement;
        }

        public RuntimeStatement getLastStatement() {
            return this.myStatement;
        }
    }
}

