/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Alarm;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StackTreeAction
extends AnAction {
    private TraceContext myContext;
    private final Alarm myAlarm;

    public StackTreeAction(@NotNull TraceContext context) {
        if (context == null) {
            StackTreeAction.$$$reportNull$$$0(0);
        }
        this.myAlarm = new Alarm();
        this.myContext = context;
    }

    public StackTreeAction() {
        this.myAlarm = new Alarm();
    }

    public final void update(AnActionEvent e) {
        this.myAlarm.cancelAllRequests();
        StackTree tree = this.getTree(e);
        if (tree == null) {
            this.myAlarm.addRequest(() -> {
                try {
                    if (!(this.getTree(e) != null || this.myContext != null && this.myContext.isLoadingStackTrace())) {
                        e.getPresentation().setEnabledAndVisible(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 200);
            return;
        }
        SimpleNode selectedNode = tree.getNodeFor(tree.getSelectionPath());
        if (!(selectedNode instanceof StackNode)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (tree.getTraceSettingsManager().isLoaded() && !this.isAvailableForLoadedTrace()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            this.doUpdate(e, tree, (StackNode)selectedNode);
        }
    }

    public final void actionPerformed(AnActionEvent e) {
        StackTree tree = this.getTree(e);
        if (tree == null) {
            return;
        }
        SimpleNode selectedNode = tree.getNodeFor(tree.getSelectionPath());
        if (!(selectedNode instanceof StackNode)) {
            return;
        }
        this.doPerform(e, tree, (StackNode)selectedNode);
    }

    @Nullable
    private StackTree getTree(AnActionEvent e) {
        if (this.myContext == null) {
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            if (!(component instanceof StackTree)) {
                return null;
            }
            return (StackTree)((Object)component);
        }
        return this.myContext.getCurrentStackTree();
    }

    protected void doUpdate(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            StackTreeAction.$$$reportNull$$$0(1);
        }
        if (selectedNode == null) {
            StackTreeAction.$$$reportNull$$$0(2);
        }
    }

    protected abstract void doPerform(AnActionEvent var1, @NotNull StackTree var2, @NotNull StackNode var3);

    protected boolean isAvailableForLoadedTrace() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/stack/actions/StackTreeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

