/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.xml.XmlFoldingBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlTagUtil;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import com.jetbrains.plugins.jade.psi.impl.JadeAttributeImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeCommentImpl;
import com.jetbrains.plugins.jade.psi.impl.JadeMixinDeclarationImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeFoldingBuilder
extends XmlFoldingBuilder {
    @Nullable
    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof XmlTag) {
            ASTNode tagNode = element.getNode();
            XmlToken lastSubelement = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element));
            if (lastSubelement == null) {
                lastSubelement = PsiTreeUtil.findChildOfType((PsiElement)element, JadeAttributeImpl.class);
            }
            if (lastSubelement == null) {
                return null;
            }
            int nameEnd = lastSubelement.getTextRange().getEndOffset();
            int end = tagNode.getTextRange().getEndOffset();
            return new TextRange(nameEnd, end);
        }
        if (element instanceof JadeCommentImpl) {
            TextRange textRange = element.getTextRange();
            int commentStartOffset = JadeFoldingBuilder.getCommentMarkerOffset(element.getNode());
            TextRange result = new TextRange(textRange.getStartOffset() + commentStartOffset, textRange.getEndOffset());
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        if (element instanceof JadeMixinDeclarationImpl) {
            PsiElement nameIdentifier = ((JadeMixinDeclarationImpl)element).getNameIdentifier();
            if (nameIdentifier == null) {
                return null;
            }
            int nameEnd = nameIdentifier.getTextRange().getEndOffset();
            int end = element.getTextRange().getEndOffset();
            return new TextRange(nameEnd, end);
        }
        return null;
    }

    protected void doAddForChildren(XmlElement tag, List<FoldingDescriptor> foldings, Document document) {
        for (PsiElement element : tag.getChildren()) {
            IElementType type = element.getNode().getElementType();
            if (type != JadeElementTypes.MIXIN_DECLARATION && type != JadeElementTypes.COMMENT) continue;
            this.addToFold(foldings, element, document);
        }
        super.doAddForChildren(tag, foldings, document);
    }

    public String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            JadeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JadeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (node.getElementType() == JadeElementTypes.COMMENT) {
            return JadeFoldingBuilder.getPlaceholderForComment(node);
        }
        return super.getPlaceholderText(node);
    }

    @Nullable
    private static String getPlaceholderForComment(@NotNull ASTNode node) {
        if (node == null) {
            JadeFoldingBuilder.$$$reportNull$$$0(2);
        }
        int offset = JadeFoldingBuilder.getCommentMarkerOffset(node);
        String leafText = node.getText();
        StringTokenizer st = new StringTokenizer(leafText.substring(offset).trim(), "\n");
        if (!st.hasMoreTokens()) {
            return null;
        }
        return ' ' + st.nextToken() + (st.hasMoreTokens() ? "..." : "");
    }

    private static int getCommentMarkerOffset(@NotNull ASTNode node) {
        ASTNode leaf;
        if (node == null) {
            JadeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if ((leaf = node.getFirstChildNode()) == null) {
            return 0;
        }
        if (leaf.getElementType() == JadeTokenTypes.COMMENT) {
            return 2;
        }
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/jade/folding/JadeFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPlaceholderForComment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentMarkerOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

