/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.highlighter;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.html.TemplateHtmlScriptContentProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.plugins.jade.highlighter.JadeHighlighter;
import com.jetbrains.plugins.jade.highlighter.JadeSyntaxHighlighter;
import com.jetbrains.plugins.jade.js.JavaScriptInJadeLanguageDialect;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddingUtil;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private static final EmbeddedTokenTypesProvider[] ourEmbeddedTokenTypesProviders = (EmbeddedTokenTypesProvider[])Extensions.getExtensions((ExtensionPointName)EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME);

    public JadeEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            JadeEditorHighlighter.$$$reportNull$$$0(0);
        }
        super((SyntaxHighlighter)new JadeSyntaxHighlighter(CodeStyleSettingsManager.getSettings((Project)project)), colors);
        this.registerHTMLLayer(project, virtualFile);
        this.registerCSSLayer(project, virtualFile);
        this.registerJSLayers(project, virtualFile);
        this.registerEmbeddedTokenTypeProviderLayers(project, virtualFile);
    }

    private void registerEmbeddedTokenTypeProviderLayers(Project project, VirtualFile virtualFile) {
        for (EmbeddedTokenTypesProvider provider : ourEmbeddedTokenTypesProviders) {
            IElementType embeddedTokenType = provider.getElementType();
            Language language = embeddedTokenType.getLanguage();
            this.registerLayer(project, virtualFile, language, embeddedTokenType);
            this.registerLayer(project, virtualFile, language, JadeEmbeddingUtil.getEmbeddedTokenWrapperType(embeddedTokenType));
        }
    }

    private void registerJSLayers(Project project, VirtualFile virtualFile) {
        SyntaxHighlighter jsHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)JavaScriptInJadeLanguageDialect.INSTANCE, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor jsLayer = new LayerDescriptor(jsHighlighter, "\n", JadeHighlighter.JS_BLOCK);
        for (IElementType tokenType : JadeTokenTypes.JS_TOKENS.getTypes()) {
            this.registerLayer(tokenType, jsLayer);
        }
    }

    private void registerCSSLayer(Project project, VirtualFile virtualFile) {
        this.registerLayer(project, virtualFile, (Language)CSSLanguage.INSTANCE, JadeTokenTypes.STYLE_BLOCK);
        this.registerLayer(project, virtualFile, (Language)CSSLanguage.INSTANCE, JadeEmbeddingUtil.getEmbeddedTokenWrapperType(JadeTokenTypes.STYLE_BLOCK));
    }

    private void registerHTMLLayer(Project project, VirtualFile virtualFile) {
        TemplateHtmlScriptContentProvider provider = new TemplateHtmlScriptContentProvider();
        this.registerLayer(project, virtualFile, provider.getScriptElementType().getLanguage(), provider.getScriptElementType());
    }

    private void registerLayer(Project project, VirtualFile virtualFile, Language language, IElementType tokenType) {
        SyntaxHighlighter cssHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor cssLayer = new LayerDescriptor(cssHighlighter, "\n");
        this.registerLayer(tokenType, cssLayer);
    }

    public Lexer getLexer() {
        return super.getLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/jetbrains/plugins/jade/highlighter/JadeEditorHighlighter", "<init>"));
    }
}

