/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.highlighter;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;

public class JadeHighlighter {
    public static final TextAttributesKey COMMENT = JadeHighlighter.create("COMMENT", DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey UNBUF_COMMENT = JadeHighlighter.create("UNBUF_COMMENT", DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey DOCTYPE_KEYWORD = JadeHighlighter.create("DOCTYPE", DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey KEYWORD = JadeHighlighter.create("KEYWORD", DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey TEXT = JadeHighlighter.create("TEXT", DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey TAG_NAME = JadeHighlighter.create("TAG_NAME", XmlHighlighterColors.HTML_TAG_NAME);
    public static final TextAttributesKey ATTRIBUTE_NAME = JadeHighlighter.create("ATTRIBUTE_NAME", XmlHighlighterColors.HTML_ATTRIBUTE_NAME);
    public static final TextAttributesKey BAD_CHARACTER = JadeHighlighter.create("BAD_CHARACTER", HighlighterColors.BAD_CHARACTER);
    public static final TextAttributesKey TAG_ID = JadeHighlighter.create("TAG_ID", XmlHighlighterColors.HTML_ATTRIBUTE_NAME);
    public static final TextAttributesKey TAG_CLASS = JadeHighlighter.create("TAG_CLASS", DefaultLanguageHighlighterColors.STATIC_FIELD);
    public static final TextAttributesKey NUMBER = JadeHighlighter.create("NUMBER", DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey PIPE = JadeHighlighter.create("PIPE", DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey COMMA = JadeHighlighter.create("COMMA", DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey PARENTS = JadeHighlighter.create("PARENTS", DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey COLON = JadeHighlighter.create("COLON", DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey OPERATION_SIGN = JadeHighlighter.create("OPERATION_SIGN", DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey STATEMENTS = JadeHighlighter.create("STATEMENTS", DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey FILE_PATH = JadeHighlighter.create("FILE_PATH", DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey FILTER_NAME = JadeHighlighter.create("FILTER_NAME", DefaultLanguageHighlighterColors.LABEL);
    public static final TextAttributesKey JS_BLOCK = JadeHighlighter.create("JS_BLOCK", DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey EMBEDDED_CONTENT = JadeHighlighter.create("EMBEDDED_CONTENT", DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);

    private static TextAttributesKey create(String name, TextAttributesKey origin) {
        return TextAttributesKey.createTextAttributesKey((String)("JADE_" + name), (TextAttributesKey)origin);
    }
}

