/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.lexer;

import com.intellij.embedding.EmbeddedLazyParseableElementType;
import com.intellij.embedding.MasqueradingLexer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.parser.JadeParser;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JadeBaseInterpolationLexer
extends MasqueradingLexer.SmartDelegate {
    private CharSequence myBuffer;
    private int myStartOffset;
    private Set<TextRange> myInterpolations;

    public JadeBaseInterpolationLexer(@NotNull Lexer delegate) {
        if (delegate == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(0);
        }
        super(delegate);
    }

    protected abstract CharSequence getSubstitutionForInterpolation(CharSequence var1, int var2, int var3, TextRange var4);

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        List<TextRange> interpolations = JadeBaseInterpolationLexer.findAllInterpolations(buffer, startOffset, endOffset);
        if (interpolations.isEmpty()) {
            this.myInterpolations = Collections.emptySet();
            super.start(buffer.subSequence(startOffset, endOffset), 0, endOffset - startOffset, initialState);
            return;
        }
        this.myInterpolations = new HashSet<TextRange>(interpolations);
        CharSequence newBuffer = this.substituteInterpolations(buffer, startOffset, endOffset, interpolations);
        super.start(newBuffer, 0, newBuffer.length(), initialState);
    }

    @Nullable
    public IElementType getTokenType() {
        TextRange tokenRange = this.getTokenRange();
        for (TextRange interpolation : this.myInterpolations) {
            if (!tokenRange.contains(interpolation)) continue;
            return InterpolationType.getInstance(super.getTokenType());
        }
        return super.getTokenType();
    }

    @NotNull
    public String getTokenText() {
        TextRange tokenRange = this.getTokenRange();
        String string = this.myBuffer.subSequence(tokenRange.getStartOffset(), tokenRange.getEndOffset()).toString();
        if (string == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(2);
        }
        return string;
    }

    private TextRange getTokenRange() {
        return TextRange.create((int)this.getTokenStart(), (int)this.getTokenEnd()).shiftRight(this.myStartOffset);
    }

    private CharSequence substituteInterpolations(@NotNull CharSequence buffer, int start, int end, @NotNull List<TextRange> interpolations) {
        if (buffer == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(3);
        }
        if (interpolations == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(4);
        }
        assert (!interpolations.isEmpty());
        int startPos = start;
        StringBuilder sb = new StringBuilder();
        for (TextRange interpolation : interpolations) {
            sb.append(buffer.subSequence(startPos, interpolation.getStartOffset()));
            sb.append(this.getSubstitutionForInterpolation(buffer, start, end, interpolation));
            startPos = interpolation.getEndOffset();
        }
        sb.append(buffer.subSequence(startPos, end));
        return sb.toString();
    }

    private static List<TextRange> findAllInterpolations(@NotNull CharSequence buffer, int start, int end) {
        if (buffer == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(5);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        while (start < end && (start = JadeBaseInterpolationLexer.findInterpolationStartPos(buffer, start, end)) < end) {
            int endOfInterpolation = JadeBaseInterpolationLexer.findClosingBraceWithRespectToOpeningOnes(buffer, start + 2, end);
            if (endOfInterpolation < end) {
                result.add(new TextRange(start, endOfInterpolation + 1));
            }
            start = endOfInterpolation + 1;
        }
        return result;
    }

    private static int findInterpolationStartPos(@NotNull CharSequence buffer, int start, int end) {
        if (buffer == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(6);
        }
        int i = start;
        while (i + 2 < end) {
            if (!(buffer.charAt(i) != '#' && buffer.charAt(i) != '!' || buffer.charAt(i + 1) != '{' || i != start && buffer.charAt(i - 1) == '\\')) {
                return i;
            }
            ++i;
        }
        return end;
    }

    private static int findClosingBraceWithRespectToOpeningOnes(@NotNull CharSequence buffer, int startPos, int end) {
        if (buffer == null) {
            JadeBaseInterpolationLexer.$$$reportNull$$$0(7);
        }
        int balance = 1;
        int pos = startPos;
        while (balance > 0 && pos < end) {
            char c;
            if ((c = buffer.charAt(pos++)) == '{') {
                ++balance;
                continue;
            }
            if (c != '}') continue;
            --balance;
        }
        if (balance == 0) {
            return pos - 1;
        }
        return end;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpolations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteInterpolations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAllInterpolations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findInterpolationStartPos";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClosingBraceWithRespectToOpeningOnes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InterpolationType
    extends EmbeddedLazyParseableElementType {
        private static final Map<IElementType, InterpolationType> INSTANCES = new HashMap<IElementType, InterpolationType>();
        @Nullable
        private final IElementType myType;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InterpolationType getInstance(@Nullable IElementType flankingType) {
            if (INSTANCES.containsKey(flankingType)) {
                return INSTANCES.get(flankingType);
            }
            Map<IElementType, InterpolationType> map = INSTANCES;
            synchronized (map) {
                if (!INSTANCES.containsKey(flankingType)) {
                    INSTANCES.put(flankingType, new InterpolationType(flankingType));
                }
            }
            return INSTANCES.get(flankingType);
        }

        private InterpolationType(@Nullable IElementType flankingType) {
            super("INTERPOLATION", (Language)JadeLanguage.INSTANCE);
            this.myType = flankingType;
        }

        public Lexer createLexer(@NotNull ASTNode chameleon, @NotNull Project project, @NotNull Language parentLanguage) {
            if (chameleon == null) {
                InterpolationType.$$$reportNull$$$0(0);
            }
            if (project == null) {
                InterpolationType.$$$reportNull$$$0(1);
            }
            if (parentLanguage == null) {
                InterpolationType.$$$reportNull$$$0(2);
            }
            return new MyLexer(this.myType);
        }

        public ASTNode parseAndGetTree(@NotNull PsiBuilder builder) {
            if (builder == null) {
                InterpolationType.$$$reportNull$$$0(3);
            }
            PsiBuilder.Marker marker = builder.mark();
            while (!builder.eof()) {
                IElementType type = builder.getTokenType();
                if (type == JadeTokenTypes.TEXT) {
                    JadeParser.parsePlainTextLine(builder);
                    continue;
                }
                builder.advanceLexer();
            }
            marker.done((IElementType)this);
            return builder.getTreeBuilt();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chameleon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentLanguage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLexer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseAndGetTree";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyLexer
        extends LexerBase {
            private final IElementType myType;
            private int myLeft;
            private int myRight;
            private CharSequence myBuffer;
            private int myStartOffset;
            private int myEndOffset;
            private int myState;

            public MyLexer(IElementType type) {
                this.myType = type;
            }

            public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
                if (buffer == null) {
                    MyLexer.$$$reportNull$$$0(0);
                }
                this.myBuffer = buffer;
                this.myStartOffset = startOffset;
                this.myEndOffset = endOffset;
                this.myState = initialState;
                boolean foundFirstInterpolation = this.findInterpolationAndInitLeftAndRight(this.myStartOffset);
                assert (foundFirstInterpolation) : "could not be invoked w/o interpolation";
                this.adjustState();
            }

            private boolean findInterpolationAndInitLeftAndRight(int from) {
                int start = JadeBaseInterpolationLexer.findInterpolationStartPos(this.myBuffer, from, this.myEndOffset);
                if (start >= this.myEndOffset) {
                    return false;
                }
                int end = JadeBaseInterpolationLexer.findClosingBraceWithRespectToOpeningOnes(this.myBuffer, start + 2, this.myEndOffset);
                if (end >= this.myEndOffset) {
                    return false;
                }
                this.myLeft = start - this.myStartOffset;
                this.myRight = this.myEndOffset - end - 1;
                return true;
            }

            public int getState() {
                return this.myState;
            }

            @Nullable
            public IElementType getTokenType() {
                switch (this.myState) {
                    case 0: {
                        return this.myType;
                    }
                    case 1: 
                    case 3: {
                        return JadeTokenTypes.TEXT;
                    }
                    case 2: {
                        return JadeTokenTypes.JS_EXPR;
                    }
                    case 4: {
                        return this.myType;
                    }
                }
                return null;
            }

            public int getTokenStart() {
                switch (this.myState) {
                    case 0: {
                        return this.myStartOffset;
                    }
                    case 1: {
                        return this.myStartOffset + this.myLeft;
                    }
                    case 2: {
                        return this.myStartOffset + this.myLeft + 2;
                    }
                    case 3: {
                        return this.myEndOffset - this.myRight - 1;
                    }
                    case 4: {
                        return this.myEndOffset - this.myRight;
                    }
                }
                return this.myEndOffset;
            }

            public int getTokenEnd() {
                switch (this.myState) {
                    case 0: {
                        return this.myStartOffset + this.myLeft;
                    }
                    case 1: {
                        return this.myStartOffset + this.myLeft + 2;
                    }
                    case 2: {
                        return this.myEndOffset - this.myRight - 1;
                    }
                    case 3: {
                        return this.myEndOffset - this.myRight;
                    }
                    case 4: {
                        return this.myEndOffset;
                    }
                }
                return this.myEndOffset;
            }

            public void advance() {
                ++this.myState;
                if (this.myState == 4) {
                    this.myStartOffset = this.myEndOffset - this.myRight;
                    boolean foundNextInterpolation = this.findInterpolationAndInitLeftAndRight(this.myStartOffset);
                    if (foundNextInterpolation) {
                        this.myState = 0;
                    }
                }
                this.adjustState();
            }

            private void adjustState() {
                if (this.myState == 0 && this.myLeft == 0 || this.myState == 4 && this.myRight == 0) {
                    ++this.myState;
                }
            }

            @NotNull
            public CharSequence getBufferSequence() {
                CharSequence charSequence = this.myBuffer;
                if (charSequence == null) {
                    MyLexer.$$$reportNull$$$0(1);
                }
                return charSequence;
            }

            public int getBufferEnd() {
                return this.myEndOffset;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buffer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType$MyLexer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeBaseInterpolationLexer$InterpolationType$MyLexer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBufferSequence";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

