/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.lexer;

import com.intellij.embedding.EmbeddedLazyParseableElementType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.HtmlScriptContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageHtmlScriptContentProvider;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lexer.DummyLexer;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.CssStylesheetLazyElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddedTokenTypesWrapper;
import com.jetbrains.plugins.jade.lexer.JadeEmbeddedTokenTypesWrapperForCssStylesheet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeEmbeddingUtil {
    private static final EmbeddedTokenTypesProvider[] ourEmbeddedTokenTypesProviders = (EmbeddedTokenTypesProvider[])Extensions.getExtensions((ExtensionPointName)EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME);
    private static final Map<IElementType, IElementType> ourWrappersForEmbeddedTypes = ContainerUtil.newConcurrentMap();
    private static final IElementType XML_DATA_CHARACTERS_LAZY_TYPE = new DummyEmbeddedType("XML_DATA_CHARACTERS", XmlTokenType.XML_DATA_CHARACTERS);

    public static IElementType getEmbeddedTokenWrapperType(IElementType embeddedTokenType) {
        IElementType cached = ourWrappersForEmbeddedTypes.get(embeddedTokenType);
        if (cached != null) {
            return cached;
        }
        Object result = embeddedTokenType instanceof CssStylesheetLazyElementType ? new JadeEmbeddedTokenTypesWrapperForCssStylesheet((CssStylesheetLazyElementType)embeddedTokenType) : new JadeEmbeddedTokenTypesWrapper(embeddedTokenType);
        ourWrappersForEmbeddedTypes.put(embeddedTokenType, (IElementType)result);
        return result;
    }

    public static TokenSet getAllEmbeddedWrapperTypes() {
        IElementType[] types = new IElementType[ourEmbeddedTokenTypesProviders.length];
        for (int i = 0; i < ourEmbeddedTokenTypesProviders.length; ++i) {
            types[i] = JadeEmbeddingUtil.getEmbeddedTokenWrapperType(ourEmbeddedTokenTypesProviders[i].getElementType());
        }
        return TokenSet.create((IElementType[])types);
    }

    @Nullable
    public static IElementType getElementToEmbedForATag(@Nullable String tagName, @Nullable Map<String, String> attributes) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"script")) {
            return null;
        }
        if (attributes == null || !attributes.containsKey("type")) {
            return null;
        }
        String mimeType = JadeEmbeddingUtil.sanitizeAttrValue(attributes.get("type"));
        if (StringUtil.isEmpty((String)mimeType)) {
            return null;
        }
        List<HTMLLanguage> instancesByMimeType = Language.findInstancesByMimeType((String)mimeType.trim());
        if (instancesByMimeType.isEmpty() && mimeType.contains("template")) {
            instancesByMimeType = Collections.singletonList(HTMLLanguage.INSTANCE);
        }
        IElementType result = null;
        for (Language language : instancesByMimeType) {
            HtmlScriptContentProvider scriptContentProvider = LanguageHtmlScriptContentProvider.getScriptContentProvider((Language)language);
            if (scriptContentProvider == null) continue;
            if (result != null) {
                Logger.getInstance(JadeEmbeddingUtil.class).warn("Multiple script content providers for a type: " + mimeType);
            }
            result = scriptContentProvider.getScriptElementType();
        }
        if (result == null) {
            result = XML_DATA_CHARACTERS_LAZY_TYPE;
        }
        return result;
    }

    @Nullable
    public static IElementType getElementToEmbedForFilterName(String filterName) {
        for (EmbeddedTokenTypesProvider embeddedTokenTypesProvider : ourEmbeddedTokenTypesProviders) {
            if (!filterName.startsWith(embeddedTokenTypesProvider.getName())) continue;
            return embeddedTokenTypesProvider.getElementType();
        }
        return null;
    }

    @Nullable
    @Contract(value="!null -> !null")
    private static String sanitizeAttrValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 2) {
            return value;
        }
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static class DummyEmbeddedType
    extends EmbeddedLazyParseableElementType {
        @NotNull
        private final IElementType myTokenType;

        public DummyEmbeddedType(@NotNull @NonNls String debugName, @NotNull IElementType containingTokenType) {
            if (debugName == null) {
                DummyEmbeddedType.$$$reportNull$$$0(0);
            }
            if (containingTokenType == null) {
                DummyEmbeddedType.$$$reportNull$$$0(1);
            }
            super(debugName, containingTokenType.getLanguage());
            this.myTokenType = containingTokenType;
        }

        public Lexer createLexer(@NotNull ASTNode chameleon, @NotNull Project project, @NotNull Language parentLanguage) {
            if (chameleon == null) {
                DummyEmbeddedType.$$$reportNull$$$0(2);
            }
            if (project == null) {
                DummyEmbeddedType.$$$reportNull$$$0(3);
            }
            if (parentLanguage == null) {
                DummyEmbeddedType.$$$reportNull$$$0(4);
            }
            return new DummyLexer(this.myTokenType);
        }

        public ASTNode parseAndGetTree(@NotNull PsiBuilder builder) {
            if (builder == null) {
                DummyEmbeddedType.$$$reportNull$$$0(5);
            }
            PsiBuilder.Marker marker = builder.mark();
            while (!builder.eof()) {
                builder.advanceLexer();
            }
            marker.done((IElementType)this);
            return builder.getTreeBuilt();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingTokenType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chameleon";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentLanguage";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/jade/lexer/JadeEmbeddingUtil$DummyEmbeddedType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseAndGetTree";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

