/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.xml.XmlDoctypeImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.plugins.jade.JadeLanguage;
import com.jetbrains.plugins.jade.psi.JadeTokenTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeDoctypeImpl
extends XmlDoctypeImpl
implements XmlProlog {
    private static final Map<String, String> URIS = new HashMap<String, String>();

    @Nullable
    public String getDtdUri() {
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        return URIS.get(value.toLowerCase());
    }

    @Nullable
    private String getValue() {
        ASTNode node = this.getUrlNode();
        return node != null ? node.getText() : null;
    }

    private ASTNode getUrlNode() {
        return this.getNode().findChildByType(TokenSet.create((IElementType[])new IElementType[]{JadeTokenTypes.NUMBER, XmlElementType.XML_TEXT, XmlTokenType.XML_DATA_CHARACTERS}));
    }

    @Nullable
    protected PsiReference createUrlReference(PsiElement dtdUrlElement) {
        ASTNode node = this.getUrlNode();
        if (node == null) {
            return null;
        }
        TextRange textRange = TextRange.from((int)node.getPsi().getStartOffsetInParent(), (int)node.getTextLength());
        return new PsiReferenceBase.Immediate<PsiElement>(dtdUrlElement, textRange, (PsiElement)this){

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = ArrayUtil.toObjectArray(URIS.keySet());
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/psi/impl/JadeDoctypeImpl$1", "getVariants"));
            }
        };
    }

    public XmlElement getDtdUrlElement() {
        return this;
    }

    public XmlElement getNameElement() {
        return this;
    }

    public XmlDoctype getDoctype() {
        return this;
    }

    @NotNull
    public Language getLanguage() {
        JadeLanguage jadeLanguage = JadeLanguage.INSTANCE;
        if (jadeLanguage == null) {
            JadeDoctypeImpl.$$$reportNull$$$0(0);
        }
        return jadeLanguage;
    }

    static {
        URIS.put("5", null);
        URIS.put("default", null);
        URIS.put("xml", null);
        URIS.put("transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        URIS.put("strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        URIS.put("frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        URIS.put("1.1", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        URIS.put("basic", "http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd");
        URIS.put("mobile", "http://www.openmobilealliance.org/tech/DTD/xhtml-mobile12.dtd");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/jade/psi/impl/JadeDoctypeImpl", "getLanguage"));
    }
}

