/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.jade.watcher;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.jetbrains.plugins.jade.JadeToPugTransitionHelper;
import com.jetbrains.plugins.jade.psi.JadeElementTypes;
import com.jetbrains.plugins.jade.psi.JadeFileImpl;
import com.jetbrains.plugins.jade.psi.JadeFileType;
import com.jetbrains.plugins.jade.psi.impl.JadeIncludeStatementImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("jade" == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(0);
        }
        return "jade";
    }

    public boolean acceptFile(VirtualFile file) {
        return file.getFileType() instanceof JadeFileType;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(1);
        }
        fileTypeSink.consume((Object)JadeFileType.INSTANCE);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile instanceof JadeFileImpl) {
            FileIncludeInfo[] fileIncludeInfoArray = JadeFileIncludeProvider.getIncludeInfos((JadeFileImpl)psiFile);
            if (fileIncludeInfoArray == null) {
                JadeFileIncludeProvider.$$$reportNull$$$0(2);
            }
            return fileIncludeInfoArray;
        }
        if (FileIncludeInfo.EMPTY == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(3);
        }
        return FileIncludeInfo.EMPTY;
    }

    private static FileIncludeInfo[] getIncludeInfos(JadeFileImpl file) {
        final ArrayList result = new ArrayList();
        final String fileExtension = "." + JadeToPugTransitionHelper.getExtension((PsiFile)file);
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof JadeIncludeStatementImpl) {
                    String path = JadeFileIncludeProvider.extractPath(fileExtension, (JadeIncludeStatementImpl)element);
                    if (path != null) {
                        result.add(new FileIncludeInfo(path));
                    }
                } else {
                    super.visitElement(element);
                }
            }
        });
        return (FileIncludeInfo[])ContainerUtil.toArray(result, (Object[])FileIncludeInfo.EMPTY);
    }

    @Nullable
    private static String extractPath(@NotNull String fileExtension, @NotNull JadeIncludeStatementImpl includeStatement) {
        PsiElement[] children;
        if (fileExtension == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(4);
        }
        if (includeStatement == null) {
            JadeFileIncludeProvider.$$$reportNull$$$0(5);
        }
        for (PsiElement child : children = includeStatement.getChildren()) {
            ASTNode node;
            if (!(child instanceof ASTNode) || (node = (ASTNode)child).getElementType() != JadeElementTypes.FILE_PATH) continue;
            String path = child.getText();
            if (!path.endsWith(fileExtension)) {
                path = path + fileExtension;
            }
            return path;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/jade/watcher/JadeFileIncludeProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

