/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.impl.util.completion.CssAddSpaceWithBracesInsertHandler;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.css.util.CssEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssAtKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            CssAtKeywordsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CssAtKeywordsCompletionProvider.$$$reportNull$$$0(1);
        }
        boolean indentBased = CssPsiUtil.isIndentBasedCssLanguage((PsiElement)parameters.getPosition());
        String declarationsTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)parameters.getPosition());
        CssAddSpaceWithBracesInsertHandler addSpaceWithBracesInsertHandler = new CssAddSpaceWithBracesInsertHandler(indentBased);
        AddBracesInsertHandler addBracesInsertHandler = new AddBracesInsertHandler(indentBased);
        AddQuotesInsertHandler addQuotesInsertHandler = new AddQuotesInsertHandler(declarationsTerminator);
        AddSpaceParensAndBracesInsertHandler addSpaceParensAndBracesInsertHandler = new AddSpaceParensAndBracesInsertHandler(indentBased);
        CssAtKeywordsCompletionProvider.addKeywords(result, addSpaceWithBracesInsertHandler, "@page", "@media", "@region", "@counter-style", "@-webkit-region", "@keyframes", "@-o-keyframes", "@-moz-keyframes", "@-ms-keyframes", "@-webkit-keyframes", "@-khtml-keyframes", "@scope", "@document", "@-moz-document");
        CssAtKeywordsCompletionProvider.addKeywords(result, addBracesInsertHandler, "@viewport", "@-o-viewport", "@-ms-viewport", "@font-face");
        CssAtKeywordsCompletionProvider.addKeywords(result, addQuotesInsertHandler, "@import", "@charset");
        CssAtKeywordsCompletionProvider.addKeywords(result, addSpaceParensAndBracesInsertHandler, "@supports");
        CssAtKeywordsCompletionProvider.addKeywords(result, null, "@apply");
        CssElement parentRuleset = (CssElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), (Class[])new Class[]{CssRuleset.class, CssAtRule.class});
        if (parentRuleset instanceof CssAtRule && ((CssAtRule)parentRuleset).getType() == CssContextType.UNKNOWN) {
            parentRuleset = (CssElement)PsiTreeUtil.getParentOfType((PsiElement)parentRuleset, (Class[])new Class[]{CssRuleset.class, CssAtRule.class});
        }
        if (parentRuleset instanceof CssAtRule && ((CssAtRule)parentRuleset).getType() == CssContextType.PAGE) {
            CssAtKeywordsCompletionProvider.addKeywords(result, addBracesInsertHandler, CssContextType.PAGE_MARGIN_RULES);
        }
    }

    private static void addKeywords(@NotNull CompletionResultSet result, @Nullable InsertHandler<LookupElement> insertHandler, String ... lookupStrings) {
        if (result == null) {
            CssAtKeywordsCompletionProvider.$$$reportNull$$$0(2);
        }
        if (lookupStrings == null) {
            CssAtKeywordsCompletionProvider.$$$reportNull$$$0(3);
        }
        for (String lookupString : lookupStrings) {
            result.addElement(CssCompletionUtil.lookupForKeyword(lookupString, insertHandler));
        }
    }

    private static String getIndentString(InsertionContext context) {
        int indentSize = CodeStyle.getIndentSize((PsiFile)context.getFile());
        return StringUtil.repeat((String)" ", (int)indentSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStrings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AddQuotesInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        private final String myDeclarationsTerminator;

        public AddQuotesInsertHandler(@NotNull String declarationsTerminator) {
            if (declarationsTerminator == null) {
                AddQuotesInsertHandler.$$$reportNull$$$0(0);
            }
            this.myDeclarationsTerminator = declarationsTerminator;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            CssEditorUtil.typeOrMove(editor, ' ');
            CharSequence sequence = editor.getDocument().getCharsSequence();
            int offset = CssEditorUtil.skipWhiteSpaces(editor, editor.getCaretModel().getOffset());
            if (sequence.charAt(offset) != '\"') {
                String quotes = "\"\"";
                if (!(this.myDeclarationsTerminator.isEmpty() || sequence.length() >= offset + this.myDeclarationsTerminator.length() && sequence.subSequence(offset, offset + this.myDeclarationsTerminator.length()).toString().equals(this.myDeclarationsTerminator))) {
                    quotes = quotes + this.myDeclarationsTerminator;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)quotes, (boolean)false, (boolean)false);
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            } else {
                editor.getCaretModel().moveToOffset(offset + 1);
            }
            AutoPopupController.getInstance((Project)editor.getProject()).autoPopupMemberLookup(editor, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsTerminator", "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider$AddQuotesInsertHandler", "<init>"));
        }
    }

    private static class AddSpaceParensAndBracesInsertHandler
    implements InsertHandler<LookupElement> {
        private final boolean myIndentBased;

        public AddSpaceParensAndBracesInsertHandler(boolean indentBased) {
            this.myIndentBased = indentBased;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            String indentString = CssAtKeywordsCompletionProvider.getIndentString(context);
            if (this.myIndentBased) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(" ()\n" + indentString), (boolean)false, (int)2);
            } else {
                int offset = CssEditorUtil.skipWhiteSpaces(editor, editor.getCaretModel().getOffset());
                if (editor.getDocument().getCharsSequence().charAt(offset) != '{') {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" () {\n}", (boolean)false, (int)2);
                    AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(editor);
                }
            }
        }
    }

    private static class AddBracesInsertHandler
    implements InsertHandler<LookupElement> {
        private final boolean myIndentBased;

        public AddBracesInsertHandler(boolean indentBased) {
            this.myIndentBased = indentBased;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            if (this.myIndentBased) {
                String indentString = CssAtKeywordsCompletionProvider.getIndentString(context);
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + indentString));
            } else {
                int offset = CssEditorUtil.skipWhiteSpaces(editor, editor.getCaretModel().getOffset());
                if (editor.getDocument().getCharsSequence().charAt(offset) != '{') {
                    Project project = editor.getProject();
                    Template template = TemplateManager.getInstance((Project)project).createTemplate("css_insert_handler_template", "css", " {\n$END$\n}");
                    template.setToReformat(true);
                    TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                }
            }
        }
    }
}

