/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class CucumberJavaScriptStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final List<String> FORBIDDEN_STEP_KEYWORD = Arrays.asList("And", "But", "*");
    private static final String JAVASCRIPT_FILE_EXTENSION = '.' + JavaScriptFileType.INSTANCE.getDefaultExtension();
    private static final String DEFAULT_ARGUMENT_NAME = "arg";
    public static final String STRING_ARGUMENT_REGEX = "(\"[^\"]*\")";
    public static final String NUMBER_ARGUMENT_REGEX = "(?:^|[ ])(\\d+)(?:[ ]|$)";
    private static final Pattern PARAM_REGEXP = Pattern.compile("(\"[^\"]*\")|(?:^|[ ])(\\d+)(?:[ ]|$)");

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = (PsiFile)WriteAction.compute(() -> {
            if (dir == null) {
                CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(14);
            }
            if (name == null) {
                CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(15);
            }
            return dir.createFile(name + JAVASCRIPT_FILE_EXTENSION);
        });
        if (psiFile == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @Nullable
    protected JSBlockStatement findWrapper(JSFile jsFile) {
        for (JSSourceElement st : jsFile.getStatements()) {
            JSExpression varInitializer;
            JSVariable[] variables;
            if (!(st instanceof JSVarStatement) || (variables = ((JSVarStatement)st).getVariables()).length != 1 || !((varInitializer = variables[0].getInitializer()) instanceof JSFunction) || !(varInitializer.getLastChild() instanceof JSBlockStatement)) continue;
            return (JSBlockStatement)varInitializer.getLastChild();
        }
        return null;
    }

    private PsiElement generateStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        String keyword;
        if (step == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (FORBIDDEN_STEP_KEYWORD.contains(step.getKeyword().getText())) {
            PsiElement prevStep = step.getPrevSibling();
            while (prevStep instanceof GherkinStep && FORBIDDEN_STEP_KEYWORD.contains(((GherkinStep)prevStep).getKeyword().getText()) || prevStep instanceof PsiWhiteSpace) {
                prevStep = prevStep.getPrevSibling();
            }
            keyword = prevStep instanceof GherkinStep ? ((GherkinStep)prevStep).getKeyword().getText() : "Given";
        } else {
            keyword = step.getKeyword().getText();
        }
        String template = this.getStepDefinitionTemplate();
        String params = CucumberJavaScriptStepDefinitionCreator.getArguments(step);
        String stepRegex = CucumberJavaScriptStepDefinitionCreator.getStepRegex(step);
        String elementText = String.format(template, keyword, stepRegex, params);
        ASTNode expression = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)elementText, (JSLanguageDialect)JSUtils.getDialect((PsiFile)file));
        return expression.getPsi();
    }

    @NotNull
    protected String getStepDefinitionTemplate() {
        if ("this.%s(/^%s$/, function (%scallback) {\n  callback.pending();\n});\n" == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        return "this.%s(/^%s$/, function (%scallback) {\n  callback.pending();\n});\n";
    }

    private static String getStepRegex(GherkinStep step) {
        String result = step.getStepName();
        result = CucumberUtil.prepareStepRegexp((String)result);
        return result;
    }

    private static String getArguments(GherkinStep step) {
        String result;
        ArrayList<String> arguments = new ArrayList<String>();
        Matcher m = PARAM_REGEXP.matcher(step.getStepName());
        int i = 0;
        while (m.find()) {
            String argument = m.group();
            if (argument.startsWith("<")) {
                arguments.add(argument.substring(1, argument.length() - 1));
                continue;
            }
            arguments.add(DEFAULT_ARGUMENT_NAME + ++i);
        }
        if (step.getPystring() != null) {
            arguments.add("text");
        }
        if ((result = StringUtil.join(arguments, (String)", ")).length() > 0) {
            result = result + ", ";
        }
        return result;
    }

    @NotNull
    protected JSBlockStatement createStepDefsWrapper(@NotNull PsiFile file) {
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        String text = "var myStepDefinitionsWrapper = function () {\n};";
        ASTNode varStatementNode = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)"var myStepDefinitionsWrapper = function () {\n};", (JSLanguageDialect)JSUtils.getDialect((PsiFile)file));
        JSVarStatement varStatement = (JSVarStatement)varStatementNode.getPsi();
        varStatement = (JSVarStatement)file.add((PsiElement)varStatement);
        String exportModuleText = "module.exports = myStepDefinitionsWrapper;";
        ASTNode exportModuleNode = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)"module.exports = myStepDefinitionsWrapper;", (JSLanguageDialect)JSUtils.getDialect((PsiFile)file));
        PsiElement exportModuleElement = exportModuleNode.getPsi();
        file.add(exportModuleElement);
        JSVariable variable = varStatement.getVariables()[0];
        JSBlockStatement jSBlockStatement = (JSBlockStatement)variable.getInitializer().getLastChild();
        if (jSBlockStatement == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        return jSBlockStatement;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        PsiElement stepDefinition;
        if (step == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(9);
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        this.closeActiveTemplateBuilders(file);
        JSBlockStatement stepDefContainer = this.findWrapper((JSFile)file);
        if (stepDefContainer == null) {
            stepDefContainer = this.createStepDefsWrapper(file);
        }
        if ((stepDefinition = this.generateStepDefinition(step, file)) != null) {
            stepDefinition = JSChangeUtil.doAddBefore((PsiElement)stepDefContainer, (PsiElement)stepDefinition, (PsiElement)stepDefContainer.getLastChild());
            CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(stepDefContainer.getNode(), stepDefinition.getNode());
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            assert (editor != null);
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(stepDefinition);
            JSCallExpression callExpression = (JSCallExpression)stepDefinition.getFirstChild();
            JSExpression[] argumentList = callExpression.getArguments();
            if (argumentList.length > 1) {
                JSExpressionStatement pendingElement;
                JSSourceElement[] body;
                JSExpression stepFunction;
                JSExpression regex = argumentList[0];
                if (regex.getTextLength() > 4) {
                    TextRange regexRange = new TextRange(2, regex.getTextLength() - 2);
                    builder.replaceElement((PsiElement)regex, regexRange, regexRange.substring(regex.getText()));
                }
                if ((stepFunction = argumentList[1]) instanceof JSFunction && (body = ((JSFunction)stepFunction).getBody()).length > 0 && (pendingElement = (JSExpressionStatement)Arrays.stream(body[0].getChildren()).filter(x -> x instanceof JSExpressionStatement).findFirst().orElse(null)) != null) {
                    TextRange pendingRange = new TextRange(0, pendingElement.getTextLength() - 1);
                    builder.replaceElement((PsiElement)pendingElement, pendingRange, pendingRange.substring(pendingElement.getText()));
                }
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            builder.run(editor, false);
        }
        return false;
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(11);
        }
        return true;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(12);
        }
        if ("my_steps" == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(13);
        }
        return "my_steps";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefsWrapper";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateStepDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefsWrapper";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createStepDefinitionContainer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

