/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptBundle;

public class CucumberJavaScriptUtil {
    @NonNls
    static final String jarPath = PathUtil.getJarPathForClass(CucumberJavaScriptUtil.class);
    @NonNls
    public static final String STEP_DEFINITIONS_DIR_NAME = "step_definitions";
    public static final String FORMATTER_FILE_NAME = "cucumberjs_formatter.js";
    public static final String FORMATTER_FILE_NAME_2 = "cucumberjs_formatter_v2.js";
    private static final String REQUIRE_CALL = "require";
    private static final String CUCUMBER_MODULE_NAME = "cucumber";
    public static final String CUCUMBER_PACKAGE_NAME = "cucumber";
    private static final String CUCUMBER_PACKAGE_DIR_KEY = "nodejs.cucumber.cucumber_node_package_dir";
    public static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor(new String[]{"cucumber", CucumberJavaScriptBundle.message("cucumber.js.package.placeholder.text", new Object[0])});

    public static boolean isStepDefinitionsRoot(VirtualFile stepDefsRoot) {
        return stepDefsRoot.isDirectory() && STEP_DEFINITIONS_DIR_NAME.equals(stepDefsRoot.getName());
    }

    public static String getFormatterPath() {
        return CucumberJavaScriptUtil.getFilePath(FORMATTER_FILE_NAME);
    }

    public static String getV2FormatterPath() {
        return CucumberJavaScriptUtil.getFilePath(FORMATTER_FILE_NAME_2);
    }

    public static boolean isV2StepDefinitionFile(JSFile jsFile) {
        String fileText = jsFile.getText();
        if (StringUtil.isEmpty((String)fileText)) {
            return true;
        }
        if (!fileText.contains(REQUIRE_CALL) || !fileText.contains("cucumber")) {
            return false;
        }
        Collection calls = PsiTreeUtil.findChildrenOfType((PsiElement)jsFile, JSCallExpression.class);
        for (JSCallExpression call : calls) {
            String requiredModule;
            if (!call.isRequireCall() || !StringUtil.equals((CharSequence)(requiredModule = CommonJSUtil.getRequireCallModulePath((JSCallExpression)call)), (CharSequence)"cucumber")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String getFilePath(String name) {
        File jarFile = new File(jarPath);
        if (jarPath.endsWith(".jar")) {
            String string = FileUtil.toSystemIndependentName((String)(jarFile.getParentFile() + "/" + name));
            if (string == null) {
                CucumberJavaScriptUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = FileUtil.toSystemIndependentName((String)(jarFile.getParentFile() + "/CucumberJavaScript/org/jetbrains/plugins/cucumber/javascript/run/" + name));
        if (string == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static NodePackage getCucumberPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        NodePackage defaultPackage;
        String packageDir;
        if (project == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(2);
        }
        if ((packageDir = PropertiesComponent.getInstance((Project)project).getValue(CUCUMBER_PACKAGE_DIR_KEY)) == null && !(defaultPackage = NodePackage.findPreferredPackage((Project)project, (String)"cucumber", (NodeJsInterpreter)interpreter)).getSystemIndependentPath().isEmpty()) {
            CucumberJavaScriptUtil.setCucumberPackage(project, defaultPackage);
            NodePackage nodePackage = defaultPackage;
            if (nodePackage == null) {
                CucumberJavaScriptUtil.$$$reportNull$$$0(3);
            }
            return nodePackage;
        }
        NodePackage nodePackage = new NodePackage(StringUtil.notNullize((String)packageDir));
        if (nodePackage == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(4);
        }
        return nodePackage;
    }

    public static void setCucumberPackage(@NotNull Project project, @NotNull NodePackage cucumberPackage) {
        if (project == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(5);
        }
        if (cucumberPackage == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(6);
        }
        PropertiesComponent.getInstance((Project)project).setValue(CUCUMBER_PACKAGE_DIR_KEY, cucumberPackage.getSystemIndependentPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCucumberPackage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberPackage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCucumberPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

