/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfiguration;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfigurationType;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;

public class CucumberJavaScriptRunConfigurationProducer
extends RunConfigurationProducer<CucumberJavaScriptRunConfiguration>
implements Cloneable {
    public static final String FEATURES_FOLDER_NAME = "features";

    protected CucumberJavaScriptRunConfigurationProducer() {
        super((ConfigurationType)CucumberJavaScriptRunConfigurationType.getInstance());
    }

    private static boolean hasParentCalledFeatures(PsiDirectory directory) {
        while (directory != null) {
            if (directory.getName().equals(FEATURES_FOLDER_NAME)) {
                return true;
            }
            directory = directory.getParentDirectory();
        }
        return false;
    }

    @NotNull
    private static String getFileToRun(@NotNull PsiElement element) {
        if (element == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        PsiFileSystemItem fileOrDirectory = CucumberJavaScriptRunConfigurationProducer.getFileOrDirectoryToRun(element);
        String string = FileUtil.toSystemIndependentName((String)fileOrDirectory.getVirtualFile().getPath());
        if (string == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static PsiFileSystemItem getFileOrDirectoryToRun(@NotNull PsiElement element) {
        if (element == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        PsiFileSystemItem fileOrDirectory = (PsiFileSystemItem)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFileSystemItem.class, (boolean)false);
        assert (fileOrDirectory != null);
        PsiFileSystemItem psiFileSystemItem = fileOrDirectory;
        if (psiFileSystemItem == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        return psiFileSystemItem;
    }

    protected boolean setupConfigurationFromContext(CucumberJavaScriptRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiElement element = (PsiElement)sourceElement.get();
        if (element == null || configuration == null) {
            return false;
        }
        GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinScenario.class);
        if (scenario != null) {
            configuration.setName("Scenario: " + StringUtil.shortenTextWithEllipsis((String)scenario.getScenarioName(), (int)30, (int)0));
            configuration.setFilePath(CucumberJavaScriptRunConfigurationProducer.getFileToRun(element));
            configuration.setNameFilter(scenario.getScenarioName());
            return true;
        }
        if (element.getContainingFile() instanceof GherkinFile || element instanceof PsiDirectory && CucumberJavaScriptRunConfigurationProducer.hasParentCalledFeatures((PsiDirectory)element)) {
            PsiFileSystemItem container = CucumberJavaScriptRunConfigurationProducer.getFileOrDirectoryToRun(element);
            configuration.setName(container.getName());
            configuration.setFilePath(CucumberJavaScriptRunConfigurationProducer.getFileToRun(element));
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(CucumberJavaScriptRunConfiguration configuration, ConfigurationContext context) {
        PsiElement location = context.getPsiLocation();
        if (location == null) {
            return false;
        }
        if (location.getContainingFile() instanceof GherkinFile || location instanceof PsiDirectory) {
            String contextFilePath;
            GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getParentOfType((PsiElement)location.getOriginalElement(), GherkinScenario.class);
            String contextNameFilter = null;
            if (scenario != null) {
                contextNameFilter = scenario.getScenarioName();
            }
            return StringUtil.equals((CharSequence)(contextFilePath = CucumberJavaScriptRunConfigurationProducer.getFileToRun(location)), (CharSequence)configuration.getFilePath()) && StringUtil.equals((CharSequence)contextNameFilter, (CharSequence)configuration.getNameFilter());
        }
        return false;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfigurationProducer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToRun";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileOrDirectoryToRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileToRun";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrDirectoryToRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

