/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run.ui;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptBundle;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfiguration;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;

public class CucumberJavaScriptConfigurationEditorForm
extends SettingsEditor<CucumberJavaScriptRunConfiguration> {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myFileField;
    private JTextField myCucumberArguments;
    private JComponent myNodeInterpreterComponent;
    private JComponent myCucumberPackageComponent;
    private NodeJsInterpreterField myInterpreterField;
    private NodePackageField myCucumberPackageField;
    private JTextField myNameFilterField;
    private final Project myProject;

    public CucumberJavaScriptConfigurationEditorForm(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        FileChooserDescriptor fileToRunChooser = new FileChooserDescriptor(true, true, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || file.getFileType() == GherkinFileType.INSTANCE;
            }

            public boolean isFileSelectable(VirtualFile file) {
                return this.isFileVisible(file, false);
            }
        };
        String chooseFileToRunMessage = CucumberJavaScriptBundle.message("choose.gherkin.file.or.directory", new Object[0]);
        this.myFileField.addBrowseFolderListener(chooseFileToRunMessage, chooseFileToRunMessage, project, fileToRunChooser);
    }

    protected void resetEditorFrom(@NotNull CucumberJavaScriptRunConfiguration configuration) {
        if (configuration == null) {
            CucumberJavaScriptConfigurationEditorForm.$$$reportNull$$$0(0);
        }
        this.myFileField.setText(configuration.getFilePath());
        this.myCucumberArguments.setText(configuration.getCucumberJsArguments());
        this.myNameFilterField.setText(configuration.getNameFilter());
        NodeJsInterpreterRef interpreterRef = configuration.getInterpreterRef();
        this.myInterpreterField.setInterpreterRef(interpreterRef);
        NodeJsInterpreter interpreter = interpreterRef.resolve(this.myProject);
        NodePackage pkg = CucumberJavaScriptUtil.getCucumberPackage(this.myProject, interpreter);
        this.myCucumberPackageField.setSelected(pkg);
    }

    protected void applyEditorTo(@NotNull CucumberJavaScriptRunConfiguration configuration) {
        if (configuration == null) {
            CucumberJavaScriptConfigurationEditorForm.$$$reportNull$$$0(1);
        }
        configuration.setFilePath(this.myFileField.getText());
        configuration.setNameFilter(this.myNameFilterField.getText());
        configuration.setCucumberJsArguments(this.myCucumberArguments.getText());
        configuration.setInterpreterRef(this.myInterpreterField.getInterpreterRef());
        CucumberJavaScriptUtil.setCucumberPackage(configuration.getProject(), this.myCucumberPackageField.getSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            CucumberJavaScriptConfigurationEditorForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myInterpreterField = new NodeJsInterpreterField(this.myProject, false);
        this.myNodeInterpreterComponent = this.myInterpreterField;
        this.myCucumberPackageField = new NodePackageField(this.myInterpreterField, CucumberJavaScriptUtil.PKG_DESCRIPTOR, null);
        this.myCucumberPackageComponent = this.myCucumberPackageField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/ui/CucumberJavaScriptConfigurationEditorForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/ui/CucumberJavaScriptConfigurationEditorForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("choose.gherkin.file.or.directory.element.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCucumberArguments = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("cucumber.js.run.arguments.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("cucumber.js.run.executable.path.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JComponent jComponent = this.myNodeInterpreterComponent;
        jPanel.add((Component)jComponent, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myNameFilterField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("cucumber.js.run.name.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptBundle").getString("cucumber.js.run.package.label"));
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JComponent jComponent2 = this.myCucumberPackageComponent;
        jPanel.add((Component)jComponent2, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

