/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty;

import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.AbstractDockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.NettyWebTarget;
import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.UnixChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.commons.lang.SystemUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class NettyDockerCmdExecFactory
extends AbstractDockerCmdExecFactory
implements DockerCmdExecFactory {
    private static String threadPrefix = "dockerjava-netty";
    private Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private NettyInitializer nettyInitializer;
    private WebTarget baseResource;
    private ChannelProvider channelProvider = new ChannelProvider(){

        @Override
        public DuplexChannel getChannel() {
            DuplexChannel channel = NettyDockerCmdExecFactory.this.connect();
            channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(this.getClass())});
            return channel;
        }
    };
    private Integer connectTimeout = null;
    private Integer readTimeout = null;

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        super.init(dockerClientConfig);
        this.bootstrap = new Bootstrap();
        String scheme = dockerClientConfig.getDockerHost().getScheme();
        if ("unix".equals(scheme)) {
            this.nettyInitializer = new UnixDomainSocketInitializer();
        } else if ("tcp".equals(scheme)) {
            this.nettyInitializer = new InetSocketInitializer();
        }
        this.eventLoopGroup = this.nettyInitializer.init(this.bootstrap, dockerClientConfig);
        this.baseResource = new NettyWebTarget(this.channelProvider).path(dockerClientConfig.getApiVersion().asWebPathPart());
    }

    private DuplexChannel connect() {
        try {
            return this.connect(this.bootstrap);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
        return this.nettyInitializer.connect(bootstrap);
    }

    public SSLParameters enableHostNameVerification(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        return sslParameters;
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull((Object)this.eventLoopGroup, (Object)"Factory not initialized. You probably forgot to call init()!");
        this.eventLoopGroup.shutdownGracefully();
    }

    public NettyDockerCmdExecFactory withConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public NettyDockerCmdExecFactory withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private <T extends Channel> T configure(T channel) {
        ChannelConfig channelConfig = channel.config();
        if (this.connectTimeout != null) {
            channelConfig.setConnectTimeoutMillis(this.connectTimeout.intValue());
        }
        if (this.readTimeout != null) {
            channel.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler());
        }
        return channel;
    }

    @Override
    protected WebTarget getBaseResource() {
        Preconditions.checkNotNull((Object)this.baseResource, (Object)"Factory not initialized, baseResource not set. You probably forgot to call init()!");
        return this.baseResource;
    }

    private final class ReadTimeoutHandler
    extends IdleStateHandler {
        private boolean alreadyTimedOut;

        ReadTimeoutHandler() {
            super((long)NettyDockerCmdExecFactory.this.readTimeout.intValue(), 0L, 0L, TimeUnit.MILLISECONDS);
        }

        protected synchronized void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            assert (evt.state() == IdleState.READER_IDLE);
            Channel channel = ctx.channel();
            if (channel == null || !channel.isActive() || this.alreadyTimedOut) {
                return;
            }
            DockerClientConfig dockerClientConfig = NettyDockerCmdExecFactory.this.getDockerClientConfig();
            URI dockerAPIEndpoint = dockerClientConfig.getDockerHost();
            String msg = "Read timed out: No data received within " + NettyDockerCmdExecFactory.this.readTimeout + "ms.  Perhaps the docker API (" + dockerAPIEndpoint + ") is not responding normally, or perhaps you need to increase the readTimeout value.";
            SocketTimeoutException ex = new SocketTimeoutException(msg);
            ctx.fireExceptionCaught((Throwable)ex);
            this.alreadyTimedOut = true;
        }
    }

    private class InetSocketInitializer
    implements NettyInitializer {
        private InetSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(threadPrefix));
            InetAddress addr = InetAddress.getLoopbackAddress();
            InetSocketAddress proxyAddress = new InetSocketAddress(addr, 8008);
            Security.addProvider((Provider)new BouncyCastleProvider());
            ChannelFactory<NioSocketChannel> factory = new ChannelFactory<NioSocketChannel>(){

                public NioSocketChannel newChannel() {
                    return (NioSocketChannel)NettyDockerCmdExecFactory.this.configure((Channel)new NioSocketChannel());
                }
            };
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channelFactory((ChannelFactory)factory)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            DockerClientConfig dockerClientConfig = NettyDockerCmdExecFactory.this.getDockerClientConfig();
            String host = dockerClientConfig.getDockerHost().getHost();
            int port = dockerClientConfig.getDockerHost().getPort();
            if (port == -1) {
                throw new RuntimeException("no port configured for " + host);
            }
            DuplexChannel channel = (DuplexChannel)bootstrap.connect(host, port).sync().channel();
            SslHandler ssl = this.initSsl(dockerClientConfig);
            if (ssl != null) {
                channel.pipeline().addFirst(new ChannelHandler[]{ssl});
            }
            return channel;
        }

        private SslHandler initSsl(DockerClientConfig dockerClientConfig) {
            SslHandler ssl = null;
            try {
                String host = dockerClientConfig.getDockerHost().getHost();
                int port = dockerClientConfig.getDockerHost().getPort();
                SSLConfig sslConfig = dockerClientConfig.getSSLConfig();
                if (sslConfig != null && sslConfig.getSSLContext() != null) {
                    SSLEngine engine = sslConfig.getSSLContext().createSSLEngine(host, port);
                    engine.setUseClientMode(true);
                    engine.setSSLParameters(NettyDockerCmdExecFactory.this.enableHostNameVerification(engine.getSSLParameters()));
                    ssl = new SslHandler(engine);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ssl;
        }
    }

    private class UnixDomainSocketInitializer
    implements NettyInitializer {
        private UnixDomainSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            if (SystemUtils.IS_OS_LINUX) {
                return this.epollGroup();
            }
            if (SystemUtils.IS_OS_MAC_OSX) {
                return this.kqueueGroup();
            }
            throw new RuntimeException("Unspported OS");
        }

        public EventLoopGroup epollGroup() {
            EpollEventLoopGroup epollEventLoopGroup = new EpollEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(threadPrefix));
            ChannelFactory<EpollDomainSocketChannel> factory = new ChannelFactory<EpollDomainSocketChannel>(){

                public EpollDomainSocketChannel newChannel() {
                    return (EpollDomainSocketChannel)NettyDockerCmdExecFactory.this.configure((Channel)new EpollDomainSocketChannel());
                }
            };
            ((Bootstrap)((Bootstrap)NettyDockerCmdExecFactory.this.bootstrap.group((EventLoopGroup)epollEventLoopGroup)).channelFactory((ChannelFactory)factory)).handler((ChannelHandler)new ChannelInitializer<UnixChannel>(){

                protected void initChannel(UnixChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                }
            });
            return epollEventLoopGroup;
        }

        public EventLoopGroup kqueueGroup() {
            KQueueEventLoopGroup nioEventLoopGroup = new KQueueEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(threadPrefix));
            ((Bootstrap)((Bootstrap)NettyDockerCmdExecFactory.this.bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channel(KQueueDomainSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<KQueueDomainSocketChannel>(){

                protected void initChannel(KQueueDomainSocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(((Object)((Object)this)).getClass())});
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            return (DuplexChannel)bootstrap.connect((SocketAddress)new DomainSocketAddress("/var/run/docker.sock")).sync().channel();
        }
    }

    private static interface NettyInitializer {
        public EventLoopGroup init(Bootstrap var1, DockerClientConfig var2);

        public DuplexChannel connect(Bootstrap var1) throws InterruptedException;
    }
}

