/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.authentication;

import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationListener;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.authentication.facades.AuthenticationInfoCallback;
import com.microsoft.alm.plugin.authentication.facades.AuthenticationInfoProvider;
import com.microsoft.alm.plugin.authentication.facades.VsoAuthInfoProvider;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.ServerContextManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VsoAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(VsoAuthenticationProvider.class);
    public static final String VSO_AUTH_URL = "https://app.vssps.visualstudio.com";

    private AuthenticationInfoProvider getAuthenticationInfoProvider() {
        return VsoAuthInfoProvider.getProvider();
    }

    protected VsoAuthenticationProvider() {
    }

    public static VsoAuthenticationProvider getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo(String serverUri) {
        AuthenticationInfo authenticationInfo = ServerContextManager.getInstance().getBestAuthenticationInfo(serverUri, false);
        return authenticationInfo;
    }

    @Override
    public boolean isAuthenticated(String serverUri) {
        return this.getAuthenticationInfo(serverUri) != null;
    }

    @Override
    public void clearAuthenticationDetails(String serverUri) {
        ServerContextManager.getInstance().remove(serverUri);
        this.getAuthenticationInfoProvider().clearAuthenticationInfo(serverUri);
    }

    @Override
    public void authenticateAsync(final String serverUri, final AuthenticationListener listener) {
        logger.info("authenticateAsync for server: {}", (Object)serverUri);
        this.getAuthenticationInfoProvider().clearAuthenticationInfo(VSO_AUTH_URL);
        AuthenticationListener.Helper.authenticating(listener);
        this.getAuthenticationInfoProvider().getAuthenticationInfoAsync(serverUri, new AuthenticationInfoCallback(){

            @Override
            public void onSuccess(AuthenticationInfo authenticationInfo) {
                logger.info("getAuthenticationInfoAsync succeeded");
                try {
                    if (StringUtils.equalsIgnoreCase((String)serverUri, (String)VsoAuthenticationProvider.VSO_AUTH_URL)) {
                        ServerContextManager.getInstance().validateServerConnection(new ServerContextBuilder().type(ServerContext.Type.VSO_DEPLOYMENT).uri(VsoAuthenticationProvider.VSO_AUTH_URL).authentication(authenticationInfo).build());
                    } else {
                        ServerContextManager.getInstance().validateServerConnection(new ServerContextBuilder().type(ServerContext.Type.VSO).uri(serverUri).authentication(authenticationInfo).build());
                    }
                    AuthenticationListener.Helper.authenticated(listener, authenticationInfo, null);
                }
                catch (Throwable t) {
                    AuthenticationListener.Helper.authenticated(listener, AuthenticationInfo.NONE, t);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                logger.error("getAuthenticationInfoAsync failed", t);
                VsoAuthenticationProvider.this.clearAuthenticationDetails(serverUri);
                AuthenticationListener.Helper.authenticated(listener, AuthenticationInfo.NONE, t);
            }
        });
    }

    private static class Holder {
        private static VsoAuthenticationProvider INSTANCE = new VsoAuthenticationProvider();

        private Holder() {
        }
    }
}

