/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.authentication.facades;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.alm.auth.PromptBehavior;
import com.microsoft.alm.auth.oauth.OAuth2Authenticator;
import com.microsoft.alm.auth.pat.VstsPatAuthenticator;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.helpers.Action;
import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.facades.AuthenticationInfoCallback;
import com.microsoft.alm.plugin.authentication.facades.AuthenticationInfoProvider;
import com.microsoft.alm.plugin.context.RestClientHelper;
import com.microsoft.alm.plugin.exceptions.ProfileDoesNotExistException;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.services.DeviceFlowResponsePrompt;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.secret.VsoTokenScope;
import com.microsoft.alm.storage.InsecureInMemoryStore;
import com.microsoft.alm.storage.SecretStore;
import com.microsoft.visualstudio.services.account.AccountHttpClient;
import com.microsoft.visualstudio.services.account.Profile;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VsoAuthInfoProvider
implements AuthenticationInfoProvider {
    private static final Logger logger = LoggerFactory.getLogger(VsoAuthInfoProvider.class);
    private static final String CLIENT_ID = "97877f11-0fc6-4aee-b1ff-febb0519dd00";
    private static final String REDIRECT_URL = "https://java.visualstudio.com";
    private final SecretStore<TokenPair> accessTokenStore = new InsecureInMemoryStore();
    private final SecretStore<Token> tokenStore = new InsecureInMemoryStore();
    private final DeviceFlowResponsePrompt deviceFlowResponsePrompt = PluginServiceProvider.getInstance().getDeviceFlowResponsePrompt();
    private final VstsPatAuthenticator vstsPatAuthenticator = new VstsPatAuthenticator("97877f11-0fc6-4aee-b1ff-febb0519dd00", "https://java.visualstudio.com", this.accessTokenStore, this.tokenStore);

    private VsoAuthInfoProvider() {
    }

    public static VsoAuthInfoProvider getProvider() {
        return VsoJavaFxExperimentalAuthInfoProviderHolder.INSTANCE;
    }

    @Override
    public void getAuthenticationInfoAsync(String serverUri, AuthenticationInfoCallback callback) {
        final SettableFuture authenticationInfoFuture = SettableFuture.create();
        Action<String> cancellationCallback = new Action<String>(){

            public void call(String reasonForCancel) {
                authenticationInfoFuture.setException((Throwable)new AuthorizationException(reasonForCancel));
            }
        };
        OAuth2Authenticator.OAuth2AuthenticatorBuilder oAuth2AuthenticatorBuilder = new OAuth2Authenticator.OAuth2AuthenticatorBuilder().withClientId(CLIENT_ID).redirectTo(REDIRECT_URL).backedBy(this.accessTokenStore).manage("https://management.core.windows.net/").withDeviceFlowCallback(this.deviceFlowResponsePrompt.getCallback(cancellationCallback));
        OAuth2Authenticator oAuth2Authenticator = oAuth2AuthenticatorBuilder.build();
        URI encodedServerUri = UrlHelper.createUri((String)serverUri);
        TokenPair tokenPair = oAuth2Authenticator.getOAuth2TokenPair(encodedServerUri, PromptBehavior.AUTO);
        try {
            AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(encodedServerUri, tokenPair);
            if (authenticationInfo != null) {
                authenticationInfoFuture.set((Object)authenticationInfo);
            } else {
                authenticationInfoFuture.setException((Throwable)new TeamServicesException(TeamServicesException.KEY_VSO_AUTH_FAILED));
            }
        }
        catch (Throwable t) {
            authenticationInfoFuture.setException(t);
        }
        Futures.addCallback((ListenableFuture)authenticationInfoFuture, (FutureCallback)callback);
    }

    public AuthenticationInfo getAuthenticationInfo(URI serverUri, TokenPair tokenPair) {
        if (tokenPair != null) {
            Client client = RestClientHelper.getClient(serverUri.toString(), tokenPair.AccessToken.Value);
            if (client != null) {
                MyHttpClient accountHttpClient = new MyHttpClient(client, OAuth2Authenticator.APP_VSSPS_VISUALSTUDIO);
                Profile me = accountHttpClient.getMyProfile();
                String emailAddress = me.getCoreAttributes().getEmailAddress().getValue();
                String tokenDescription = AuthHelper.getTokenDescription(emailAddress);
                if (serverUri.equals(OAuth2Authenticator.APP_VSSPS_VISUALSTUDIO)) {
                    logger.debug("Creating authenticationInfo backed by AccessToken for: {}", (Object)serverUri);
                    return new AuthenticationInfo(me.getId().toString(), tokenPair.AccessToken.Value, serverUri.toString(), emailAddress, AuthenticationInfo.CredsType.AccessToken, tokenPair.RefreshToken.Value);
                }
                logger.debug("Getting a PersonalAccessToken for: {}", (Object)serverUri);
                Token token = this.vstsPatAuthenticator.getPersonalAccessToken(serverUri, VsoTokenScope.AllScopes, tokenDescription, PromptBehavior.AUTO, tokenPair);
                if (token != null) {
                    logger.debug("Creating authenticationInfo backed by PersonalAccessToken for: {}", (Object)serverUri);
                    return new AuthenticationInfo(me.getId().toString(), token.Value, serverUri.toString(), emailAddress, AuthenticationInfo.CredsType.PersonalAccessToken, null);
                }
                logger.warn("Failed to get a Personal Access Token");
            } else {
                logger.warn("Failed to get authenticated jaxrs client.");
            }
        } else {
            logger.warn("Failed to get AuthenticationInfo because AccessToken is null.");
        }
        return null;
    }

    @Override
    public void clearAuthenticationInfo(String serverUri) {
        this.vstsPatAuthenticator.signOut(URI.create(serverUri));
    }

    private class MyHttpClient
    extends AccountHttpClient {
        public MyHttpClient(Client jaxrsClient, URI baseUrl) {
            super(jaxrsClient, baseUrl);
        }

        protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
            HashMap<String, Class<? extends Exception>> map = new HashMap<String, Class<? extends Exception>>();
            map.put("ProfileDoesNotExistException", ProfileDoesNotExistException.class);
            return map;
        }
    }

    private static class VsoJavaFxExperimentalAuthInfoProviderHolder {
        public static VsoAuthInfoProvider INSTANCE = new VsoAuthInfoProvider();

        private VsoJavaFxExperimentalAuthInfoProviderHolder() {
        }
    }
}

