/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.context;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.services.HttpProxyService;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Configuration;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.VersionInfo;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class RestClientHelper {
    public static Client getClient(String serverUri, String accessTokenValue) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("accessToken", accessTokenValue);
        ClientConfig clientConfig = RestClientHelper.getClientConfig(ServerContext.Type.VSO_DEPLOYMENT, (Credentials)credentials, serverUri, PluginServiceProvider.getInstance().getHttpProxyService().useHttpProxy());
        Client localClient = ClientBuilder.newClient((Configuration)clientConfig);
        return localClient;
    }

    public static Client getClient(ServerContext.Type type, AuthenticationInfo authenticationInfo) {
        ClientConfig clientConfig = RestClientHelper.getClientConfig(type, authenticationInfo, PluginServiceProvider.getInstance().getHttpProxyService().useHttpProxy());
        Client localClient = ClientBuilder.newClient((Configuration)clientConfig);
        return localClient;
    }

    public static ClientConfig getClientConfig(ServerContext.Type type, Credentials credentials, String serverUri, boolean includeProxySettings) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, credentials);
        ApacheConnectorProvider connectorProvider = new ApacheConnectorProvider();
        JacksonJsonProvider jacksonJsonProvider = (JacksonJsonProvider)new JacksonJaxbJsonProvider().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ClientConfig clientConfig = new ClientConfig(new Object[]{jacksonJsonProvider}).connectorProvider((ConnectorProvider)connectorProvider);
        clientConfig.property("jersey.config.apache.client.credentialsProvider", (Object)credentialsProvider);
        clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        clientConfig.property("jersey.config.apache.client.preemptiveBasicAuthentication", (Object)(type != ServerContext.Type.TFS ? 1 : 0));
        if (includeProxySettings) {
            HttpProxyService proxyService = PluginServiceProvider.getInstance().getHttpProxyService();
            String proxyUrl = proxyService.getProxyURL();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyUrl);
            if (proxyService.isAuthenticationRequired()) {
                AuthScope ntlmAuthScope = new AuthScope(proxyService.getProxyHost(), proxyService.getProxyPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                credentialsProvider.setCredentials(ntlmAuthScope, (Credentials)new UsernamePasswordCredentials(proxyService.getUserName(), proxyService.getPassword()));
            }
        }
        if (RestClientHelper.isSSLEnabledOnPrem(type, serverUri)) {
            clientConfig.property("jersey.config.apache.client.ssl.sslConfig", (Object)RestClientHelper.getSslConfigurator());
        }
        clientConfig.register((Object)new ClientRequestFilter(){

            public void filter(ClientRequestContext requestContext) throws IOException {
                String userAgent = VersionInfo.getUserAgent((String)"Apache-HttpClient", (String)"org.apache.http.client", HttpClientBuilder.class);
                requestContext.getHeaders().add((Object)"User-Agent", (Object)userAgent);
            }
        });
        return clientConfig;
    }

    public static ClientConfig getClientConfig(ServerContext.Type type, AuthenticationInfo authenticationInfo, boolean includeProxySettings) {
        Credentials credentials = AuthHelper.getCredentials(type, authenticationInfo);
        return RestClientHelper.getClientConfig(type, credentials, authenticationInfo.getServerUri(), includeProxySettings);
    }

    public static boolean isSSLEnabledOnPrem(ServerContext.Type type, String serverUri) {
        return type == ServerContext.Type.TFS && serverUri.toLowerCase().startsWith("https://");
    }

    public static SslConfigurator getSslConfigurator() {
        SslConfigurator sslConfigurator = SslConfigurator.newInstance();
        RestClientHelper.setupTrustStore(sslConfigurator);
        RestClientHelper.setupKeyStore(sslConfigurator);
        return sslConfigurator;
    }

    private static SslConfigurator setupTrustStore(SslConfigurator sslConfigurator) {
        String trustStore = System.getProperty("javax.net.ssl.trustStore");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
        String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", "JKS");
        String trustManagerFactoryAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm", "PKIX");
        if (trustStore != null) {
            sslConfigurator.trustStoreFile(trustStore).trustStorePassword(trustStorePassword).trustStoreType(trustStoreType).trustManagerFactoryAlgorithm(trustManagerFactoryAlgorithm).securityProtocol("SSL");
        }
        return sslConfigurator;
    }

    private static SslConfigurator setupKeyStore(SslConfigurator sslConfigurator) {
        String keyStore = System.getProperty("javax.net.ssl.keyStore");
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
        if (keyStore != null) {
            sslConfigurator.keyStoreFile(keyStore).keyStorePassword(keyStorePassword);
        }
        return sslConfigurator;
    }
}

