/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.events;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.events.ServerEventManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPollingManager {
    private static final Logger logger = LoggerFactory.getLogger(ServerPollingManager.class);
    private static final int DEFAULT_POLLING_INTERVAL = 300000;
    private final ServerEventManager eventManager;
    private final Timer timer;
    private boolean polling = false;

    public static ServerPollingManager getInstance() {
        return Holder.INSTANCE;
    }

    protected ServerPollingManager(ServerEventManager eventManager) {
        logger.info("ServerPollingManager created");
        ArgumentHelper.checkNotNull((Object)eventManager, (String)"eventManager");
        this.eventManager = eventManager;
        this.timer = new Timer(Integer.MAX_VALUE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPollingManager.this.timerFired();
            }
        });
    }

    public void startPolling() {
        this.startPolling(300000);
    }

    public void startPolling(int intervalInMilliSeconds) {
        logger.info("Polling started");
        this.polling = true;
        if (!this.timer.isRunning()) {
            this.timer.setInitialDelay(intervalInMilliSeconds);
            this.timer.start();
        }
    }

    public void stopPolling() {
        logger.info("Polling stopped");
        this.polling = false;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    private void timerFired() {
        logger.info("Timer fired");
        this.timer.stop();
        if (!this.polling) {
            return;
        }
        HashMap<String, Object> eventContext = new HashMap<String, Object>();
        eventContext.put("sender", "pollingManager");
        this.eventManager.triggerAllEvents(eventContext);
        this.timer.restart();
    }

    private static class Holder {
        private static final ServerPollingManager INSTANCE = new ServerPollingManager(ServerEventManager.getInstance());

        private Holder() {
        }
    }
}

