/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.models.ToolVersion;
import com.microsoft.alm.plugin.external.tools.TfTool;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolRunnerCache {
    private static final Logger logger = LoggerFactory.getLogger(ToolRunnerCache.class);
    private static ConcurrentMap<String, ToolRunner> cache = new ConcurrentHashMap<String, ToolRunner>(3);

    public static ToolRunner getRunningToolRunner(String toolLocation, ToolRunner.ArgumentBuilder argumentBuilder, ToolRunner.Listener listener) {
        logger.info("getRunningToolRunner: toolLocation={0}", (Object)toolLocation);
        ToolRunner toolRunner = null;
        ToolVersion version = TfTool.getCachedVersion();
        if (version == null || version.compare(TfTool.TF_MIN_VERSION) < 0) {
            logger.info("getRunningToolRunner: slow version - " + version);
            toolRunner = ToolRunnerCache.startToolRunner(toolLocation, argumentBuilder, listener);
        } else {
            logger.info("getRunningToolRunner: fast version - " + version);
            String key = ToolRunnerCache.getKey(toolLocation, argumentBuilder);
            logger.info("getRunningToolRunner: key=" + key);
            toolRunner = (ToolRunner)cache.remove(key);
            if (toolRunner == null) {
                logger.info("getRunningToolRunner: cache miss.");
                toolRunner = ToolRunnerCache.startToolRunner(toolLocation, ToolRunnerCache.getStartAndWaitArguments(argumentBuilder), listener);
            } else {
                toolRunner.addListener(listener);
            }
            toolRunner.sendArgsViaStandardInput(argumentBuilder);
            ToolRunnerCache.updateCachedInstance(key, toolLocation, argumentBuilder);
        }
        return toolRunner;
    }

    private static ToolRunner startToolRunner(String toolLocation, ToolRunner.ArgumentBuilder argumentBuilder, ToolRunner.Listener listener) {
        ToolRunner toolRunner = new ToolRunner(toolLocation, argumentBuilder.getWorkingDirectory());
        toolRunner.addListener(listener);
        toolRunner.start(argumentBuilder);
        return toolRunner;
    }

    private static ToolRunner.ArgumentBuilder getStartAndWaitArguments(ToolRunner.ArgumentBuilder originalArgumentBuilder) {
        return new ToolRunner.ArgumentBuilder().setWorkingDirectory(originalArgumentBuilder.getWorkingDirectory()).add("@");
    }

    private static void updateCachedInstance(String key, String toolLocation, ToolRunner.ArgumentBuilder argumentBuilder) {
        logger.info("updateCachedInstance: caching a new runner: key=" + key);
        ToolRunner toolRunnerToCache = new ToolRunner(toolLocation, argumentBuilder.getWorkingDirectory());
        toolRunnerToCache.start(ToolRunnerCache.getStartAndWaitArguments(argumentBuilder));
        ToolRunner cachedToolRunner = cache.put(key, toolRunnerToCache);
        if (cachedToolRunner != null) {
            logger.info("updateCachedInstance: disposing of cached tool runner.");
            cachedToolRunner.dispose();
        }
    }

    private static String getKey(String toolLocation, ToolRunner.ArgumentBuilder argumentBuilder) {
        ArgumentHelper.checkNotEmptyString((String)toolLocation, (String)"toolLocation");
        if (argumentBuilder != null && argumentBuilder.getWorkingDirectory() != null) {
            return toolLocation.toLowerCase() + "|" + argumentBuilder.getWorkingDirectory().toLowerCase();
        }
        return toolLocation.toLowerCase() + "|";
    }
}

