/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AddCommand
extends Command<List<String>> {
    private final List<String> unversionedFiles;

    public AddCommand(ServerContext context, List<String> unversionedFiles) {
        super("add", context);
        ArgumentHelper.checkNotNullOrEmpty(unversionedFiles, (String)"unversionedFiles");
        this.unversionedFiles = unversionedFiles;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        for (String file : this.unversionedFiles) {
            builder.add(file);
        }
        return builder;
    }

    @Override
    public List<String> parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        ArrayList<String> filesAdded = new ArrayList<String>();
        String[] output = this.getLines(stdout);
        String path = "";
        for (String line : output) {
            if (this.isFilePath(line)) {
                path = line;
                continue;
            }
            if (!StringUtils.isNotEmpty((String)line)) continue;
            filesAdded.add(this.getFilePath(path, line, ""));
        }
        return filesAdded;
    }
}

