/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.ToolRunnerCache;
import com.microsoft.alm.plugin.external.commands.ToolEulaNotAcceptedException;
import com.microsoft.alm.plugin.external.exceptions.ToolException;
import com.microsoft.alm.plugin.external.exceptions.ToolMemoryException;
import com.microsoft.alm.plugin.external.exceptions.ToolParseFailureException;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.tools.TfTool;
import com.microsoft.alm.plugin.external.utils.WorkspaceHelper;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import sun.security.util.Debug;

public abstract class Command<T> {
    private static final Logger logger = LoggerFactory.getLogger(Command.class);
    private static final Pattern CHANGESET_NUMBER_PATTERN = Pattern.compile("#(\\d+)");
    public static final int OUTPUT_TYPE_INFO = 0;
    public static final int OUTPUT_TYPE_WARNING = 1;
    public static final int OUTPUT_TYPE_ERROR = 2;
    private static final String WARNING_PREFIX = "WARN ";
    private static final String XML_PREFIX = "<?xml ";
    private final String name;
    private final boolean useProxyIfAvailable;
    private final ServerContext context;

    public Command(String name, ServerContext context) {
        this(name, context, true);
    }

    public Command(String name, ServerContext context, boolean useProxyIfAvailable) {
        this.name = name;
        this.context = context;
        this.useProxyIfAvailable = useProxyIfAvailable;
    }

    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = new ToolRunner.ArgumentBuilder().add(this.name).addSwitch("noprompt");
        if (this.context != null && this.context.getCollectionURI() != null) {
            String proxyURI;
            String collectionURI = this.context.getCollectionURI().toString();
            try {
                builder.addSwitch("collection", URLDecoder.decode(collectionURI, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Error while decoding collection url. Using encoded url instead", (Throwable)e);
                builder.addSwitch("collection", collectionURI);
            }
            if (this.context.getAuthenticationInfo() != null) {
                builder.addAuthInfo(this.context.getAuthenticationInfo());
            }
            if (this.useProxyIfAvailable && StringUtils.isNotEmpty((String)(proxyURI = WorkspaceHelper.getProxyServer(collectionURI)))) {
                builder.addSwitch("proxy", proxyURI);
            }
        }
        return builder;
    }

    public void run(final Listener<T> listener) {
        final StringBuilder stdout = new StringBuilder();
        final StringBuilder stderr = new StringBuilder();
        ArgumentHelper.checkNotNull(listener, (String)"listener");
        ToolRunner runner = ToolRunnerCache.getRunningToolRunner(TfTool.getValidLocation(), this.getArgumentBuilder(), new ToolRunner.Listener(){

            @Override
            public void processStandardOutput(String line) {
                logger.info("CMD: " + line);
                stdout.append(line + "\n");
                listener.progress(line, 0, 50);
            }

            @Override
            public void processStandardError(String line) {
                logger.info("ERROR: " + line);
                stderr.append(line + "\n");
                listener.progress(line, 2, 50);
            }

            @Override
            public void processException(Throwable throwable) {
                logger.info("ERROR: " + throwable.toString());
                listener.progress("", 0, 100);
                listener.completed(null, throwable);
            }

            @Override
            public void completed(int returnCode) {
                listener.progress("Parsing command output", 0, 99);
                Throwable error = null;
                Object result = null;
                try {
                    result = Command.this.parseOutput(stdout.toString(), stderr.toString());
                    if (Command.this.shouldThrowBadExitCode()) {
                        TfTool.throwBadExitCode(Command.this.interpretReturnCode(returnCode));
                    }
                }
                catch (Throwable throwable) {
                    logger.warn("CMD: parsing output failed", throwable);
                    error = Command.this.isMemoryException(stdout.toString()) ? new ToolMemoryException(TfTool.getLocation()) : throwable;
                }
                listener.progress("", 0, 100);
                listener.completed(result, error);
            }
        });
    }

    @VisibleForTesting
    protected boolean isMemoryException(String output) {
        if (output.replace("\r\n", "\n").contains(ToolMemoryException.getErrorMsg())) {
            logger.warn("Memory error found for TF tool");
            return true;
        }
        return false;
    }

    public T runSynchronously() {
        long startTime = System.nanoTime();
        final SettableFuture syncResult = SettableFuture.create();
        final SettableFuture syncError = SettableFuture.create();
        this.run(new Listener<T>(){

            @Override
            public void progress(String output, int outputType, int percentComplete) {
            }

            @Override
            public void completed(T result, Throwable error) {
                syncResult.set(result);
                syncError.set((Object)error);
            }
        });
        try {
            Throwable error = (Throwable)syncError.get();
            if (error != null) {
                if (error.getMessage().contains("tf eula")) {
                    throw new ToolEulaNotAcceptedException(error);
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new ToolException(ToolException.KEY_TF_BAD_EXIT_CODE, error);
            }
            Object object = syncResult.get();
            return (T)object;
        }
        catch (InterruptedException e) {
            logger.error("CMD: failure", (Throwable)e);
            throw new ToolException(ToolException.KEY_TF_BAD_EXIT_CODE, e);
        }
        catch (ExecutionException e) {
            logger.error("CMD: failure", (Throwable)e);
            throw new ToolException(ToolException.KEY_TF_BAD_EXIT_CODE, e);
        }
        finally {
            long endTime = System.nanoTime();
            logger.info(Long.toString(endTime - startTime) + "(ns) - elapsed time for " + this.getArgumentBuilder().toString());
            Debug.println("", Long.toString(endTime - startTime) + "(ns) - elapsed time for " + this.getArgumentBuilder().toString());
        }
    }

    public abstract T parseOutput(String var1, String var2);

    public int interpretReturnCode(int returnCode) {
        return returnCode;
    }

    protected NodeList evaluateXPath(String stdout, String xpathQuery) {
        if (StringUtils.isEmpty((String)stdout)) {
            return null;
        }
        int xmlStart = stdout.indexOf(XML_PREFIX);
        InputSource xmlInput = xmlStart > 0 ? new InputSource(new StringReader(stdout.substring(xmlStart))) : new InputSource(new StringReader(stdout));
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Object result = xpath.evaluate(xpathQuery, xmlInput, XPathConstants.NODESET);
            if (result != null && result instanceof NodeList) {
                return (NodeList)result;
            }
        }
        catch (XPathExpressionException inner) {
            throw new ToolParseFailureException(inner);
        }
        throw new ToolParseFailureException();
    }

    protected String getXPathAttributeValue(NamedNodeMap attributeMap, String attributeName) {
        Node node;
        String value = "";
        if (attributeMap != null && (node = attributeMap.getNamedItem(attributeName)) != null) {
            value = node.getNodeValue();
        }
        return value;
    }

    protected String[] getLines(String buffer) {
        return this.getLines(buffer, true);
    }

    protected String[] getLines(String buffer, boolean skipWarnings) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(buffer.replace("\r\n", "\n").split("\n")));
        if (skipWarnings) {
            while (lines.size() > 0 && StringUtils.startsWithIgnoreCase((String)((String)lines.get(0)), (String)WARNING_PREFIX)) {
                lines.remove(0);
            }
        }
        return lines.toArray(new String[lines.size()]);
    }

    protected String getChangesetNumber(String buffer) {
        String changesetNumber = "";
        Matcher matcher = CHANGESET_NUMBER_PATTERN.matcher(buffer);
        if (matcher.find()) {
            changesetNumber = matcher.group(1);
            logger.info("Changeset '" + changesetNumber + "' was created");
        } else {
            logger.info("Changeset pattern not found in buffer: " + buffer);
        }
        return changesetNumber;
    }

    protected boolean isOutputLineExpected(String line, String[] expectedPrefixes, boolean filePathsAreExpected) {
        String trimmed;
        String string = trimmed = line != null ? line.trim() : null;
        if (StringUtils.isNotEmpty((String)trimmed)) {
            if (filePathsAreExpected && this.isFilePath(line)) {
                return true;
            }
            if (expectedPrefixes != null) {
                for (String prefix : expectedPrefixes) {
                    if (!StringUtils.startsWithIgnoreCase((String)line, (String)prefix)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected boolean isFilePath(String line) {
        return StringUtils.endsWith((String)line, (String)":") && StringUtils.containsAny((String)line, (String)"\\/");
    }

    protected String getFilePath(String path, String filename, String pathRoot) {
        String folderPath = StringUtils.removeEnd((String)path, (String)":");
        if (!Path.isAbsolute((String)folderPath) && StringUtils.isNotEmpty((String)pathRoot)) {
            folderPath = Path.combine((String)pathRoot, (String)folderPath);
        }
        return Path.combine((String)folderPath, (String)filename);
    }

    protected void throwIfError(String stderr) {
        if (StringUtils.isNotEmpty((String)stderr)) {
            throw new RuntimeException(stderr);
        }
    }

    protected Workspace.Mapping getMapping(String line) {
        int startIndex;
        boolean isCloaked = StringUtils.startsWithIgnoreCase((String)line.trim(), (String)"(cloaked)");
        int endIndex = line.indexOf(":");
        int n = startIndex = isCloaked ? line.indexOf(")") + 1 : 0;
        if (endIndex >= 0) {
            String serverPath = line.substring(startIndex, endIndex).trim();
            String localPath = line.substring(endIndex + 1).trim();
            return new Workspace.Mapping(serverPath, localPath, isCloaked);
        }
        return null;
    }

    protected boolean shouldThrowBadExitCode() {
        return true;
    }

    public static interface Listener<T> {
        public void progress(String var1, int var2, int var3);

        public void completed(T var1, Throwable var2);
    }
}

